; ==========================================================================
; Atari Eye Candy Demo for LOGIKER'S 2024 CHRISTMAS CONTEST 
; 
; Version 2.  Spent some time upgrading the display . . . .
;
; Written for Atari 8-bit computers.
; Should work on any model.
; Should work on any memory size capable of running DOS to load an XEX.
;
; Assembly source intended for MADS assembler.
;
; 1) Setup the Display.
; 2) Run a loop to restuff the color registers every scan line.
;
; ==========================================================================
;
; Original 19-byte gift picture:
;
;     00000000001111111111222222222233
;     01234567890123456789012345678901
; 00 "        \O/         "
; 01 "+--------+--------+ "
; 02 "!        !        ! "
; 03 "!        !        ! "
; 04 "!        !        ! "
; 05 "!        !        ! "
; 06 "!        !        ! "
; 07 "!        !        ! "
; 08 "!        !        ! "
; 09 "!        !        ! "
; 10 "+--------+--------+ "
; 11 "!        !        ! "
; 12 "!        !        ! "
; 13 "!        !        ! "
; 14 "!        !        ! "
; 15 "!        !        ! "
; 16 "!        !        ! "
; 17 "!        !        ! "
; 18 "!        !        ! "
; 19 "+--------+--------+ "
;
; ==========================================================================
;
; OS/DOS Register . . .
RTCLOK60 = $14 ; incremented every jiffy/frame.
ATRACT   = $4D ; Color cycling attract mode.   We want to keep this off.

DOS_RUN_ADDR = $02E0   ; Execute at the address stored here when file loading completes.

; GTIA Color registers
COLPF0 = $D016 ; Playfield 0 color
COLPF1 = $D017 ; Playfield 1 color
COLPF2 = $D018 ; Playfield 2 color
COLPF3 = $D019 ; Playfield 3 color (and fifth Player color)
COLBK =  $D01A ; Playfield Background color

COLOR4 =  $02C8 ; COLBK  - Playfield Background color (Border for modes 2, 3, and F)

; ANTIC Registers
CHBASE = $D409 ; Character Set Base Address (high)
WSYNC =  $D40A ; Wait for Horizontal Sync
VCOUNT = $D40B ; (Read) Vertical Scan Line Counter


; OS Shadow registers for ANTIC.  
SDMCTL = $022F ; DMACTL - DMA Control of ANTIC
SDLSTL = $0230 ; DLISTL - Address of Display List
CHBAS  = $02F4 ; CHBASE - Starting Page for character set.

; Values . . . . .
PLAYFIELD_WIDTH_NORMAL = %00000010 ; 20 or 40 characters/160 color clocks
ENABLE_DL_DMA          = %00100000 ; Enable running the Display List

DL_BLANK_4 = $30       ; 8 Blank Scan lines
DL_BLANK_8 = $70       ; 8 Blank Scan lines
DL_LMS     = %01000000 ; Reload Memory Scan address for a display list graphics line
DL_TEXT_6  = $06       ; Text. 5 color mode, 20 Columns x 8 Scan lines, or 20 bytes per line
DL_JUMP_VB = $41       ; Display List jump to address and start Vertical Blank

; ==========================================================================

; Put the gradient color controls in page 0.

	ORG $82
	
BOW_TIMER_SPEED=2

BOW_TIMER
	.byte LINES_TIMER_SPEED

BOW_INDEX_LIMIT=32

BOW_INDEX
	.byte 0
	
BOW_INDEX_TEMP
	.byte 0


FLURF_TIMER_SPEED=1

FLURF_TIMER
	.byte LINES_TIMER_SPEED

FLURF_INDEX_LIMIT=32

FLURF_INDEX
	.byte 0
	
FLURF_INDEX_TEMP
	.byte 0


LINES_TIMER_SPEED=10

LINES_TIMER
	.byte LINES_TIMER_SPEED

LINES_INDEX_LIMIT=48

LINES_INDEX
	.byte LINES_INDEX_LIMIT
	
LINES_INDEX_TEMP
	.byte LINES_INDEX_LIMIT
	
	
FILL1_TIMER_SPEED=1

FILL1_TIMER
	.byte FILL1_TIMER_SPEED

FILL1_INDEX_LIMIT=88

FILL1_INDEX
	.byte FILL1_INDEX_LIMIT
	
FILL1_INDEX_TEMP
	.byte FILL1_INDEX_LIMIT
	
	
FILL2_TIMER_SPEED=4

FILL2_TIMER
	.byte FILL2_TIMER_SPEED

FILL2_INDEX_LIMIT=88

FILL2_INDEX
	.byte 0
	
FILL2_INDEX_TEMP
	.byte 0
	
	
FILL3_TIMER_SPEED=2

FILL3_TIMER
	.byte FILL3_TIMER_SPEED

FILL3_INDEX_LIMIT=88

FILL3_INDEX
	.byte FILL3_INDEX_LIMIT
	
FILL3_INDEX_TEMP
	.byte FILL3_INDEX_LIMIT
	
	
FILL4_TIMER_SPEED=6

FILL4_TIMER
	.byte FILL4_TIMER_SPEED

FILL4_INDEX_LIMIT=88

FILL4_INDEX
	.byte FILL4_INDEX_LIMIT
	
FILL4_INDEX_TEMP
	.byte FILL4_INDEX_LIMIT
	

; ==========================================================================

	ORG $3800          ; After Atari DOS 2.0s and Dup.  Before 16K.

NEW_CSET               ; Base address of redefined character set.

	; Blank out first char (char id $00) for blank space.
	.byte $00,$00,$00,$00,$00,$00,$00,$00
	
	; Left "T" graphics character follows at id $01
	; ..****..  $3c
	; ..****..  $3c
	; ..******  $3f
	; ..******  $3f
	; ..******  $3f
	; ..******  $3f
	; ..****..  $3c
	; ..****..  $3c
	.byte $3c,$3c,$3f,$3f,$3f,$3f,$3c,$3c

	ORG $3800+[$03*8]
	
	; Lower Right Corner at id $03	
	; ..****..  $3c
	; ..****..  $3c
	; ******..  $fc
	; ******..  $fc
	; ******..  $fc
	; ******..  $fc
	; ........  $00
	; ........  $00
	.byte $3c,$3c,$fc,$fc,$fc,$fc,$00,$00
	
	;  Right "T" graphics character follows at id $04
	; ..****..  $3c
	; ..****..  $3c
	; ******..  $fc
	; ******..  $fc
	; ******..  $fc
	; ******..  $fc
	; ..****..  $3c
	; ..****..  $3c
	.byte $3c,$3c,$fc,$fc,$fc,$fc,$3c,$3c

	; Upper Right Corner follows at id $05	
	; ........  $00
	; ........  $00
	; ******..  $fc
	; ******..  $fc
	; ******..  $fc
	; ******..  $fc
	; ..****..  $3c
	; ..****..  $3c
	.byte $00,$00,$fc,$fc,$fc,$fc,$3c,$3c
	
	; Right Slash / follows at id $06
	; .**...**  $63
	; ..**.**.  $36
	; ...***..  $1c
	; ...**..*  $19
	; ...**..*  $19
	; ..**.**.  $36
	; .***....  $70
	; **......  $c0
	.byte $63,$36,$1c,$19,$19,$36,$70,$c0

	; Left  Slash \ follows at id $07
	; **...**.  $c6
	; .**.**..  $6c
	; ..***...  $38
	; *..**...  $98
	; *..**...  $98
	; .**.**..  $6c
	; ....***.  $0e
	; ......**  $03
	.byte $c6,$6c,$38,$98,$98,$6c,$0e,$03 
	
	ORG $3800+[$09*8]
	
	; Upgrade small corner box into two corner boxes at id $09 used instead of \
	; ****....  $f0
	; ****....  $f0
	; ****....  $f0
	; ****....  $f0
	; ....****  $0f
	; ....****  $0f
	; ....****  $0f
	; ....****  $0f
	.byte $00,$f0,$f0,$00,$00,$0f,$0f,$00

	ORG $3800+[$0f*8]

	; Upgrade small corner box into two corner boxes at id $0f used instead of /
	; ....****  $0f
	; ....****  $0f
	; ....****  $0f
	; ....****  $0f
	; ****....  $f0
	; ****....  $f0
	; ****....  $f0
	; ****....  $f0
	.byte $00,$0f,$0f,$00,$00,$f0,$f0,$00

	ORG $3800+[$11*8]
	
	; Upper Left Corner at id $11	
	; ........  $00
	; ........  $00
	; ..******  $3f
	; ..******  $3f
	; ..******  $3f
	; ..******  $3f
	; ..****..  $3c
	; ..****..  $3c
	.byte $00,$00,$3f,$3f,$3f,$3f,$3c,$3c

	; Center Horizontal Bar follows at id $12	
	; ........  $00
	; ........  $00
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ........  $00
	; ........  $00
	.byte $00,$00,$ff,$ff,$ff,$ff,$00,$00

	; Center cross follows at id $13
	; ..****..  $3c
	; ..****..  $3c
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ..****..  $3c
	; ..****..  $3c
	.byte $3c,$3c,$ff,$ff,$ff,$ff,$3c,$3c
	
	ORG $3800+[$17*8]
	
	; Top "T" follos at id $17.	
	; ........  $00
	; ........  $00
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ..****..  $3c
	; ..****..  $3c
	.byte $00,$00,$ff,$ff,$ff,$ff,$3c,$3c
	
	; Bottom  "T" follos at id $18.	
	; ..****..  $3c
	; ..****..  $3c
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ********  $ff
	; ........  $00
	; ........  $00
	.byte $3c,$3c,$ff,$ff,$ff,$ff,$00,$00
	
	ORG $3800+[$1a*8]
	
	; Lower Left corner at id $1a
	; ..****..  $3c
	; ..****..  $3c
	; ..******  $3f
	; ..******  $3f
	; ..******  $3f
	; ..******  $3f
	; ........  $00
	; ........  $00
	.byte $3c,$3c,$3f,$3f,$3f,$3f,$00,$00	

	ORG $3800+[$2f*8]
	
	; Lower Left corner at id $1a
	; *.....*.  $82
	; .......*  $01
	; .*......  $40
	; *.*..*..  $a4
	; .*..*.*.  $4a
	; ....*.*.  $0a
	; .....*.*  $05
	; *.....*.  $82
	.byte $82,$01,$40,$a4,$4a,$0a,$05,$82	

	ORG $3800+[$3c*8]
	
	; Center Vertical Bar id $3c
	; ..****..  $3c
	; ..****..  $3c
	; ..****..  $3c
	; ..****..  $3c
	; ..****..  $3c
	; ..****..  $3c
	; ..****..  $3c
	; ..****..  $3c
	.byte $3c,$3c,$3c,$3c,$3c,$3c,$3c,$3c



; ==========================================================================

	ORG $3A00          ; Reserve $200 for Mode 6 character set.

; ==========================================================================

; Rather than drawing out the entire screen ram, we're only defining the 
; lines that are unique.    The Display list will be defined to re-use 
; each of the lines as needed.   (In a way this is a kind of real-time,
; hardware-oriented compression of screen memory.)

;         \\  ooo  //
;          \\ooooo//    
;           \\ooo// 


LINE_1
	.byte $00,$00,$00,$00,$00,$07,$07,$00,$00,$6f,$6f,$6f,$00,$00,$06,$06,$00,$00,$00,$00 ; Bow Lines
	.byte $00,$00,$00,$00,$00,$00,$07,$07,$6f,$6f,$6f,$6f,$6f,$06,$06,$00,$00,$00,$00,$00 ; Bow Lines
	.byte $00,$00,$00,$00,$00,$00,$00,$07,$07,$6f,$6f,$6f,$06,$06,$00,$00,$00,$00,$00,$00 ; Bow Lines
LINE_2
	.byte $00,$51,$52,$52,$52,$52,$52,$52,$52,$52,$57,$52,$52,$52,$52,$52,$52,$52,$52,$45 ; Top Line
LINE_3
	.byte $00,$7c,$8f,$8f,$8f,$8f,$8f,$8f,$8f,$8f,$7c,$c9,$c9,$C9,$C9,$C9,$C9,$C9,$C9,$7C ; Fill Type 1
LINE_4
	.byte $00,$41,$52,$52,$52,$52,$52,$52,$52,$52,$53,$52,$52,$52,$52,$52,$52,$52,$52,$44 ; Middle Line
LINE_5
	.byte $00,$7c,$C9,$C9,$C9,$C9,$C9,$C9,$C9,$C9,$7C,$8f,$8f,$8f,$8f,$8f,$8f,$8f,$8f,$7C ; Fill Type 2
LINE_6
	.byte $00,$5a,$52,$52,$52,$52,$52,$52,$52,$52,$58,$52,$52,$52,$52,$52,$52,$52,$52,$43 ; Bottom Line
LINE_M
	.byte $00,$00,$00,$00,$00,$00,$00,$2d,$00,$65,$00,$32,$00,$72,$00,$39,$00,$00,$00,$00 ; MERRY
	.byte $00,$00,$63,$00,$28,$00,$72,$00,$29,$00,$73,$00,$34,$00,$6d,$00,$21,$00,$73,$00 ; CHRISTMAS
	.byte $00,$00,$00,$00,$00,$00,$00,$12,$00,$10,$00,$12,$00,$14,$00,$00,$00,$00,$00,$00 ; 2024

	
; DISPLAY LIST
; Total DL size == 2 (blanks) + 20 (Mode 2) + 34 (17 LMS addresses) + 1 (JVB) == 57 bytes

DISPLAY_LIST
	.byte DL_BLANK_8,DL_BLANK_8,DL_BLANK_8 ;   24 blank lines to start with.
	.byte DL_LMS|DL_TEXT_6
	.word LINE_1                               ; (1) Line 1, Bow
	.byte DL_TEXT_6,DL_TEXT_6                  ; And next two lines of bow.
	
	.byte DL_TEXT_6,DL_TEXT_6,DL_LMS|DL_TEXT_6 ; (2) Line2, (3) Line 3, (4) Then LMS back to Line 3 again
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (5) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (6) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (7) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (9) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (9) Repeat Line 3 again...
	.word LINE_3
	.byte DL_LMS|DL_TEXT_6                     ; (10) Repeat Line 3 again...
	.word LINE_3
	.byte DL_TEXT_6                     ; (11) Go back to Line 2 ...
;	.word LINE_4
	.byte DL_TEXT_6
;	.word LINE_3
	.byte DL_LMS|DL_TEXT_6           ; (12) Line 3, (13) Then LMS back to Line 3 again
	.word LINE_5
	.byte DL_LMS|DL_TEXT_6                     ; (14) Repeat Line 3 again...
	.word LINE_5
	.byte DL_LMS|DL_TEXT_6                     ; (15) Repeat Line 3 again...
	.word LINE_5
	.byte DL_LMS|DL_TEXT_6                     ; (16) Repeat Line 3 again...
	.word LINE_5
	.byte DL_LMS|DL_TEXT_6                     ; (17) Repeat Line 3 again...
	.word LINE_5
	.byte DL_LMS|DL_TEXT_6                     ; (18) Repeat Line 3 again...
	.word LINE_5
	.byte DL_LMS|DL_TEXT_6                     ; (19) Repeat Line 3 again...
	.word LINE_5
	.byte DL_TEXT_6                     ; (20) Go back to Line 2 ...
;	.word LINE_5
	.byte DL_BLANK_4                           ; 4 blank scan lines.
	.byte DL_TEXT_6                     ; Merry
	.byte DL_TEXT_6                     ; Christmas
	.byte DL_TEXT_6                     ; 2024
	
	.byte DL_JUMP_VB                           ; JuMP for Vertical Blank
	.word DISPLAY_LIST


; ==========================================================================

; Data Tables of colors.

BOW_GRADIENT
	.byte $18,$16,$14,$16,$18,$1c,$1e,$1c
	.byte $18,$16,$14,$16,$18,$1c,$1e,$1c
	.byte $18,$16,$14,$16,$18,$1c,$1e,$1c
	.byte $18,$16,$14,$16,$18,$1c,$1e,$1c
	.byte $18,$16,$14,$16,$18,$1c,$1e,$1c
	.byte $18,$16,$14,$16,$18,$1c,$1e,$1c
	.byte $18,$16,$14,$16,$18,$1c,$1e,$1c
	

; ==========================================================================

FLURF_GRADIENT
	.byte $8,$6,$4,$6,$8,$c,$e,$c
	.byte $8,$6,$4,$6,$8,$c,$e,$c
	.byte $8,$6,$4,$6,$8,$c,$e,$c
	.byte $8,$6,$4,$6,$8,$c,$e,$c
	.byte $8,$6,$4,$6,$8,$c,$e,$c
	.byte $8,$6,$4,$6,$8,$c,$e,$c
	.byte $34,$34

	.byte $8,$6,$4,$6,$8,$c,$e,$c

; ==========================================================================




LINES_GRADIENT
	.byte $ce,$ce,$ce,$ce,$cc,$cc,$cc,$cc
	.byte $ca,$ca,$ca,$ca,$ca,$c8,$c8,$c8
	.byte $c8,$c8,$c8,$c6,$c6,$c6,$c6,$c6
	.byte $c4,$c4,$c4,$c4,$c4,$c6,$c6,$c6
	.byte $c6,$c6,$c8,$c8,$c8,$c8,$c8,$c8
	.byte $ca,$ca,$ca,$ca,$ca,$cc,$cc,$cc
	.byte $cc
	.byte $ce,$ce,$ce,$ce,$cc,$cc,$cc,$cc
	.byte $ca,$ca,$ca,$ca,$ca,$c8,$c8,$c8
	.byte $c8,$c8,$c8,$c6,$c6,$c6,$c6,$c6
	.byte $c4,$c4,$c4,$c4,$c4,$c6,$c6,$c6
	.byte $c6,$c6,$c8,$c8,$c8,$c8,$c8,$c8
	.byte $ca,$ca,$ca,$ca,$ca,$cc,$cc,$cc
	.byte $cc
	.byte $ce,$ce,$ce,$ce,$cc,$cc,$cc,$cc
	.byte $ca,$ca,$ca,$ca,$ca,$c8,$c8,$c8
	.byte $c8,$c8,$c8,$c6,$c6,$c6,$c6,$c6
	.byte $c4,$c4,$c4,$c4,$c4,$c6,$c6,$c6
	.byte $c6,$c6,$c8,$c8,$c8,$c8,$c8,$c8
	.byte $ca,$ca,$ca,$ca,$ca,$cc,$cc,$cc
	.byte $cc
	.byte $ce,$ce,$ce,$ce,$cc,$cc,$cc,$cc
	.byte $ca,$ca,$ca,$ca,$ca,$c8,$c8,$c8
	.byte $c8,$c8,$c8,$c6,$c6,$c6,$c6,$c6
	.byte $c4,$c4,$c4,$c4,$c4,$c6,$c6,$c6
	.byte $c6,$c6,$c8,$c8,$c8,$c8,$c8,$c8
	.byte $ca,$ca,$ca,$ca,$ca,$cc,$cc,$cc
	.byte $cc
	.byte $0F,$0a,$0f,$0a
	.byte $ce,$ce,$ce,$ce,$cc,$cc,$cc,$cc


; ==========================================================================

; Gradient controls for the box fill 1. COLPF2  -- 1, 2, 3

	
FILL1_GRADIENT
	.byte $1e,$1e,$1c,$1c,$1a,$1a,$18,$18
	.byte $16,$16,$14,$14,$16,$16,$18,$18
	.byte $1a,$1a,$1c,$1c,$1e,$1e,$2e,$2e
	.byte $2c,$2c,$2a,$2a,$28,$28,$26,$26
	.byte $24,$24,$26,$26,$28,$28,$2a,$2a
	.byte $2c,$2c,$2e,$2e,$3e,$3e,$3c,$3c
	.byte $3a,$3a,$38,$38,$36,$36,$34,$34
	.byte $36,$36,$38,$38,$3a,$3a,$3c,$3c
	.byte $3e,$3e,$2e,$2e,$2c,$2c,$2a,$2a
	.byte $28,$28,$26,$26,$24,$24,$26,$26
	.byte $28,$28,$2a,$2a,$2c,$2c,$2e,$2e

	.byte $1e,$1e,$1c,$1c,$1a,$1a,$18,$18
	.byte $16,$16,$14,$14,$16,$16,$18,$18
	.byte $1a,$1a,$1c,$1c,$1e,$1e,$2e,$2e
	.byte $2c,$2c,$2a,$2a,$28,$28,$26,$26
	.byte $24,$24,$26,$26,$28,$28,$2a,$2a
	.byte $2c,$2c,$2e,$2e,$3e,$3e,$3c,$3c
	.byte $3a,$3a,$38,$38,$36,$36,$34,$34
	.byte $36,$36,$38,$38,$3a,$3a,$3c,$3c
	.byte $3e,$3e,$2e,$2e,$2c,$2c,$2a,$2a
	.byte $28,$28,$26,$26,$24,$24,$26,$26
	.byte $28,$28,$2a,$2a,$2c,$2c,$2e,$2e

	.byte $1e,$1e,$1c,$1c,$1a,$1a,$18,$18
	.byte $16,$16,$14,$14,$16,$16,$18,$18
	.byte $1a,$1a,$1c,$1c,$1e,$1e,$2e,$2e
	.byte $2c,$2c,$2a,$2a,$28,$28,$26,$26
	.byte $24,$24,$26,$26,$28,$28,$2a,$2a
	.byte $2c,$2c,$2e,$2e,$3e,$3e,$3c,$3c
	.byte $3a,$3a,$38,$38,$36,$36,$34,$34
	.byte $36,$36,$38,$38,$3a,$3a,$3c,$3c
	.byte $3e,$3e,$2e,$2e,$2c,$2c,$2a,$2a
	.byte $28,$28,$26,$26,$24,$24,$26,$26
	.byte $28,$28,$2a,$2a,$2c,$2c,$2e,$2e




; ==========================================================================

; Gradient controls for the box fill 2. COLPF3  -- 6, 7, 8


FILL2_GRADIENT
	.byte $6e,$6c,$6a,$68
	.byte $66,$64,$66,$68
	.byte $6a,$6c,$6e,$7e
	.byte $7c,$7a,$78,$76
	.byte $74,$76,$78,$7a
	.byte $7c,$7e,$8e,$8c
	.byte $8a,$88,$86,$84
	.byte $86,$88,$8a,$8c
	.byte $8e,$7e,$7c,$7a
	.byte $78,$76,$74,$76
	.byte $78,$7a,$7c,$7e

	.byte $6e,$6c,$6a,$68
	.byte $66,$64,$66,$68
	.byte $6a,$6c,$6e,$7e
	.byte $7c,$7a,$78,$76
	.byte $74,$76,$78,$7a
	.byte $7c,$7e,$8e,$8c
	.byte $8a,$88,$86,$84
	.byte $86,$88,$8a,$8c
	.byte $8e,$7e,$7c,$7a
	.byte $78,$76,$74,$76
	.byte $78,$7a,$7c,$7e

	.byte $6e,$6c,$6a,$68
	.byte $66,$64,$66,$68
	.byte $6a,$6c,$6e,$7e
	.byte $7c,$7a,$78,$76
	.byte $74,$76,$78,$7a
	.byte $7c,$7e,$8e,$8c
	.byte $8a,$88,$86,$84
	.byte $86,$88,$8a,$8c
	.byte $8e,$7e,$7c,$7a
	.byte $78,$76,$74,$76
	.byte $78,$7a,$7c,$7e

	.byte $6e,$6c,$6a,$68
	.byte $66,$64,$66,$68
	.byte $6a,$6c,$6e,$7e
	.byte $7c,$7a,$78,$76
	.byte $74,$76,$78,$7a
	.byte $7c,$7e,$8e,$8c
	.byte $8a,$88,$86,$84
	.byte $86,$88,$8a,$8c
	.byte $8e,$7e,$7c,$7a
	.byte $78,$76,$74,$76
	.byte $78,$7a,$7c,$7e


	.byte $6e,$6c,$6a,$68
	.byte $66,$64,$66,$68
	.byte $6a,$6c,$6e,$7e
	.byte $7c,$7a,$78,$76
	.byte $74,$76,$78,$7a
	.byte $7c,$7e,$8e,$8c
	.byte $8a,$88,$86,$84
	.byte $86,$88,$8a,$8c
	.byte $8e,$7e,$7c,$7a
	.byte $78,$76,$74,$76
	.byte $78,$7a,$7c,$7e




; ==========================================================================

; Gradient controls for the box fill 3. COLPF2 -- 3, 4, 5


FILL3_GRADIENT
	.byte $3e,$3e,$3c,$3c
	.byte $3a,$3a,$38,$38,$36,$36,$34,$34
	.byte $36,$36,$38,$38,$3a,$3a,$3c,$3c
	.byte $3e,$3e
	.byte $4e,$4e,$4c,$4c,$4a,$4a
	.byte $48,$48,$46,$46,$44,$44,$46,$46
	.byte $48,$48,$4a,$4a,$4c,$4c,$4e,$4e
	.byte $5e,$5e,$5c,$5c,$5a,$5a,$58,$58
	.byte $56,$56,$54,$54,$56,$56,$58,$58
	.byte $5a,$5a,$5c,$5c,$5e,$5e
	.byte $4e,$4e,$4c,$4c,$4a,$4a
	.byte $48,$48,$46,$46,$44,$44,$46,$46
	.byte $48,$48,$4a,$4a,$4c,$4c,$4e,$4e

	.byte $3e,$3e,$3c,$3c
	.byte $3a,$3a,$38,$38,$36,$36,$34,$34
	.byte $36,$36,$38,$38,$3a,$3a,$3c,$3c
	.byte $3e,$3e
	.byte $4e,$4e,$4c,$4c,$4a,$4a
	.byte $48,$48,$46,$46,$44,$44,$46,$46
	.byte $48,$48,$4a,$4a,$4c,$4c,$4e,$4e
	.byte $5e,$5e,$5c,$5c,$5a,$5a,$58,$58
	.byte $56,$56,$54,$54,$56,$56,$58,$58
	.byte $5a,$5a,$5c,$5c,$5e,$5e
	.byte $4e,$4e,$4c,$4c,$4a,$4a
	.byte $48,$48,$46,$46,$44,$44,$46,$46
	.byte $48,$48,$4a,$4a,$4c,$4c,$4e,$4e

	.byte $3e,$3e,$3c,$3c
	.byte $3a,$3a,$38,$38,$36,$36,$34,$34
	.byte $36,$36,$38,$38,$3a,$3a,$3c,$3c
	.byte $3e,$3e
	.byte $4e,$4e,$4c,$4c,$4a,$4a
	.byte $48,$48,$46,$46,$44,$44,$46,$46
	.byte $48,$48,$4a,$4a,$4c,$4c,$4e,$4e
	.byte $0e,$0e,$0c,$0c,$5a,$5a,$58,$58
	.byte $56,$56,$54,$54,$56,$56,$58,$58
	.byte $5a,$5a,$5c,$5c,$5e,$5e
	.byte $4e,$4e,$4c,$4c,$4a,$4a
	.byte $48,$48,$46,$46,$44,$44,$46,$46
	.byte $48,$48,$4a,$4a,$4c,$4c,$4e,$4e
	



; ==========================================================================

; Gradient controls for the box fill 4. COLPF3 -- 8, 9, A



FILL4_GRADIENT
	.byte $8e,$8c,$8a,$88
	.byte $86,$84,$86,$88
	.byte $8a,$8c,$8e,$9e
	.byte $9c,$9a,$98,$96
	.byte $94,$96,$98,$9a
	.byte $9c,$9e,$ae,$ac
	.byte $aa,$a8,$a6,$a4
	.byte $a6,$a8,$aa,$ac
	.byte $ae,$9e,$9c,$9a
	.byte $98,$96,$94,$96
	.byte $98,$9a,$9c,$9e

	.byte $8e,$8c,$8a,$88
	.byte $86,$84,$86,$88
	.byte $8a,$8c,$8e,$9e
	.byte $9c,$9a,$98,$96
	.byte $94,$96,$98,$9a
	.byte $9c,$9e,$ae,$ac
	.byte $aa,$a8,$a6,$a4
	.byte $a6,$a8,$aa,$ac
	.byte $ae,$9e,$9c,$9a
	.byte $98,$96,$94,$96
	.byte $98,$9a,$9c,$9e
	
	.byte $8e,$8c,$8a,$88
	.byte $86,$84,$86,$88
	.byte $8a,$8c,$8e,$9e
	.byte $9c,$9a,$98,$96
	.byte $94,$96,$98,$9a
	.byte $9c,$9e,$ae,$ac
	.byte $aa,$a8,$a6,$a4
	.byte $a6,$a8,$aa,$ac
	.byte $ae,$9e,$9c,$9a
	.byte $98,$96,$94,$96
	.byte $98,$9a,$9c,$9e
	
	.byte $8e,$8c,$8a,$88
	.byte $86,$84,$86,$88
	.byte $8a,$8c,$8e,$9e
	.byte $9c,$9a,$98,$96
	.byte $94,$96,$98,$9a
	.byte $9c,$9e,$ae,$ac
	.byte $aa,$a8,$a6,$a4
	.byte $a6,$a8,$aa,$ac
	.byte $ae,$9e,$9c,$9a
	.byte $98,$96,$94,$96
	.byte $98,$9a,$9c,$9e
	
	.byte $8e,$8c,$8a,$88
	.byte $86,$84,$86,$88
	.byte $8a,$8c,$8e,$9e
	.byte $9c,$9a,$98,$96
	.byte $94,$96,$98,$9a
	.byte $9c,$9e,$ae,$ac
	.byte $aa,$a8,$a6,$a4
	.byte $a6,$a8,$aa,$ac
	.byte $ae,$9e,$9c,$9a
	.byte $98,$96,$94,$96
	.byte $98,$9a,$9c,$9e
	
	.byte $8e,$8c,$8a,$88
	.byte $86,$84,$86,$88
	.byte $8a,$8c,$8e,$9e
	.byte $9c,$9a,$98,$96
	.byte $94,$96,$98,$9a
	.byte $9c,$9e,$ae,$ac
	.byte $aa,$a8,$a6,$a4
	.byte $a6,$a8,$aa,$ac
	.byte $ae,$9e,$9c,$9a
	.byte $98,$96,$94,$96
	.byte $98,$9a,$9c,$9e
	


; ==========================================================================

; Bottom Text gradients

TITLE_COLPF0
	.byte $ce,$cc,$cc,$ca,$c8,$c6,$c4,$c4
	.byte $ce,$cc,$cc,$ca,$c8,$c6,$c4,$c4
	.byte $0e,$0e,$0c,$0c,$08,$06,$06

TITLE_COLPF1
	.byte $3e,$3c,$3c,$3a,$38,$36,$34,$34
	.byte $3e,$3c,$3c,$3a,$38,$36,$34,$34
	.byte $0e,$0c,$0c,$08,$06,$06,$04


; ==========================================================================

PROGRAM_START

	; One of the things that does not need to be done is setting up the 
	; custom screen.   This was actually done at load time including 
	; updating OS shadow registers to set DMA control and the display list.
	
	; Here is what's left to do....
	
	; Copy the graphics characters from ROM to RAM, so we can zero out the heart character.
	
;	ldx #0
	
; Loop_Copy_Cset	
;	lda $E200,X
;	sta NEW_CSET,X
;	lda $E300,X
;	sta NEW_CSET+$100,X
;	inx
;	bne Loop_Copy_Cset
	
	; Clear out the first character (heart) so that blank space is visually really blank space.
	
;	lda #0
;	ldx #7
	
;Loop_Clear_Heart
;	sta NEW_CSET,X
;	dex
;	bpl Loop_Clear_Heart

; ==========================================================================

	; Let's do some program!!
	
Loop_Main_Program_Forever

	; First, wait for top of frame.
 
	lda RTCLOK60 ; incremented by VBI every jiffy/frame. When main code sees it change then we're at the top of the frame.

Loop_Wait_Top_Of_Frame
	cmp RTCLOK60
	beq Loop_Wait_Top_Of_Frame

	lda #0
	sta ATRACT  ; Turn off the color cycling attract mode.

;	lda #$0a
;	sta COLBK
	
; ==========================================================================

	; Maintenance.  Decrement timers.  Increment lookup indices per timers expiring.

	; Gradient control for the bow on the top of the box

	; Bow ribbon on the top.
	
	dec BOW_TIMER
	bpl Skip_Bow_Index      ; timer still running.   skip changing the fill index.

	lda #BOW_TIMER_SPEED    ; reset the timer.
	sta BOW_TIMER
	
	inc BOW_INDEX           ; Update the index.
	lda BOW_INDEX
	cmp #BOW_INDEX_LIMIT
	bne Skip_Bow_Index

	lda #0           ; reset the index
	sta BOW_INDEX

Skip_Bow_Index
	lda BOW_INDEX
	sta BOW_INDEX_TEMP

	; Bow frilly center section

	dec FLURF_TIMER
	bpl Skip_Flurf_Index      ; timer still running.   skip changing the fill index.

	lda #FLURF_TIMER_SPEED    ; reset the timer.
	sta FLURF_TIMER
	
	inc FLURF_INDEX           ; Update the index.
	lda FLURF_INDEX
	cmp #FLURF_INDEX_LIMIT
	bne Skip_Flurf_Index

	lda #0           ; reset the index
	sta FLURF_INDEX

Skip_Flurf_Index
	lda FLURF_INDEX
	sta FLURF_INDEX_TEMP


	; Gradient controls for the box lines.
	
	dec LINES_TIMER
	bpl Skip_Lines_Index      ; timer still running.   skip changing the lines index.

	lda #LINES_TIMER_SPEED    ; reset the timer.
	sta LINES_TIMER
	
	dec LINES_INDEX           ; Update the index.
	bpl Skip_Lines_Index

	lda #LINES_INDEX_LIMIT    ; reset the index
	sta LINES_INDEX

Skip_Lines_Index
	lda LINES_INDEX
	sta LINES_INDEX_TEMP

;	lda #$3a
;	sta COLBK
	
	; Gradient controls for the box fill 1. COLPF2  -- 1, 2, 3
	
	dec FILL1_TIMER
	bpl Skip_Fil11_Index      ; timer still running.   skip changing the fill index.

	lda #FILL1_TIMER_SPEED    ; reset the timer.
	sta FILL1_TIMER
	
	dec FILL1_INDEX           ; Update the index.
	bpl Skip_Fil11_Index

	lda #FILL1_INDEX_LIMIT    ; reset the index
	sta FILL1_INDEX

Skip_Fil11_Index
	lda FILL1_INDEX
	sta FILL1_INDEX_TEMP

;	lda #$7a
;	sta COLBK


	; Gradient controls for the box fill 2. COLPF3  -- 6, 7, 8
	
	dec FILL2_TIMER
	bpl Skip_Fil12_Index      ; timer still running.   skip changing the fill index.

	lda #FILL2_TIMER_SPEED    ; reset the timer.
	sta FILL2_TIMER
	
	inc FILL2_INDEX           ; Update the index.
	lda FILL2_INDEX
	cmp #FILL2_INDEX_LIMIT
	bne Skip_Fil12_Index

	lda #0           ; reset the index
	sta FILL2_INDEX

Skip_Fil12_Index
	lda FILL2_INDEX
	sta FILL2_INDEX_TEMP

;	lda #$Aa
;	sta COLBK

	; Gradient controls for the box fill 3. COLPF2 -- 3, 4, 5

	dec FILL3_TIMER
	bpl Skip_Fil13_Index      ; timer still running.   skip changing the fill index.

	lda #FILL3_TIMER_SPEED    ; reset the timer.
	sta FILL3_TIMER
	
	dec FILL3_INDEX           ; Update the index.
	bpl Skip_Fil13_Index

	lda #FILL3_INDEX_LIMIT    ; reset the index
	sta FILL3_INDEX

Skip_Fil13_Index
	lda FILL3_INDEX
	sta FILL3_INDEX_TEMP

;	lda #$Da
;	sta COLBK
	
	; Gradient controls for the box fill 4. COLPF3 -- 8, 9, A

	dec FILL4_TIMER
	bpl Skip_Fil14_Index      ; timer still running.   skip changing the fill index.

	lda #FILL4_TIMER_SPEED    ; reset the timer.
	sta FILL4_TIMER
	
	inc FILL4_INDEX           ; Update the index.
	lda FILL4_INDEX
	cmp #FILL4_INDEX_LIMIT
	bne Skip_Fil14_Index

	lda #0                    ; reset the index
	sta FILL4_INDEX

Skip_Fil14_Index
	lda FILL4_INDEX
	sta FILL4_INDEX_TEMP

;	lda #$0a
;	sta COLBK

; ==========================================================================

	; Next wait until the beam reaches the bow.
	
Loop_Wait_For_Scanline
	lda VCOUNT
;	sta COLBK
	cmp #15  ; VCOUNT counts every other scan line.

	bne Loop_Wait_For_Scanline

; ==========================================================================

	; Colorful Things Begin Here. 
	
	; Do something colorful to the bow.

;	sta COLBK
	
;	ldx #6
;Loop_Bow_Gradient
;	lda BOW_GRADIENT,X
;	sta WSYNC
;	sta COLPF0
;	dex
;	bpl Loop_Bow_Gradient

	ldy #24  ; Loop to push color registers for the next 152 scan lines.

Loop_Gift_Coloring_Bow
	ldx BOW_INDEX_TEMP
	lda BOW_GRADIENT,X
	sta WSYNC
	sta COLPF0
	ldx FLURF_INDEX_TEMP
	lda FLURF_GRADIENT,X
	sta COLPF1
	inc BOW_INDEX_TEMP
	inc FLURF_INDEX_TEMP
	dey
	bne Loop_Gift_Coloring_Bow
	

	; Lines and body
	
	ldy #152  ; Loop to push color registers for the next 152 scan lines.

Loop_Gift_Coloring_Top
	ldx LINES_INDEX_TEMP
	lda LINES_GRADIENT,X
	sta WSYNC
	sta COLPF1
	ldx FILL1_INDEX_TEMP
	lda FILL1_GRADIENT,X
	sta COLPF2
	ldx FILL2_INDEX_TEMP
	lda FILL2_GRADIENT,X
	sta COLPF3
	inc LINES_INDEX_TEMP
	inc FILL1_INDEX_TEMP
	inc FILL2_INDEX_TEMP
	dey
	cpy #86
	bne Loop_Gift_Coloring_Top

;	sty COLBK
	
Loop_Gift_Coloring_Bottom
	ldx LINES_INDEX_TEMP
	lda LINES_GRADIENT,X
	sta WSYNC
	sta COLPF1
	ldx FILL4_INDEX_TEMP
	lda FILL4_GRADIENT,X
	sta COLPF3
	ldx FILL3_INDEX_TEMP
	lda FILL3_GRADIENT,X
	sta COLPF2
	inc LINES_INDEX_TEMP
	inc FILL3_INDEX_TEMP
	inc FILL4_INDEX_TEMP
	dey
	bne Loop_Gift_Coloring_Bottom

; ==========================================================================

; Do While More Electricity...

	lda #$e0
	sta WSYNC
	sta CHBASE

;	Gotta skip just a few lines down . . .
	sta WSYNC
	sta WSYNC
	sta WSYNC
	sta WSYNC
	sta WSYNC
;	sta COLBK
	
	; Color the title.
	
	ldx #0
	
Loop_Coloring_Title
	lda TITLE_COLPF0,x
	sta WSYNC
	sta COLPF0
	lda TITLE_COLPF1,x
	sta COLPF1
	inx
	cpx #23
	bne Loop_Coloring_Title

; ==========================================================================

	
	jmp Loop_Main_Program_Forever


; ==========================================================================

; Do some gymnastics with the Atari's load file format to have the file 
; loading also update shadow registers to enable the new display and 
; point to the redefinied character set.

	ORG SDMCTL         ; OS Shadow register for DMACTL -  DMA Control of ANTIC
	.byte $00          ; Turn off the display/DMA.
	;                    It just so happens that SDLSTL, the Display List pointer, follows here.
	.word DISPLAY_LIST ; Point ANTIC to the new Display List. 

	ORG SDMCTL
	.byte PLAYFIELD_WIDTH_NORMAL|ENABLE_DL_DMA ; Turn on ANTIC DMA and start the screen mode.

	ORG CHBAS
	.byte $38           ; Base address for redefined character set.
	
	ORG DOS_RUN_ADDR   ; Tell DOS where this program begins execution after it loads the file.
	.word PROGRAM_START
;

	ORG COLOR4  ; COLBK  - Playfield Background color (Border for modes 2, 3, and F)
	.byte $00

	END


