; MEGA65 entry for VCCC2024 by GeirS, 2024-12-23. Compatible with the latest stable ROM (v920395).
; Size: 44 bytes excl. load address. Assemble using ACME.
; Requires loading at specific address (e.g. LOAD "PRESENT",8,1) and SYS 11552 to start.

                !cpu m65
                !to "present.prg",cbm

PrImm           = $ff7d             ; Print inline null-terminated string
Bsout           = $ffd2             ; Write a character to output device
EorValues       = $ee07             ; Contains values 1 and 6 (ROM v920395, might change in later ROMs)
Pnt             = $c4               ; Pointer to current line (ROM v920395, might change in later ROMs)
Every9thRow     = $97               ; Variable for determining every 9th row (1 at startup)
Every9thCol     = $13               ; Variable for determining every 9th column (0 at startup)
BoxChars        = $18               ; Contains values 32 and 45 after SYS command

                * = $2d20           ; Load address

; Code and data (44 bytes)
Start           jsr PrImm           ; Print inline null-terminated string
                !byte 9,205,79,47,0 ; Tab, '\', 'O', '/', 0
RowLoop         cpx #1              ; Set carry flag to 9th bit of Every9thRow
                ror Every9thRow
                rol
                and #1              ; Ensure value 0 or 1
                tax                 ; Index to 'BoxChars'
                lda #13
                jsr Bsout           ; Print new line char
                smb0 Every9thCol    ; Set initial value for current row
                ldy #19-1           ; 19 columns per row
ColLoop         lda BoxChars,x      ; Get space or '-'
                ror Every9thCol
                bcc PutChar         ; Branch if not 0th, 9th or 18th column
                eor EorValues,x     ; Change space to '!' or '-' to '+'
PutChar         sta (Pnt),y         ; Put char on screen
                dey
                bpl ColLoop         ; Loop for all columns
                asl $43,x           ; Contains word $2000 at startup
                bcc RowLoop         ; Loop for all rows
                rts
