; Logier's Annual 2024 Christmas Present coding compeition.
; Submission for the MICROBEE 32k computer.
; -Dave / Bushy555.
;
; Execution assumptions:
; (First program to run immediately after emulator is ran)
;
; Binary Snapshot
; ---------------
; 000 bytes :  snapshot header. Not included in the source.
; 118 bytes :  code
; 118 bytes :  total file size.
; 492 bytes :  source asm size.
;
;
;
; Execution/use/Instructions
; ==========================
; Use any Microbee emulator that supports .COM files. Loaded at memory address 256/$100
; - MESS works well with MESSUI.EXE gui interface.
; - Requires Microbee ROMs, can be found at : https://github.com/bushy555/MESS_MAME_ROMS  (mbee.zip)
; Find/download/install MESS and install the ROMs.
; Run MESSUI.
; Find/select Microbee 16 or Microbee 32 IC
;  TYpe OK if ROMs are found successfully.
;  DEVICES --> (first) QUICK LOAD [Empty Slot]  *.MWB/*.COM
;  Select file.com  (ie: CHRISTMAS_PRESENT.COM )
;  Wait three sections. Program will autorun / autoexecute.
;
;  Microbee does not auto scroll, so will only show the top 3/4 of the screen.
;
;
;
;
; NOTES
; =======
; Assemble with PASMO.EXE Z80 assembler.
; PASMO --alocal file.asm file.bin
; trs80-tool.exe convert --start 0x6000 file.bin file.cmd
;
; Video ram is at $F000.
; ORG is at $100 for Microbee COM programs.

	org	$100		; Program runs at $6000 in RAM.
				

	ld	a, 32		; Generic CLS for Microbee. ROM routine unknown.
	ld	hl, $f000
	ld	de, $f001
	ld	(hl), a
	ld	bc, 80*16
	ldir
	
	ld	hl, line1		; display first line (RIBBON)
	ld	de, $f008
	call	display


	inc	hl
	ld	de, $f000+64
	call	display

	

	ld	b, 2
loopd:	push	bc
	ld	b, 45			; dunno any of the TR80's ROM routines to "display HL" etc.
c1:	inc	de
	djnz	c1
	ld	b, 8
loopa:	push	bc
	ld	hl, line3
	call	display
	ld	b, 45			; dunno any of the TR80's ROM routines to "display HL" etc.
c2:	inc	de
	djnz	c2
	pop	bc
	djnz	loopa
	ld	hl, line2
	call	display
	pop	bc
	djnz	loopd
here:	jr	here

display:ld	a, (hl)			; Display message, character-by-character until reads a zero byte.
	and	a
	ret	z
	ld	(de), a
	inc	hl
	inc	de
	jr	display

line1 db '\O/',0
line2 db '+--------+--------+',0
line3 db '!        !        !',0






;
;        \0/
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;!        !        !
;+--------+--------+
;