;============================================
; Vintage Computing Christmas Challenge 2024
;============================================
; Submission by Arnolde of Leosoft
;   "Je m'appelle boite" (I call myself box)
;============================================
; Z80 Machine Code for Amstrad CPC, 51 bytes
;============================================
; Main loop consists of fall-through calls to
;   realize the 1-8-1-8-1 structure. It calls
;   itself recusively to serve both for the
;   line setup and the character output.
; Carry flag indicates recursion depth:
;   set = line setup mode (outer loop)
;   reset = char output mode (inner loop)
; Zero flag indicates if the current item is
;   set = a single
;   reset = an octuplet
; As the characters always cone in pairs,
;   they are passed via DE
;============================================
; To launch from Basic:
;   MEMORY &5C1F
;   LOAD "VCCC24.BIN",&5C20
;   CALL &5C20
; or run the basic loader:
;   RUN "VCCC24.BAS"
;============================================

org #5C20

; input conditions:
  ; Carry is reset -> char mode enabled
  ; DE = #5C20 = "\ "

; draw bow
  call do_8e_1d   ; output 8 spaces + "\"
  ld de,"/O"      ; (#2F4F)
  call do_1e_1d   ; output "O/"
  scf             ; set line mode
; draw box
loop:             ; 1-8-1-8-1:
  call do_1d      ; 1-
  call do_8e_1d   ; -8-1-
do_8e_1d:         ; -8-1
  ld b,7          ; will be inc'ed to 8
do_1e_1d:
  ld a,e          ; load octuplet character
  inc b           ; =1 if called directly
  repet:
    call do_it
    dec b         ; not djnz because
    jr nz,repet   ; we need zero flag
do_1d:
  ld a,d          ; load single character
do_it:            ; either...
  jp nc,#BB5A     ; output character, or...
  ; set up next line ("outer loop")
  ccf             ; set char output mode
  ld c,b          ; backup outer counter
  ld de,#0A0D     ; = LF-CR (newline)
  ld hl,"! "      ; octuplet (#2120)
  jr nz,$+3       ; z set -> setup single:
    add hl,de     ; = #2B2D = "+-" = single *
  call do_1e_1d   ; go down one text line **
  ex de,hl        ; line chars -> de
  call loop       ; output current char line
  ld b,c          ; restore outer counter
  scf             ; back to line mode
ret

; *) Yes, "! " + #0A0D = "+-". Was that an
;    intentional easter egg, Logiker?
; **) We can keep b as is, because even if
;     b>1, the repeated character is CR

;============================================
;                    \O/
;            +--------+--------+
;            !      MERRY      !
;            !    CHRISTMAS    !
;            !      AND A      !
;            +--------+--------+
;            !      HAPPY      !
;            !       NEW       !
;            !       YEAR      !
;            +--------+--------+
;============================================
