#include scene_sessions24/util.glsl

#define SPLIT_GATE .498

vec3 quadtree(in vec2 p, in float sd){
    int layer=0;
    float accum=rand(sd).x;
    for(;layer<3;layer++){
        accum=rand(floor(p*float(1<<(layer+2)))+vec2(sd));
        if(accum<SPLIT_GATE) break;
    }
    float zoom=float(1<<(layer+2));
    return vec3(p*zoom-floor(p*zoom),accum);
}

vec2 quadtree_main(vec2 UV, float t) {
    float i_t = floor(t);
    float f_t = fract(t);

    vec2 p = UV*rot(0.1)*.25+vec2((i_t+elastic(f_t))*0.25, 0.);

    vec3 q = quadtree(p, 0.0);
    vec2 f_p = q.xy;
    float id = q.z;

    return f_p+floor(rand(id).xy*8.);
}