#include scene_sessions24/util.glsl

vec2 flying_main(vec2 UV, float t) {
    float i_t = floor(t);
    float f_t = fract(t);

    float cam_rot = t*0.333;

    vec2 lookat = vec2(cos(cam_rot), sin(cam_rot))*0.45;
    vec3 ray = normalize(vec3(UV,1));
    ray.yz *= rot(lookat.x);
    ray.xz *= rot(lookat.y);
    float dist = 1.0/ray.z;

    float ang = i_t + sine_ease(f_t);
    vec2 p = (ray*dist).xy+vec2(cos(ang),sin(ang))*3.0;
    return dist>0.0?p:vec2(0);
}