var startTime = 0.0;
var isStart = false;
var count = 0;

onload = function(){
  // canvas エレメントを取得
  const c = document.getElementById('canvas');
  c.width = 1920;
  c.height = 1080;
  c.style.display = 'none';
  
  var compiledLabel = document.getElementById('compiled');
  
  function toggleFullScreen() {
    if (!c.mozFullScreen && !c.webkitFullScreen) {
      console.log("full screen start");
      c.style.display = 'block';
      isStart = true;
      startTime = Date.now();
      count = 0;
      if (c.mozRequestFullScreen) {
        c.mozRequestFullScreen();
      } else {
        c.webkitRequestFullScreen(Element.ALLOW_KEYBOARD_INPUT);
      }
    } else {
      if (c.mozCancelFullScreen) {
        c.mozCancelFullScreen();
      } else {
        c.webkitCancelFullScreen();
      }
    }
  }
  // フルスクリーン表示しているか確認
  function checkFullScreen() {

    let fullscreen_flag = false;

    if( c.fullscreenElement || c.mozFullscreenElement || c.webkitFullscreenElement || c.msFullscreenElement ) {
      fullscreen_flag = true;
    }

    return fullscreen_flag;
  }
  
  function isFullScreen() {
    if ((document.fullscreenElement !== undefined && document.fullscreenElement !== null) || // HTML5 標準
        (document.mozFullScreenElement !== undefined && document.mozFullScreenElement !== null) || // Firefox
        (document.webkitFullscreenElement !== undefined && document.webkitFullscreenElement !== null) || // Chrome・Safari
        (document.webkitCurrentFullScreenElement !== undefined && document.webkitCurrentFullScreenElement !== null) || // Chrome・Safari (old)
        (document.msFullscreenElement !== undefined && document.msFullscreenElement !== null)){ // IE・Edge Legacy
      return true; // fullscreenElement に何か入ってる = フルスクリーン中
    } else {
      return false; // フルスクリーンではない or フルスクリーン非対応の環境（iOS Safari など）
    }
  }
  
  document.addEventListener("keydown", function(e) {
    if (e.keyCode == 13) {
      toggleFullScreen();
    }
  }, false);
  
  // webglコンテキストを取得
  //var gl = c.getContext('webgl') || c.getContext('experimental-webgl');
  var opts = { alpha: false,
    depth: false,
    stencil: false,
    premultipliedAlpha: false,
    antialias: false,
    preserveDrawingBuffer: false,
    powerPreference: "high-performance" }; // "low_power", "high_performance", "default"
  var gl = null;
  if( gl === null) gl = c.getContext( "webgl2", opts);
  if( gl === null) gl = c.getContext( "experimental-webgl2", opts);
  if( gl === null) gl = c.getContext( "webgl", opts);
  if( gl === null) gl = c.getContext( "experimental-webgl", opts);
  if(gl === null)
    return;
  
  // attributeの要素数を配列に格納
  var attStride = new Array();
  attStride[0] = 3;
  //attStride[1] = 4;
  //attStride[1] = 2;

  // モデル(頂点)データ
  var position = [
    -1.0, -1.0,  0.0,
    1.0, -1.0,  0.0,
    -1.0,  1.0,  0.0,
    1.0,  1.0,  0.0
  ];

  // テクスチャ座標
  var textureCoord = [
    0.0, 0.0,
    1.0, 0.0,
    0.0, 1.0,
    1.0, 1.0
  ];

  // 頂点インデックス
  var index = [
    0, 1, 2,
    3, 2, 1
  ];
  
  // VBOの生成
  var vPosition     = create_vbo(position);
  var VBOList       = [vPosition];
  var iIndex        = create_ibo(index);
  
  // 頂点シェーダとフラグメントシェーダの生成
  var v_shader = create_shader('vs');
  var f_shader = create_shader('fs');

  // プログラムオブジェクトの生成とリンク
  var prg = create_program(v_shader, f_shader);

  // attributeLocationを配列に取得
  var attLocation = [];
  attLocation[0] = gl.getAttribLocation(prg, 'position');

   // VBOとIBOの登録
  set_attribute(VBOList, attLocation, attStride);
  gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, iIndex);

  // uniformLocationの取得
  uniLocation = new Array();
  uniLocation[0]  = gl.getUniformLocation(prg, 'iTime');
  uniLocation[1]  = gl.getUniformLocation(prg, 'iResolution');

  // コンパイル完了
  compiledLabel.textContent = 'Press Enter to Start!';
  
  // カウンタの宣言
  var count = 0;

  // 恒常ループ
  (function(){
    //console.log("count " + count);
    if(isStart) {
      count++;
      // canvasを初期化
      gl.clearColor(0.0, 0.0, 0.0, 1.0);
      gl.clearDepth(1.0);
      gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

      var nowTime = (Date.now() - startTime) / 1000;
      // uniform変数にテクスチャを登録
      gl.uniform1f(uniLocation[0], nowTime);
      gl.uniform3fv(uniLocation[1], [c.width, c.height, 0]);
      gl.drawElements(gl.TRIANGLES, index.length, gl.UNSIGNED_SHORT, 0);

      // コンテキストの再描画
      gl.flush();

      // フルスクリーン終了判定
      if(!isFullScreen() && count > 10){
        console.log("full screen end");
        c.style.display = 'none';
        isStart = false;
      }
    }
    // ループのために再帰呼び出し
    setTimeout(arguments.callee, 1000 / 30);
  })();

  function create_shader(id){
    // シェーダを格納する変数
    var shader;

    // HTMLからscriptタグへの参照を取得
    var scriptElement = document.getElementById(id);

    // scriptタグが存在しない場合は抜ける
    if(!scriptElement){return;}

    // scriptタグのtype属性をチェック
    switch(scriptElement.type){

        // 頂点シェーダの場合
        case 'x-shader/x-vertex':
            shader = gl.createShader(gl.VERTEX_SHADER);
            break;

        // フラグメントシェーダの場合
        case 'x-shader/x-fragment':
            shader = gl.createShader(gl.FRAGMENT_SHADER);
            break;
        default :
            return;
    }

    // 生成されたシェーダにソースを割り当てる
    gl.shaderSource(shader, scriptElement.text);

    // シェーダをコンパイルする
    gl.compileShader(shader);

    // シェーダが正しくコンパイルされたかチェック
    if(gl.getShaderParameter(shader, gl.COMPILE_STATUS)){

        // 成功していたらシェーダを返して終了
        return shader;
    }else{

        // 失敗していたらエラーログをアラートする
        alert(gl.getShaderInfoLog(shader));
    }
  }

  function create_program(vs, fs){
    // プログラムオブジェクトの生成
    var program = gl.createProgram();

    // プログラムオブジェクトにシェーダを割り当てる
    gl.attachShader(program, vs);
    gl.attachShader(program, fs);

    // シェーダをリンク
    gl.linkProgram(program);

    // シェーダのリンクが正しく行なわれたかチェック
    if(gl.getProgramParameter(program, gl.LINK_STATUS)){

        // 成功していたらプログラムオブジェクトを有効にする
        gl.useProgram(program);

        // プログラムオブジェクトを返して終了
        return program;
    }else{

        // 失敗していたらエラーログをアラートする
        alert(gl.getProgramInfoLog(program));
    }
  }

  function create_vbo(data){
    // バッファオブジェクトの生成
    var vbo = gl.createBuffer();

    // バッファをバインドする
    gl.bindBuffer(gl.ARRAY_BUFFER, vbo);

    // バッファにデータをセット
    gl.bufferData(gl.ARRAY_BUFFER, new Float32Array(data), gl.STATIC_DRAW);

    // バッファのバインドを無効化
    gl.bindBuffer(gl.ARRAY_BUFFER, null);

    // 生成した VBO を返して終了
    return vbo;
  }

  // VBOをバインドし登録する関数
  function set_attribute(vbo, attL, attS){
    // 引数として受け取った配列を処理する
    for(var i in vbo){
        // バッファをバインドする
        gl.bindBuffer(gl.ARRAY_BUFFER, vbo[i]);

        // attributeLocationを有効にする
        gl.enableVertexAttribArray(attL[i]);

        // attributeLocationを通知し登録する
        gl.vertexAttribPointer(attL[i], attS[i], gl.FLOAT, false, 0, 0);
    }
  }

  // IBOを生成する関数
  function create_ibo(data){
    // バッファオブジェクトの生成
    var ibo = gl.createBuffer();

    // バッファをバインドする
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, ibo);

    // バッファにデータをセット
    gl.bufferData(gl.ELEMENT_ARRAY_BUFFER, new Int16Array(data), gl.STATIC_DRAW);

    // バッファのバインドを無効化
    gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, null);

    // 生成したIBOを返して終了
    return ibo;
  }

  // テクスチャを生成する関数
  function create_texture(source){
    // イメージオブジェクトの生成
    var img = new Image();

    // データのオンロードをトリガーにする
    img.onload = function(){
      // テクスチャオブジェクトの生成
      var tex = gl.createTexture();

      // テクスチャをバインドする
      gl.bindTexture(gl.TEXTURE_2D, tex);

      // テクスチャへイメージを適用
      gl.texImage2D(gl.TEXTURE_2D, 0, gl.RGBA, gl.RGBA, gl.UNSIGNED_BYTE, img);

      // ミップマップを生成
      gl.generateMipmap(gl.TEXTURE_2D);

      // テクスチャのバインドを無効化
      gl.bindTexture(gl.TEXTURE_2D, null);

      // 生成したテクスチャをグローバル変数に代入
      texture = tex;
    };

    // イメージオブジェクトのソースを指定
    img.src = source;
  }
};
