layout(location = 0)in vec3 vertex_position;
layout(location = 1)in vec3 vertex_normal;
layout(location = 2)in vec2 vertex_uv;

out vec3 normal;
out vec2 uv;
out vec3 frag_position;

uniform mat4 wvp;

uniform float fTime;

mat4 rotation3d(vec3 axis, float angle) {
  axis = normalize(axis);
  float s = sin(angle);
  float c = cos(angle);
  float oc = 1.0 - c;

  return mat4(
    oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
    oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
    oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
    0.0,                                0.0,                                0.0,                                1.0
  );
}

void main() {
  normal = vertex_normal;
  uv = vertex_uv;
  //vec3 circ = vec3(sin(fTime) * 0.5, cos(fTime) * 0.5, 1.0);
  vec4 pos = vec4(vertex_position, 1.0) * rotation3d(vec3(0, 1, 0), 0);
  gl_Position = vec4(pos * wvp);
  frag_position = vertex_position;
  //gl_Position = vec4(vertex_position, 1.0);
}
