in vec2 uv;

out vec4 fragColor;

uniform sampler2D image;

uniform int pass;
uniform vec2 resolution;

//https://github.com/Experience-Monks/glsl-fast-gaussian-blur/tree/master
vec4 blur9(sampler2D image, vec2 uv, vec2 direction) {
  vec4 color = vec4(0.0);
  vec2 off1 = vec2(1.3846153846) * direction;
  vec2 off2 = vec2(3.2307692308) * direction;
  color += texture(image, uv) * 0.2270270270;
  color += texture(image, uv + (off1 / resolution)) * 0.3162162162;
  color += texture(image, uv - (off1 / resolution)) * 0.3162162162;
  color += texture(image, uv + (off2 / resolution)) * 0.0702702703;
  color += texture(image, uv - (off2 / resolution)) * 0.0702702703;
  return color;
}

void main() {
    fragColor = vec4(1, 0, 1, 1);
    if(pass == 0)
    {
        fragColor = blur9(image, uv, vec2(1, 0));
    }
    else if(pass == 1)
    {
        fragColor = blur9(image, uv, vec2(0, 1));
    }
}
