layout(location = 0)in vec3 vertex_position;
layout(location = 1)in vec3 vertex_normal;
layout(location = 2)in vec2 vertex_uv;

out vec3 normal;
out vec2 uv;
out vec3 frag_position;
out float mat;

uniform mat4 wvp;

uniform float fTime;

uniform int instanceX;
uniform int instanceZ;

mat2 rot(float a){
  float c=cos(a),s=sin(a);
  return mat2(c,s,-s,c);
}

void main() {
  normal = vertex_normal;
  vec2 vuv = vertex_uv.xy*vec2(1,-1);
  uv = vuv;
  uv += vec2(instanceX, instanceZ);
  float hash = instanceX + instanceZ*10 +uv.x + uv.y*99.0; 
  hash = fract(hash*hash*1.1134+hash*412.1234+5341.123);
  float anim = sin(fTime*3.14159*0.25+hash*0.1+uv.x+uv.y+cos(uv.y+fTime));
  anim = smoothstep(-1,1, anim);
  vec4 pos = vec4(vertex_position, 1.0);
  mat=0;

  pos.xz -= vuv;
  pos.xy *= rot(anim*3.14159);
  pos.xy *= rot(anim*3.14159);
  pos.xz += vuv;
  pos.x += instanceX * 2.0-10;
  pos.z += instanceZ * 2.0-10;
  pos.y -= 2;
  pos.y += anim;

  frag_position = pos.xyz;
  gl_Position = vec4(pos * wvp);
}
