pico-8 cartridge // http://www.pico-8.com
version 42
__lua__

neuroblend = {
    pitch= 0, -- camera direction up/down
    yaw=   0, -- camera rotation left/right
    posx= 0,
    posy= 0,
    bounce= 0,
    fade= 0,
  
    data= {},
    colors= {},
    nodes= {},
    dots = {}    
}

--frame= 0
--local colors= {} --{[0]=0,129,1,131,140,3,139,11,138,135,10,7,7,7,7,7}
--local nodes= {}
--local dots = {}

neuroblend.setparams= function(this, p)
  this.pitch= p[1]>>7
  this.yaw=   p[2]
  this.posx=  p[3]
  this.posy=  p[4]
  this.bounce= p[5]
  this.fade=  clamp(p[6]&-1, -15, 15)

--[[  
  this.pitch= -sin(frame>>3)/16   -- camera direction up/down
  this.yaw=   frame>>4          -- camera rotation left/right

-- movement in the plane (just shifts u,v)
  this.posx= frame*10
  this.posy= 0

  this.bounce= 2-((frame*16) % 10)
  if (this.bounce<0) then 
    this.bounce=0 
  end
]]  
end

neuroblend.redir= function(this, dot) 
  -- dest point becomes new source point
  -- pick new destination randomly
    local dstindex= dot[3]
    local srcnode= this.nodes[dstindex]

    local neighbors= srcnode[3]
    local dirs= srcnode[2]
    local next= flr(rnd(#dirs))

    local p= srcnode[1]
    dot[1]= {p[1],p[2],0}
    dot[2]= dirs[next]
    dot[3]= neighbors[next]
end


neuroblend.load = function(this)
  reload(0x8000, 0x0, 0x4300, "data_3.p8")  
  px9_decomp(0,0, dict(0x8000, 8), sget, sset)
  this.data[0]= storemem(0x0, 0x2000)

  local start= dict(0x8000, 9)
  for i=-15,15 do
    this.colors[i]={}
    start= unpackmem( start, this.colors[i] )
  end

  start= dict(0x8000, 11)
  for i=1,25 do
    local pos= readvec3(start)
    local neighb_dirs= {}
    start= readvectors(start+6, neighb_dirs)
    local neighb_idx= {}
    start= unpackmem(start, neighb_idx)

    this.nodes[i]= { pos, neighb_dirs, neighb_idx }
  end

  srand(1)
  for i=1,20 do
    this.dots[i]= { 
      {0,0,0}, -- src position x,y
      {0,0,0}, -- delta to destination
      i, -- [3]= dst index
    }
    neuroblend:redir(this.dots[i])
  end
end

neuroblend.init = function(this)
    for i=0,15 do palt(i, false) end

    poke(0x5f54, 0x0) -- background
    poke(0x5f55, 0x60) -- background
    poke(0x5f2c, 0)
    poke(0x5f38, 16)
    poke(0x5f39, 16)

    restoremem(0xe000, this.data[0]) -- walk anim to sprite sheet
    for i=0,255 do mset(i&15,i>>4,i) end
    poke(0x5f5f, 0x0)
    poke(0x5f36, 8)
    for i=0,15 do 
      poke(0x5f60+i, (i<<4)|i)
    end
  end

function initfloor(y, pitch, yaw)
   local cx, sx= cos(pitch),sin(pitch)
   local cz, sz= cos(yaw),sin(yaw)

   -- interpolate left and right screen border from top to bottom
   local leftx= ((cx-sx)*sz - cz) << 6
   local lefty= ((sx-cx)*cz - sz) << 6 
   local linez=  (sx+cx) << 6

   local rightx= leftx + (cz<<7)
   local righty= lefty + (sz<<7)

   -- delta for left and right side
   local deltax= -sz*cx
   local deltay=  cz*cx
   local deltaz= -sx
end

function draw_floor(y, pitch, yaw, posx, posy, posz)
   local cx, sx= cos(pitch),sin(pitch)
   local cz, sz= cos(yaw),sin(yaw)

   -- interpolate left and right screen border from top to bottom
   local leftx= ((cx-sx)*sz - cz) << 6
   local lefty= ((sx-cx)*cz - sz) << 6 
   local linez=  (sx+cx) << 6

   local rightx= leftx + (cz<<7)
   local righty= lefty + (sz<<7)

   -- delta for left and right side
   local deltax= -sz*cx
   local deltay=  cz*cx
   local deltaz= -sx

   leftx+= deltax*y
   lefty+= deltay*y

   rightx+= deltax*y
   righty+= deltay*y

   linez+= deltaz*y -- leftz and rightz are identical!

--   for y=20,127-20 do
      -- 1 division per scanline (32/16bit)
      local z= posz / linez

      local lu= leftx * z
      local lv= lefty * z

      local ru= rightx * z
      local rv= righty * z

      tline(
        0,y,
        127,y,
        lu+posx, lv+posy,
        (ru-lu) >> 7, 
        (rv-lv) >> 7 )

end

neuroblend.update = function(this)
    pal( this.colors[this.fade], 1 )
end


neuroblend.draw = function(this)
    local function drawdot(pos)
        -- 5x5 dot
         local dot={ [-2]= 0x0.1210, [-1]=0x1.3431, [0]=0x2.4542, [1]=0x1.3431, [2]=0x0.1210 }
         local px= pos[1]
         local py= pos[2]
         for sy=-2,2 do
          local p= dot[sy]
          local y= (py+sy)&127
          for sx=-2,2 do    
            local x= (px+sx)&127
            local c= sget(x,y)+(p&15)
            if (c>12) c=12
            sset(x,y,c)
            p<<=4
          end
        end
    end

    memcpy(0x0, 0xe000, 0x2000) -- restore texture
    memset(0x8000, 0, 0x2000)
    -- add animated dots
    for i=1,#this.dots do
      local dot= this.dots[i]
      local pos= dot[1]
      local dir= dot[2]
      drawdot(pos)
  
      for j=1,3 do
        pos[j]+=dir[j]>>4
      end
      if (pos[3]>=1) neuroblend:redir(dot)
    end
  
    local pitch= this.pitch
    local yaw=   this.yaw>>4
    
    -- movement in the plane (just shifts u,v)
    local posx= this.posx
    local posy= this.posy
    local bounce= this.bounce
    
    local dither1,dither2= 0x0202.0202, 0x0303.0303
    for y=24,127-24 do
        dither1,dither2= dither2,dither1
  
      poke(0x5f55,0x80) -- render to 0x8000
      -- draw 3 layers at depths 8,4,12
      draw_floor(y, pitch+0.01,yaw, posx+5,posy+10, 8+bounce )
  
      draw_floor(y+1, pitch-0.01,yaw, posx+10,posy+5, 4-bounce/2 )
  
      draw_floor(y+2, pitch,yaw, posx+5,posy+15, 12+bounce*2 )
      poke(0x5f55,0x60) -- render to 0x6000
    
    
    -- sum 3 layers
      local src1= 0x8000 + (y<<6)
      local src2= src1 + 64
      local src3= src2 + 64
      local dst=  0x6000 + (y<<6)
  
      for x=0,63,4 do
        -- read from 3 layers (8 pixels at once)
        local c1= $(src1+x)
        local c2= $(src2+x)
        local c3= $(src3+x)
        
        -- add lower bits (every 2nd pixels, making room for overflow)
        local l= ((c1 & 0x0f0f.0f0f) + (c2 & 0x0f0f.0f0f) + (c3 & 0x0f0f.0f0f) + dither1)>>1
        -- add upper bits
        local u= ((c1 >>> 4 & 0x0f0f.0f0f) + (c2 >>> 4 & 0x0f0f.0f0f) + (c3 >>> 4 & 0x0f0f.0f0f) + dither2)>>1
        
        local ol = l & 0x3030.3030           -- extract overflow bits
        local ml = 0x3030.3030 - (ol >>> 4)  -- mask for saturation: if overflow-bit is set, lower byte gets 0xff
  
        local ou = u & 0x3030.3030           -- extract overflow bits
        local mu = 0x3030.3030 - (ou >>> 4)  -- mask for saturation: if overflow-bit is set, lower byte gets 0xff
        
        poke4(dst+x, (((u | mu) & 0x0f0f.0f0f)<<4)| ((l | ml) & 0x0f0f.0f0f))
      end
  end
 
end
  
