pico-8 cartridge // http://www.pico-8.com
version 16
__lua__

function matrix_rotx(a)
  local s= sin(a)
  local c= cos(a)
  return {
    1,  0,  0,  0,
    0,  c, -s,  0,
    0,  s,  c,  0
  }
end

function matrix_roty(a)
  local s= sin(a)
  local c= cos(a)
  return {
    c,  0,  s,  0,
    0,  1,  0,  0,
   -s,  0,  c,  0
  }
end

function matrix_rotz(a)
  local s= sin(a)
  local c= cos(a)
  return {
    c, -s,  0,  0,
    s,  c,  0,  0,
    0,  0,  1,  0,
  }
end

function matrix_translation(x, y, z)
  return {
    1, 0, 0, x,
    0, 1, 0, y,
    0, 0, 1, z
  }
end

function matrix_mul(a, b)
  local axx,axy,axz,axw= a[1],a[2],a[3],a[4]
  local ayx,ayy,ayz,ayw= a[5],a[6],a[7],a[8]
  local azx,azy,azz,azw= a[9],a[10],a[11],a[12]

  local bxx,bxy,bxz,bxw= b[1],b[2],b[3],b[4]
  local byx,byy,byz,byw= b[5],b[6],b[7],b[8]
  local bzx,bzy,bzz,bzw= b[9],b[10],b[11],b[12]

--loops!
  return {
    axx*bxx + axy*byx + axz*bzx,
    axx*bxy + axy*byy + axz*bzy,
    axx*bxz + axy*byz + axz*bzz,
    axx*bxw + axy*byw + axz*bzw + axw,

    ayx*bxx + ayy*byx + ayz*bzx,
    ayx*bxy + ayy*byy + ayz*bzy,
    ayx*bxz + ayy*byz + ayz*bzz,
    ayx*bxw + ayy*byw + ayz*bzw + ayw,

    azx*bxx + azy*byx + azz*bzx,
    azx*bxy + azy*byy + azz*bzy,
    azx*bxz + azy*byz + azz*bzz,
    azx*bxw + azy*byw + azz*bzw + azw
  }
end

function matrix_multiplication(a, b)
  return {
    a[ 1]*b[1] + a[ 2]*b[5] + a[ 3]*b[ 9],
    a[ 1]*b[2] + a[ 2]*b[6] + a[ 3]*b[10],
    a[ 1]*b[3] + a[ 2]*b[7] + a[ 3]*b[11],
    a[ 1]*b[4] + a[ 2]*b[8] + a[ 3]*b[12] + a[ 4],

    a[ 5]*b[1] + a[ 6]*b[5] + a[ 7]*b[ 9],
    a[ 5]*b[2] + a[ 6]*b[6] + a[ 7]*b[10],
    a[ 5]*b[3] + a[ 6]*b[7] + a[ 7]*b[11],
    a[ 5]*b[4] + a[ 6]*b[8] + a[ 7]*b[12] + a[ 8],

    a[ 9]*b[1] + a[10]*b[5] + a[11]*b[ 9],
    a[ 9]*b[2] + a[10]*b[6] + a[11]*b[10],
    a[ 9]*b[3] + a[10]*b[7] + a[11]*b[11],
    a[ 9]*b[4] + a[10]*b[8] + a[11]*b[12] + a[12]
  }
end

