; Bee-Bee THE OUTLINE FRACTAL by TomCat/Abaddon
; 256-byte intro for Outline 2024 demo party
; inspired by matja's ASMINITY

TIMER=0;0: max fps, 1: 30fps

DIGITS = (HDIGIT-VDIGIT) + (ODIGIT-HDIGIT)/2 + (DECOMP-ODIGIT)/8
BASE = (ODIGIT+DIGITS*8)

ORG 256

start:
 MOV AL,93H;nearly 30fps
 INT 10H

if TIMER>0
.0:
;MOV AL,TIMER
 OUT 40H,AL
 FLDZ
 CMC
 JC .0;loop twice
else
 FLDZ
 FLDZ
end if

 MOV SI,VDIGIT
 MOV DI,DECOMP
 MOV CL,(HDIGIT-VDIGIT)
.1:
  MOV AL,-30
  STOSW
  MOV AL,61
  STOSW
  MOVSB
  STOSW
  INC DI
 LOOP .1
 MOV CL,(ODIGIT-HDIGIT)/2
.2:
  MOV AX,36*256
  STOSW
  MOV AH,30
  STOSW
  MOVSB
  INC DI
  MOVSB
  INC DI
 LOOP .2

 PUSH DI
 XCHG CX,AX;MOV CL,DIGITS*8
.3:
  LODSB
  CBW
  MOV [DI],AX
  FILD WORD [DI]
  FIDIV WORD [const256]
  FSTP DWORD [DI]
  SUB DI,SP
 LOOP .3
 POP BP

 PUSH 8100H
 POP DS
 PUSH 0A000H;-20*4
 POP ES
 MOV DI,SCALE-BASE

draw_frame:
  IMUL AX,DX,13    ; generate pseudo-random number, DX = seed
  XCHG AH,AL
  MOV DX,AX	   ; ax = pseudo-random number
  AAM DIGITS
  CBW
  IMUL SI,AX,32
.1:
  FLD ST0			; y y x
  FMUL DWORD [SI+BP]		; y*[si] y x
  FLD ST2			; x y*[si] y x
  FMUL DWORD [SI+BP+4]		; x*[si+4] y*[si] y x
  FADDP 			; x*[si+4]+y*[si] y x
  FADD DWORD [SI+BP+16] 	; x*[si+4]+y*[si]+[si+16] y x
  FXCH ST2			; x y newx
  XOR BP,8			; y*[si+12]+x*[si+8]+[si+24] x y newx
  JPO .1			; y x newy newx

  FIMUL WORD [DI+BP]		; scale*y x newy newx
  FISTP WORD [DI]		; x newy newx
  IMUL SI,[DI],-320
  FIMUL WORD [DI+BP]		; scale*x newy newx
  FISTP WORD [DI]		; newy newx
  ADD SI,[DI]

  MOV  BYTE [SI+120*320+160],7EH
main:
 LOOP draw_frame

if TIMER>0
 HLT
end if

 MOV SI,DI
cls:
  MOV AX,DS
  SUB AL,CH
  SHR AX,4
  MOVSB
  MOV [SI-1],AL
 LOOP cls

 IMUL AX,[DI+BP],4
 SAR AX,2
if TIMER>0
 SUB AX,8
else
 DEC AX
 TEST AL,7
 JNZ .4
end if
 SUB BX,321
.4:
 MOV WORD [DI+BP],AX

 PUSH BX
 MOV CL,16*15
.1:
 BT [BP+DI-SCALE+LOGO],CX
 JNC .2
 MOV BYTE [BX],42
.2:
 INC BX
 TEST CL,15
 JNZ .3
 ADD BX,320-16
.3:
 LOOP .1
 POP BX

 IN AL,60H
 DAS
 JC main

if TIMER>0
;SALC
;OUT 40H,AL
;OUT 40H,AL
else
 FNINIT 			; clear FPU stack
end if

RETN

LOGO:
 DW 0011010001010100B;15
 DW 0100101001010110B;14
 DW 0100010011011000B;13
 DW 0100001011011110B;12
 DW 0110000101100000B;11
 DW 0011001111111100B;10
 DW 0001110101011000B;09
 DW 0000011011100000B;08
 DW 0001101101010100B;07
 DW 0001100110001010B;06
 DW 1100011010000100B;05
 DW 0000011011000010B;04
 DW 0000000001100010B;03
 DW 0000100000111100B;02
 DW 0000100000000000B;01

VDIGIT:;Vertical digits
 DB 22
 DB 34
 DB 17
 DB 39
 DB -51
 DB -39
SCALE: DB 0;,3
 DB -34
 DB -22
 DB -11
HDIGIT:;Horizontal digits
 DB -45,-11
 DB -28,-11
 DB 6,-11
 DB 45,-11
 DB 45,0
 DB -11,11
 DB -45,11
 DB 45,11
ODIGIT:;Other digits
 DB 30,30,-30,30,28,0
const256:
 DB 0,1
DECOMP:
