; sequentuality - tiny exemusic - lovebyte 2o24
; p5/dos/covox at LPT1 (or rather dosbox :D)
;
; wbcbz7 (aka artёmka) (aka wbcbz7) 1o.o2.2o24
;
; -------------------------------------------
; well lol, originally i've planned to do some goa/progtrance stuff,
; but as usual, no more bytes left for notes
; so here we are - tiny tekkno sequencer!
;
; greets to everyone and everybody at lovebyte
; thanks to jin_x, pestis and nihirash for some advices
; and obviously additional respects for 0b5vr
; (time to redo that 64k from revision23 in 512b? :D)
;
; seq.com       - compo version, perhaps dosbox only
;                 (hooks INT1C, no reg save/restore, hardcoded port 0x378, etc)
; seq_safe.com  - safe ESCapable version
;
; sorry for messy sources - this has been done in a horrible rush
; (two days from scratch)
;
; t.me/wbcbz7 | discord:wbcbz7 | wbcbz7.at@gmail.com | github.com/wbcbz7

        org     0x100
        use16

; produce tniy executable without system restore
;%define TINY

; unsafe hacks
;%define UNSAFE_HACKS

; hook INT 1C (no need for EOI, may not work on real hardware)
;%define INT1C

; EXTREMELY unsafe hacks
;%define TOTALLY_UNSAFE_HACKS

; set sample rate - defines root key and tempo
SAMPLE_RATE     equ     42146

; minimal tracker interface :D (right to left)
SEQ_DRUM        equ     0b0111111110111110
SEQ_BASS        equ     0b1111110111001111
SEQ_HAT         equ     0b0111111111111100
SEQ_LEAD        equ     0b0011111111110000
SEQ_GLITCH      equ     0b0011111000100000
SEQ_GLITCH2     equ     0b1111001100011100

start:
%ifndef UNSAFE_HACKS
        ; clear phase accumulator!
        xor     edi, edi
%else
        xchg    ax, di          ; set at least low 16 bits of DI to 0
%endif

%ifndef TINY
        ; get LPT1 port from BIOS Data Area
        mov     es, bx
        mov     ax, [es:0x408]
        test    ax, ax
        jz      .skip_lpt_update
        mov     [isr.port], ax
.skip_lpt_update:

        ;save old INT08
        mov     ax, 0x3508
        int     0x21
        push    es
        push    bx
%endif
        ; speed up the timer
        mov     al, ((0x1234DD + SAMPLE_RATE - 1) / SAMPLE_RATE)  ; = 36
        out     0x40, al
        salc                ;  low byte is always 0 - save 1 byte
        out     0x40, al

        ; hook our INT08
%ifdef INT1C
        mov     ax, 0x251C
%else
        mov     ax, 0x2508
%endif
        mov     es, ax          ; ES = 0x2508/0x251C - echo buffer segment
%ifdef TOTALLY_UNSAFE_HACKS
        mov     dl, isr        ; valid only if DX=CS=0x01xx
%else
        mov     dx, isr
%endif
        int     0x21
%ifndef TINY
        ; clear echo buffer to avoid crackling
        xor     ax, ax
        xor     cx, cx
        rep     stosb
%endif

.loop:
%ifdef TINY
        jmp     $               ; infinite loop
%else
        xor     ax, ax          ; keyboard loop
        int     0x16
        jnz     .loop
%endif

%ifndef TINY
        ; restore INT8
        pop     dx
        pop     ds
        mov     ax, 0x2508
        int     0x21

        ; restore IRQ0 rate back to 18.2 Hz
        xor     ax, ax
        out     0x40, al
        out     0x40, al
%endif
        int     0x20

        ; ---------------------
        ; noise generator
        ; out: AL - next noise value, clobbers DX
noise:
        mov     ax, 1
.seed   equ     $-2
        imul    ax, ax, 117             ; LCG, taken fron odd future/abaddon
        mov     [.seed], ax
        xchg    al, ah
        ;ret                            ; fallthrough

        ; multiply-accumulate
        ; BL += ((AL*DL) >> 10)
env_mac:
        mul     dl
.add:
        shr     ax, 10
        add     bl, al
        ret

        ; sequence unpacker
        ; input: EAX - sequence bit string, SI - sample pointer shift
        ; out:   sequence shifted
unpack:
        mov     cx, si
        ; call here is shift is initialized
.cx:
        bt      ebp, ecx
        ;shr     ebp, cl
        ret

        ; ----------------------
        ; synth ISR
isr:
%ifndef TINY
        ; save regs
        pusha
%endif

        ; synth body
        
        ; get pattern shift
        shld    esi, edi, 14            ; SI contains "pattern" number
        
        ; clear sample storage
        xor     bx, bx

        ; pluck
        ; ---------------------
        ; pluck calculator (used for bassline and bassdrum)
        ; in:  AX - phase
        ; out: AX - pluck phase 
.pluck:
        shld    ax, di, (16 - 4)        ; (t >> 4)
        not     al                      ; (255 - (t >> 4)) 
        mul     al                      ; (255 - (t >> 4))^2
        shr     ax, 8
        push    ax
        push    ax

        ; bassdrum sequence
        mov     bp, SEQ_DRUM
        call    unpack
        jnc     .bd_done

        ; bassdrum (untz untz untz)
        ; in:   EBP - sample index, BX - accumulator
        ; clobbers a fair chunk of registers
;bassdrum:
        ; play bassdrum now?
        test    di, 0x3000
        jnz     .bd_done           ; skip

        ; get bassdrum phase
        xchg    ax, cx                  ; save phase
        mov     ax, di                  ; t
        and     ax, (1 << (2 + 8)) - 1  ; masked t
        mul     cx                      ; dx:ax - result!
        xchg    al, ah                  ; 
        and     al, 64
        ; apply pluck phase and accumulate
        mul     cl                      ; ax = al * ch
        add     bl, ah  
.bd_done:

        ; hat
        pop     dx
        mov     bp, SEQ_HAT
        call    unpack
        jnc     .hat_skip
        bt      di, 13
        jnc     .hat_skip
        call    noise                           ; + accumulate samples
.hat_skip:

        ; gate seq
        mov     bp, 0b0101110111010111
        shld    cx, di, (16 - 11)               ; 1 byte shorter
        bt      bp, cx
        jnc     .gate_skip

        ; lead saw
        ; outer seq
        mov     bp, SEQ_LEAD
        call    unpack
        jnc     .lead_skip

        ; unison saw
        mov     dx, di
        shld    ax, di, (16 - 6)        ; (t >> 6)
        sub     ax, dx                  ; ax = t - (t >> 6)
        shr     al, 4
        shr     dl, 4
        add     al, dl
        add     bl, al
.lead_skip:

        ; second glitch fx
        mov     bp, SEQ_GLITCH2
        call    unpack
        jnc     .glfx2_skip
        ; synth
        mov     ax, di
        and     ax, ~7
        mov     edx, edi
        shr     edx, 6
        mul     dx              ; can't use env_mac since we have to multiply words :(
        shr     ax, 13
        add     bl, al          ; write to accumulator
.glfx2_skip:
.gate_skip:

        ; bassline
        ; seq
        pop     dx
        mov     bp, SEQ_BASS
        call    unpack
        jnc     .bass_skip
        ; synth
        mov     ax, di
        test    ax, 0x3000
        setz    cl
        inc     cx
        shr     ax, cl
        call    env_mac                         ; multiply-accumulate
.bass_skip:

        ; glitch fx
        ; seq
        mov     bp, SEQ_GLITCH
        call    unpack
        jnc     .glfx_skip
        ; synth
        shld    ax, dx, (16 - 2)
        shld    edx, edi, (32 - 12)
        mul     dx              ; can't use env_mac since we have to multiply words :(
        shr     ax, 12
        add     bl, al          ; write to accumulator
.glfx_skip:

        ; write data to the Covox/PC Speaker port
        xchg    ax, bx
        add     al, [es:di - ((SAMPLE_RATE * 3)/8)]      ; add echo buffer contents
        mov     ah, [es:di - ((SAMPLE_RATE * 6)/10)]
        shr     ah, 1
        add     al, ah 
        mov     dx, 0x378
.port   equ     $-2
        out     dx, al

        ; fill echo buffer
        shr     al, 2                   ; *= 0.25
        mov     [es:di], al

        ; acknowledge IRQ (not needed in case of INT 1C)
%ifndef INT1C
        mov     al, 0x20
        out     0x20, al
%endif

        ; restore regs and advance sample counter
%ifndef TINY
        popa
%endif
        inc     edi
        iret

