/**
	FROSTBYTE'S SUBWOOFER TEST AT THE CLUB

	Start with SYS 4000

	Contains the following features in 128 bytes:
	- Screen colour change to black (wow!)
	- Two SID channels are playing the kickdrum / bass drone sound
	- The evolving light wall has a fade-in effect and uses a custom char
	- Some additional effects (flashing when the bass kicks, shaking to low frequencies, kick is not kicking consistently)
 */

* = 4000
			jsr $e544				// Clear screen (that is, set all screenram to $20)
kick:			stx $d018				// X holds $18 when entering from wall loop (screenram $0400, charset $2000)
			stx $d418				// sid filter type and global volume
			ldy #(kick_freq_end-kick_freq-1)	// Length of kickdrum freq table
			tsx					// SP holds $f7 (debugger) or $f6 (vice)? Which one is right? Who cares, it works
			stx $d417				// sid resonance value and filtermask
rasterwait:		cpx $d012				// Wait until rasterline $f6 (when playing kick) or random (when drawing just wall)
			bne rasterwait
			cpy #$ff				// If Y is negative, we're not playing the kick at the moment
			beq wall
			ldx #2
			stx $d416				// sid cutoff hi
		!:	lda kick_freq,y				// Update kickdrum frequency
			// sta $d400-1,x
			sta $d400-1+7,x
			sta $d400-1+14,x
			dey
			dex
			bne !-
			sta $d020				// Screen to kickdrum freq lo/hi, nicely ends with $f0 (black)
			sta $d021
			stx $a2					// reset our tempo timer
			ldx #3					// Init the two sid channels used: ADSR 00F0, pulse, gate on, pulsewidth 400
		!:	lda sid_init,x
			// sta $d403,x
			sta $d403+7,x
			sta $d403+14,x
			dex
			bpl !-
wall:			lax $a2					// poor man's tempo timer: lowest byte of TI
			eor #$18				// When counted up to $18, play kickdrum
			beq kick				// A bit of hit and miss due to rasterwaits, but gives free variation
			lax $dc04				// Randomish value from CIA#1 timer lo
			and $a1					// And with mid byte of TI to get nice colour variations
		!:	sta $d800,x				// Store colours to randomish locations (gives nice patterns)
			sta $d900,x
			sta $da00,x
			sta $db00,x
			lda light_char,x			// custom char for the lights on the light wall
			sta $2000+8*$20,x			// Char $20 in our custom charset at $2000
			txa
			and #%00000011				// Use randomish value in X to shake the screen
			sta $d016
			ora #%00010000
			sta $d011
			bvc rasterwait				// ...and we're done. Back to rasterwait

light_char:		.byte %00000000
			.byte %00011111
			.byte %00111111
			.byte %01111111
			.byte %01111110
			.byte %01111101
			.byte %01111010
sid_init:		.byte %01110100				// sid init reuses last byte of disco char and first byte of kickdrum freq table.
			.byte $41, $00
kick_freq:		.word $01F0				// freq lo/hi of the kickdrum
			.word $024E
			.word $0314
			.word $03A9
			// .word $0752				// could have enabled one more kickdrum freq, but hey, now the prod is exactly 128b in filesize
			// .word $138A
			.word $09C5
kick_freq_end:
