/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.effects;

import ddf.minim.effects.IIRFilter;

public class NotchFilter
extends IIRFilter {
    private float bw;

    public NotchFilter(float freq, float bandWidth, float sampleRate) {
        super(freq, sampleRate);
        this.setBandWidth(bandWidth);
    }

    public void setBandWidth(float b) {
        this.bw = b / this.sampleRate();
    }

    public float getBandWidth() {
        return this.bw * this.sampleRate();
    }

    @Override
    protected void calcCoeff() {
        float fracFreq = this.frequency() / this.sampleRate();
        float R = 1.0f - 3.0f * this.bw;
        float T = 2.0f * (float)Math.cos(Math.PI * 2 * (double)fracFreq);
        float K = (1.0f - R * T + R * R) / (2.0f - T);
        this.a = new float[]{K, -K * T, K};
        this.b = new float[]{R * T, -R * R};
    }
}

