/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import processing.core.PApplet;
import processing.core.PFont;

public class marin_graffathon_2024
extends PApplet {
    Minim minim;
    AudioPlayer player;
    int startTime;
    float ellipsesX;
    float ellipsesY;
    float ellipsesXSpeed;
    float ellipsesYSpeed;
    float rectyX;
    float rectyY;
    float rectyXSpeed;
    float rectyYSpeed;
    int rectSize1;
    int rectSize2;
    int rectSize3;
    int numLines;
    float angle;
    PFont font;
    float angleOffset;
    String[] lines;
    float textY;
    int currentColorIndex;
    int changeInterval;
    int lastChangeTime;
    int[] blinkyColors;
    int numCircles;
    float maxRadius;
    float minRadius;
    float speed;

    public marin_graffathon_2024() {
        this.ellipsesX = this.width / 2;
        this.ellipsesY = this.height / 2;
        this.ellipsesXSpeed = 20.0f;
        this.ellipsesYSpeed = 20.0f;
        this.rectyXSpeed = 60.0f;
        this.rectyYSpeed = 60.0f;
        this.rectSize1 = 400;
        this.rectSize2 = 1800;
        this.rectSize3 = 4000;
        this.numLines = 24;
        this.angle = 2.0f;
        this.angleOffset = 0.0f;
        this.lines = new String[]{"Demo by Marin \"Bala-Koala\" Balabanov", " ", "Music \"Go Cart - Loop Mix\" by Kevin MacLeod", "(incompetech.com)", " ", "Made at Graffathon 2024", "using Processing"};
        this.currentColorIndex = 0;
        this.changeInterval = 400;
        this.lastChangeTime = 0;
        this.blinkyColors = new int[]{this.color(255, 0, 0), this.color(0), this.color(0, 255, 0), this.color(0), this.color(0, 0, 255), this.color(0), this.color(255, 255, 0), this.color(0), this.color(255, 0, 255), this.color(0), this.color(0, 255, 255), this.color(0), this.color(255, 128, 0), this.color(0), this.color(128, 0, 255), this.color(0), this.color(255, 0, 128), this.color(0), this.color(0, 28, 255), this.color(0), this.color(128, 255, 0), this.color(0), this.color(255, 255, 255)};
        this.numCircles = 8;
        this.maxRadius = 800.0f;
        this.minRadius = 100.0f;
        this.speed = 5.0f;
    }

    public void setup() {
        this.noCursor();
        this.startTime = this.millis();
        this.minim = new Minim((Object)this);
        this.player = this.minim.loadFile("data/kick-shock.mp3");
        this.player.play();
        this.textY = this.height;
    }

    public void draw() {
        int elapsedTime = this.millis() - this.startTime;
        if (elapsedTime < 1000) {
            this.background(0);
        } else if (elapsedTime < 4000) {
            this.glitchTextFlash("GLITCH", 64, 0, 0, 540);
        } else if (elapsedTime < 8000) {
            this.starLines(255, 100, 150);
        } else if (elapsedTime < 10000) {
            this.rectyMess();
        } else if (elapsedTime < 11000) {
            this.glitchTextFlash("EPI", 255, 96, 64, 800);
        } else if (elapsedTime < 12000) {
            this.glitchTextFlash("LEP", 200, 45, 64, 800);
        } else if (elapsedTime < 13000) {
            this.glitchTextFlash("S\u00cd", 40, 208, 250, 800);
        } else if (elapsedTime < 19600) {
            this.rectyMess();
        } else if (elapsedTime < 22000) {
            this.starLines(192, 128, 32);
        } else if (elapsedTime < 25000) {
            this.glitchTextFlash("ITCH", 64, 128, 200, 600);
        } else if (elapsedTime < 28000) {
            this.bouncingEllipses();
        } else if (elapsedTime < 43000) {
            this.pulsatingRectangles();
        } else if (elapsedTime < 57000) {
            this.blinkColors();
        } else if (elapsedTime < 65000) {
            this.creditScroll();
        } else if (elapsedTime < 69000) {
            this.expandingCircles();
        } else {
            this.stopDemo();
            this.background(0);
        }
    }

    public void stopDemo() {
        this.player.close();
        this.minim.stop();
        super.stop();
    }

    public void generateGradient(int colR, int colG, int colB) {
        int y = 0;
        while (y < this.height) {
            float inter = marin_graffathon_2024.map((float)y, (float)0.0f, (float)this.height, (float)0.0f, (float)1.0f);
            int c = this.lerpColor(this.color(colR, colG, colB), this.color(colB, colG, colR), inter);
            this.stroke(c);
            this.line(0.0f, y, this.width, y);
            ++y;
        }
    }

    public void bouncingEllipses() {
        this.blendMode(2);
        this.background(160.0f, 80.0f, 0.0f);
        int rndOffset = 400;
        this.fill(170.0f, 90.0f, 10.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 500.0f + this.random(1.0f, rndOffset), this.ellipsesY - 500.0f + this.random(1.0f, rndOffset), 2200.0f, 2200.0f);
        this.fill(180.0f, 100.0f, 20.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 450.0f + this.random(1.0f, rndOffset), this.ellipsesY - 450.0f + this.random(1.0f, rndOffset), 2000.0f, 2000.0f);
        this.fill(190.0f, 110.0f, 30.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 400.0f + this.random(1.0f, rndOffset), this.ellipsesY - 400.0f + this.random(1.0f, rndOffset), 1800.0f, 1800.0f);
        this.fill(200.0f, 120.0f, 40.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 350.0f + this.random(1.0f, rndOffset), this.ellipsesY - 350.0f + this.random(1.0f, rndOffset), 1600.0f, 1600.0f);
        this.fill(210.0f, 130.0f, 50.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 300.0f + this.random(1.0f, rndOffset), this.ellipsesY - 300.0f + this.random(1.0f, rndOffset), 1400.0f, 1400.0f);
        this.fill(220.0f, 140.0f, 60.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 250.0f + this.random(1.0f, rndOffset), this.ellipsesY - 250.0f + this.random(1.0f, rndOffset), 1200.0f, 1200.0f);
        this.fill(230.0f, 150.0f, 70.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 200.0f + this.random(1.0f, rndOffset), this.ellipsesY - 200.0f + this.random(1.0f, rndOffset), 1000.0f, 1000.0f);
        this.fill(240.0f, 160.0f, 100.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 150.0f + this.random(1.0f, rndOffset), this.ellipsesY - 150.0f + this.random(1.0f, rndOffset), 800.0f, 800.0f);
        this.fill(250.0f, 180.0f, 140.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 100.0f + this.random(1.0f, rndOffset), this.ellipsesY - 100.0f + this.random(1.0f, rndOffset), 600.0f, 600.0f);
        this.fill(255.0f, 200.0f, 160.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 75.0f + this.random(1.0f, rndOffset), this.ellipsesY - 75.0f + this.random(1.0f, rndOffset), 400.0f, 400.0f);
        this.fill(255.0f, 240.0f, 200.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 50.0f + this.random(1.0f, rndOffset), this.ellipsesY - 50.0f + this.random(1.0f, rndOffset), 200.0f, 200.0f);
        this.fill(255.0f, 255.0f, 240.0f, 60.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + 25.0f + this.random(1.0f, rndOffset), this.ellipsesY - 25.0f + this.random(1.0f, rndOffset), 100.0f, 100.0f);
        this.fill(255.0f, 255.0f, 255.0f, 90.0f);
        this.noStroke();
        this.ellipse(this.ellipsesX + this.random(1.0f, rndOffset), this.ellipsesY + this.random(1.0f, rndOffset), 50.0f, 50.0f);
        this.ellipsesX += this.ellipsesXSpeed;
        this.ellipsesY += this.ellipsesYSpeed;
        if (this.ellipsesX > (float)(this.width - 25) || this.ellipsesX < 25.0f) {
            this.ellipsesXSpeed *= -1.0f;
        }
        if (this.ellipsesY > (float)(this.height - 25) || this.ellipsesY < 25.0f) {
            this.ellipsesYSpeed *= -1.0f;
        }
    }

    public void rectyMess() {
        this.drawRectyMess(this.rectyX + 60.0f, this.rectyY + 60.0f, this.rectSize3, 90, 200, 40);
        this.rectyX += this.rectyXSpeed;
        this.rectyY += this.rectyYSpeed;
        if (this.rectyX > (float)(this.width - this.rectSize1 / 2) || this.rectyX < (float)(this.rectSize1 / 2)) {
            this.rectyXSpeed *= -1.0f;
        }
        if (this.rectyY > (float)(this.height - this.rectSize1 / 2) || this.rectyY < (float)(this.rectSize1 / 2)) {
            this.rectyYSpeed *= -1.0f;
        }
    }

    public void drawRectyMess(float cx, float cy, float diameter, int ballRed, int ballGreen, int ballBlue) {
        int rows = 20;
        int cols = 16;
        float checkerSize = diameter / (float)cols;
        int i = 0;
        while (i < rows) {
            int j = 0;
            while (j < cols) {
                if ((i + j) % 2 == 0) {
                    this.fill(ballRed, ballGreen, ballBlue);
                } else {
                    this.fill(ballBlue, ballRed, ballGreen);
                }
                float xPos = cx + diameter / 2.0f - (float)j * checkerSize;
                float yPos = cy + diameter / 2.0f - (float)i * checkerSize;
                this.rect(xPos, yPos, checkerSize, checkerSize);
                ++j;
            }
            ++i;
        }
    }

    public void pulsatingRectangles() {
        this.background(10.0f, 20.0f, 15.0f);
        this.blendMode(2);
        int i = 0;
        while (i < 22) {
            ++i;
            int j = 0;
            while (j < 12) {
                int posX = i * 80;
                int posY = ++j * 80;
                float dist1 = this.random(10.0f) + 2.0f;
                float dist2 = this.random(10.0f) + 3.0f;
                float squareSize = this.random(80.0f);
                float squareCol1 = this.random(240.0f);
                float squareCol2 = this.random(240.0f);
                float squareCol3 = this.random(240.0f);
                float squareAlpha = this.random(240.0f);
                this.noStroke();
                this.fill(squareCol1, 0.0f, 0.0f, squareAlpha);
                this.rect(posX, posY, squareSize, squareSize);
                this.noStroke();
                this.fill(0.0f, squareCol2, 0.0f, squareAlpha);
                this.rect((float)posX + dist1, (float)posY + dist2, squareSize, squareSize);
                this.noStroke();
                this.fill(0.0f, 0.0f, squareCol3, squareAlpha);
                this.rect((float)posX + dist2 * 2.0f, (float)posY + dist1 * 2.0f, squareSize, squareSize);
            }
        }
    }

    public void starLines(int rA, int gA, int bA) {
        this.noStroke();
        this.generateGradient(rA, gA, bA);
        this.translate(this.width / 2, this.height / 2);
        float spacing = (float)Math.PI * 2 / (float)this.numLines;
        int i = 0;
        while (i < this.numLines) {
            this.noStroke();
            this.fill(210.0f, 130.0f, 50.0f, 40.0f);
            this.ellipse(this.width / 2, this.height / 2, 120 * i, 120 * i);
            float x = marin_graffathon_2024.cos((float)(this.angle + spacing * (float)i)) * 1200.0f;
            float y = marin_graffathon_2024.sin((float)(this.angle + spacing * (float)i)) * 1200.0f;
            this.stroke(200.0f, 60.0f, 80.0f, 80.0f);
            this.strokeWeight(100.0f);
            this.line(0.0f, 0.0f, x, y);
            ++i;
        }
        this.angle += 0.02f;
    }

    public void glitchTextFlash(String glitchedText, int colR, int colG, int colB, int textSize) {
        this.font = this.createFont("Arial", textSize, true);
        this.textFont(this.font);
        this.textAlign(3, 3);
        this.generateGradient(colR, colG, colB);
        float distortionAmount = marin_graffathon_2024.sin((float)this.angleOffset) * 40.0f;
        this.fill(255.0f, 255.0f, 255.0f, 60.0f);
        this.text(glitchedText, this.width / 2, this.height / 2);
        this.fill(255.0f, 0.0f, 0.0f, 60.0f);
        this.text(glitchedText, (float)(this.width / 2) + distortionAmount, this.height / 2);
        this.fill(0.0f, 255.0f, 0.0f, 60.0f);
        this.text(glitchedText, (float)(this.width / 2) - distortionAmount, this.height / 2);
        this.fill(0.0f, 0.0f, 255.0f, 60.0f);
        this.text(glitchedText, this.width / 2, (float)(this.height / 2) + distortionAmount);
        this.angleOffset += 2.0f;
    }

    public void blinkColors() {
        int currentTime = this.millis();
        if (currentTime - this.lastChangeTime > this.changeInterval) {
            this.currentColorIndex = (this.currentColorIndex + 1) % this.blinkyColors.length;
            this.lastChangeTime = currentTime;
        }
        this.background(this.blinkyColors[this.currentColorIndex]);
    }

    public void expandingCircles() {
        this.noStroke();
        this.background(this.random(1.0f, 255.0f), this.random(1.0f, 255.0f), this.random(1.0f, 255.0f), 40.0f);
        this.blendMode(2);
        int i = 0;
        while (i < this.numCircles) {
            float radius = this.minRadius + (this.maxRadius - this.minRadius) * ((float)i / (float)this.numCircles);
            float offset = (float)this.frameCount * this.speed % (float)this.height;
            float y = (float)this.height - ((float)(i * this.height / this.numCircles) + offset) % (float)this.height;
            float alpha = marin_graffathon_2024.map((float)y, (float)this.height, (float)0.0f, (float)0.0f, (float)128.0f);
            this.fill(this.random(1.0f, 255.0f), this.random(1.0f, 255.0f), this.random(1.0f, 255.0f), alpha);
            this.ellipse(this.width / 2, y, radius * 2.0f, radius * 2.0f);
            this.textSize(80.0f);
            this.textAlign(3, 3);
            this.fill(220.0f, 200.0f, 20.0f);
            this.text("Special thanks to the\nGraffathon organizers!", this.width / 2, this.height / 2 + 400);
            ++i;
        }
    }

    public void creditScroll() {
        this.blendMode(1);
        this.textSize(80.0f);
        this.textAlign(3, 3);
        this.fill(220.0f, 200.0f, 20.0f);
        this.background(0.0f, 0.0f, 0.0f, 0.0f);
        int i = 0;
        while (i < this.lines.length) {
            this.text(this.lines[i], this.width / 2, this.textY + (float)(i * 60));
            ++i;
        }
        this.textY -= 3.0f;
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"--full-screen", "--bgcolor=#666666", "--stop-color=#cccccc", "marin_graffathon_2024"};
        if (passedArgs != null) {
            PApplet.main((String[])marin_graffathon_2024.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

