p5.disableFriendlyErrors = true;
let END = false;
let STARTED = false;

function centeredRandom() {
  return random() * 2.0 - 1.0;
}

function preload() {
  song = loadSound("Catro.mp3");
  concreteShader = loadShader("shader.vert", "shader.frag");
  font = loadFont('font.otf');
  valiologo = loadImage('valiobeats.jpeg');
  pannulogo = loadImage("cosmic_pannu_small.jpg");
}

window.addEventListener("keydown", (e) => {
  const key = e.key;

  // f = fullscreen
  if (key === 'f') {
    let fs = fullscreen();
    fullscreen(!fs);
  }

  // esc = exit fullscreen
  if (key === ESCAPE) {
    fullscreen(false);
  }

  // space = start/stop
  if (key === ' ') {
    e.preventDefault();
    if (song.isPlaying()) {
      noLoop();
      song.pause();
    } else {
      loop();
      STARTED = true;
      // song.play();
    }
  }
});

function start() {
  if (END || song.isPlaying()) return;
  song.play();
}

function end() {
  END = true;
  song.pause();
  if (fullscreen()) fullscreen(false);
  noLoop();
}

let W = 1920;
let H = 1080;

function createFilter() {
  let fragSrc = `precision highp float;

  // x,y coordinates, given from the vertex shader
  varying vec2 vTexCoord;

  // the canvas contents, given from filter()
  uniform sampler2D tex0;
  // other useful information from the canvas
  uniform vec2 texelSize;
  uniform vec2 canvasSize;
  uniform float u_time;
  uniform bool negative;
  uniform float splitscreen;
  uniform float chromaticaberrR;
  uniform float chromaticaberrG;
  uniform float chromaticaberrB;
  

  vec2 crtCurve(vec2 uv) {
      uv = uv * 2.0 - 1.0;
      vec2 offset = abs(uv.yx) / vec2(5.0, 3.0);
      uv = uv + uv * offset * offset;
      uv = uv * 0.5 + 0.5;
      return clamp(uv, vec2(0), vec2(1));
  }

  void DrawVignette( inout vec3 color, vec2 uv ) {    
      float vignette = uv.x * uv.y * ( 1.0 - uv.x ) * ( 1.0 - uv.y );
      vignette = clamp( pow( 16.0 * vignette, 0.35 ), 0.0, 1.0 );
      color *= vignette;
  }

  void DrawScanline( inout vec3 color, vec2 uv ) {
      float scanline 	= clamp( 0.95 + 0.1 * cos( 3.14 * ( uv.y + 0.008 * u_time ) * 240.0 * 1.0 ), 0.0, 1.0 );
      float grille 	= 0.85 + 0.1 * clamp( 1.9 * cos( 3.14 * uv.x * 640.0 * 1.0 ), 0.0, 1.0 );    
      color *= scanline * grille * 1.2;
  }

  void main() {
    // get the color at current pixel
    vec2 st0 = crtCurve(vTexCoord);
    vec2 st = st0;
    st = mod(st * splitscreen, vec2(1.0));
    st.y += floor(mod((st.x * .5), .5));
    
    st = crtCurve(st);
    vec3 color = vec3(0.0);
    color.r = texture2D(tex0, st + vec2(chromaticaberrR)).r;
    color.g = texture2D(tex0, st + vec2(chromaticaberrG)).g;
    color.b = texture2D(tex0, st + vec2(chromaticaberrB)).b;
    
    if (negative) {
      color = vec3(1.0) - color;
    }
    DrawVignette(color, st0);
    DrawVignette(color, st);
    DrawScanline(color, st);
    gl_FragColor = vec4(color.rgb, 1.0);
  }`;

  return createFilterShader(fragSrc);
}

function setup() {
  createCanvas(W, H, WEBGL);
  textFont(font);
  textSize(100);
  fft = new p5.FFT();
  filterShader = createFilter();
  noLoop();
}

function splitscreen(n) {
  filterShader.setUniform("splitscreen", n);
}

function aberr(beat) {
  filterShader.setUniform("chromaticaberrR", sin(beat * 0.5) * sin(beat * 0.5) * 0.005);
  filterShader.setUniform("chromaticaberrG", sin(beat * 0.1) * sin(beat * 0.1) * 0.005);
  filterShader.setUniform("chromaticaberrB", cos(beat * 0.4) * cos(beat * 0.4) * 0.005);
}

function img(i, x, y) {
  image(i, x - W / 8, y - W / 8, W / 5, W / 5);
}


let realTime = 1000.0;
const bpm = 171;

function scene(sceneFn, length, opts={}) {
  if (beat > 0 && beat < length) {
    sceneFn(beat + (opts.offset ? opts.offset : 0), opts.speed ? opts.speed : 1);
    // console.log(sceneFn.name);
    if (opts.circles) {
      drawMagicCircles = true;
    }
  }
  beat -= length;
  tot += length;
}

let tot = 0;
let beat = 0;

function draw() {
  if (!END && STARTED) realTime += deltaTime;
  tot = 0;
  beat = 0 + (realTime / 1000 / 60 * bpm);
  beat *= 1;
  
  frustum(-width/80, width/80, -height/80, height/80, 10, 10000);

  
  if (beat < 16) {
    aberr(beat);
    splitscreen(1);
    warning(beat);
  } else {
    start();
    beat -= 16;

    spectrum = fft.analyze();
    /*if (beat % 4 < 0.03) {
      console.log(beat, deltaTime);
    }*/

    const negative = beat % 8 > 7
    circles = negative;
    filterShader.setUniform("negative", negative);
    splitscreen(
      beat % 32 > 30 ? 3 
      : (beat % 16 > 15.5 ? 2 : 1));
    aberr(beat);

    concreteShader.setUniform("u_time", frameCount);
    concreteShader.setUniform("u_noiseStrength", 0.07);
    
    scene(intro, 32, {circles:true});
    scene(piano, 64);
    scene(graph, 32);
    scene(bars, 48);
    scene(city, 64);
    scene(graph, 8, {speed:6});
    scene(piano, 1);
    scene(turntable, 96, {offset:1});
    scene(outro, 128);
    
    clearDepth();
    if (circles) {
      magicCircles(beat);
    }
    magicLines(beat);
  }

  filterShader.setUniform('u_time', 1+frameCount);
  filter(filterShader);
  numberN = 0;
}

let numberN = 0;
function magicLines(beat) {
  push();
  strokeWeight(2);
  stroke(0, 255, 255, 100);
  translate(50*noise(beat), 50*noise(beat + 900));
  line(-W*0.8, -H*0.8, W*0.8, -H*0.8);
  translate(10*noise(beat + 1), 10*noise(beat + 901));
  line(-W*0.8, H*0.8, W*0.8, H*0.8);
  fill("red");
  textSize(48);
  text(Math.ceil(beat), lerp(-W, W, 0.1 * beat % 2.0), H * 0.8 + 48 + 1);
  if (numberN) {
    textSize(64);
    text(`N = ${Math.ceil(numberN)}`, -W * 0.8, -H * 0.8 + 1);
  }
  
  for (let i = 0; i < 5; i++) {
    let x = 4 * (2 * noise(beat * 0.1 + 10 * i) - 1);
    let a = noise(beat * 0.5);
    stroke(100, 100, 100, 30 * a);
    strokeWeight(5 + 5 * i);
    line(W/2 * x - W/2, H, W/2 * x + W/2, -H);
  }
  
  pop();
}

let circles = false;
function magicCircles(beat) {
  for (let i = 0; i < 5; i++) {
    push();
    strokeWeight(2);
    noFill();
    stroke(0, 255, 255, 100);
    const x = lerp(-W * 0.8, W * 0.8, noise(0.2 * beat * (0.1 + i * 0.1) + i * 100));
    const y = H * 0.8 * (i % 2 == 0 ? -1 : 1);
    const d = H / (2 + i) + spectrum[2 + i * 10] * 3.0;
    circle(x, y, d);
    pop();
  }
}

function bars(fk) {
  push();
  // perspective(0.7, W/H);
  
  noStroke();
  camera(100 * sin(fk * 0.1), -40, 100 * cos(fk * 0.1), 0, -50, 0);
  normalMaterial();
  
  // Add a quad as a display surface for the shader.
  for (let i = 0; i < spectrum.length; i++) {
    let v = spectrum[i];
    push();
    translate((i % 10) * 12 - 50, -v/2, Math.floor(i / 10) - (spectrum.length / 2 / 10));
    rotateX(fk * 0.1);
    rotateZ(fk * 0.2);
    rotateY(sin(fk * 0.1))
    box(6, log(v), 6);
    pop();
  }
  numberN = spectrum.length;
  pop();
}

let cityNodes = []
function city(fk) {
  push();
  // background(255.0, 255.0, 255.0);
  lights();
  rotate(fk * 0.0001, createVector(0.0, 0.1, 1.0));
  
  let cityW = 200 * 10;
  
  camera(500, -fk - 150, -fk * 150 + 100, 800, -200, -6000);
  
  push();
  translate(0, 200, 0);
  rotateX(HALF_PI);
  specularMaterial(255, 0, 0);
  ambientMaterial(255, 0, 0);
  resetShader();
  plane(cityW * 10, 10 * 100 * 200);
  pop();
  // fill(255, 255, 255);
  shader(concreteShader);
  ambientMaterial(10);
  specularMaterial(100);
  concreteShader.setUniform("u_noiseStrength", 0.1);
  
  textSize(2 * H);
  push();
  rotateY(PI);
  textLine("Hello Graffathon!", "red", -1000, 0.0);
  pop();
  
  for (let y = 0; y < 40; y++) {
    for (let x = 0; x < 20; x++) {
      push();
      let n1 = noise(x*0.1, y*0.1);
      let bh = 150 + n1 * 20 + spectrum[(x + y * 20) % spectrum.length] + n1;
      let offx = (x % 2) * 50;
      let nx = n1 * 150;
      let ny = noise(y*0.1, x*0.1) * 200;
      
      translate(200 * x - cityW / 2 + nx + offx, 201 + nx - bh / 2, 200 * y - 100 * 100 + ny);
      rotateY(nx * 0.002);
      box(100, bh, 100);
      box(70, bh * 1.2, 70);
      pop();
    }
  }
  
  if (fk % 1 < 0.07) {
    cityNodes.push({
      x: sin(fk * 0.1) * 2000,
      y: -300,
      z: -fk * 200 - 2000,
      neighbour: cityNodes[cityNodes.length - 1]
    })
  }
  
  for (let i = 0; i < cityNodes.length; i++) {
    let v = spectrum[i];
    let node = cityNodes[i];
    node.x += centeredRandom() * 3;
    node.y += centeredRandom() * 3;
    node.z += centeredRandom() * 3;
    
    push();
    translate(node.x, node.y, node.z);
    noStroke();
    sphere(6 + 0.2 * v, 4, 4);
    pop();
    if (node.neighbour) {
      stroke(128, 40, 100);
      strokeWeight(2);
      line(node.x, node.y, node.z, node.neighbour.x, node.neighbour.y, node.neighbour.z);
    }
  }
  
  numberN = 40 * 20;
  
  pop();
}

let nodes = [];

function graph(fk, rotSpeed = 1) {
  const maxFrame = 32;
  // background(255, 255, 255);
  push();
  camera(0, 0, -1000);
  directionalLight(255, 0, 0, 0, 1, 0);
  ambientMaterial(100, 100, 100);
  specularMaterial(100, 100, 100);
  stroke("red");
  strokeWeight(1);
  
  const n = fk / maxFrame;
  if (nodes.length < 600) {
    nodes.push({
      x: centeredRandom() * H * n,
      y: centeredRandom() * H * n,
      z: centeredRandom() * H * n,
      neighbour: nodes[nodes.length - 1]
    })
  }
  
  rotateY(n * TWO_PI * rotSpeed);
  
  for (let i = 0; i < nodes.length; i++) {
    let v = spectrum[i];
    let node = nodes[i];
    node.x += centeredRandom();
    node.y += centeredRandom();
    node.z += centeredRandom();
    
    push();
    translate(node.x, node.y, node.z);
    noStroke();
    sphere(2 + 0.2 * v, 5, 5);
    pop();
    if (node.neighbour) {
      stroke(128, 40, 100);
      line(node.x, node.y, node.z, node.neighbour.x, node.neighbour.y, node.neighbour.z);
    }
  }
  
  pop();
  
  if (n > 0.5) {
    textSize(32);
    textLine("Thanks for the Feedback", "red",-200, H / 2 + 100);
  }
  
  numberN = nodes.length;
}

const nKeys = 50;
const keys = (() => {
  const k = []
  for (let i = 0; i < nKeys; i++) {
    k.push(0);
  }
  return k;
})()

function piano(fk) {
  // background(20, 10, 10);
  noStroke();
  shader(concreteShader);
  lights();
  // directionalLight(100, 100, 100, 0, 1, 1);
  // ambientLight(10, 10, 10);
  ambientMaterial(10, 10, 10);
  specularMaterial(20, 20, 20);
  shininess(0.9);
  
  const crushBeat = 52
  push();
  const fkMove = max(0, fk - 32);
  camera(sin(fk * 0.05) * 50, -30 - (fkMove * fk * 0.04), -20 - (fkMove * fk * 0.4), 0, 0, 0);
  
  if (fk < crushBeat) {
    // PIANO
    push();
    const width = 40;
    push();
    translate(0, -2, -12);
    box(width / 3, 8, 6);
    pop();

    box(width, 14, 10);
    translate(0, -8, 10);
    box(width, 30, 10);
    translate(width / 2 - width/nKeys/2, 0, -10);
    ambientMaterial(150, 150, 150);
    specularMaterial(100);
    translate(0, 1, 0);
    for (let i = 0; i < nKeys; i++) {
      push();
      const v = spectrum[i * 2];
      translate(-i * width/nKeys, -1, 0);
      if (v > 200) {
        keys[i] = Math.min(keys[i] + 0.5, 1);
      } else {
        keys[i] = Math.max(keys[i] - 0.3, 0);
      }
      translate(0, keys[i], 0);
      box(width/nKeys * 0.9, 2, 9);
      emissiveMaterial(0, 0, 0);
      pop();
    }
    pop();
    numberN = nKeys;
  } else {
    // PIECES
    let ffk = fk - crushBeat;
    specularMaterial(255, 0, 0);
    for (let i = 0; i < 60; i++) {
      push();
      const dist = sqrt((30 + i) * ffk) * 20;
      translate(dist * sin(i), 0.0, dist * cos(i));
      rotateX(dist / 10);
      rotateZ(i);
      box(3 + i % 10, 0.2 * spectrum[i] + 6 * (sin(i) + 1), 3 + (i - 5) % 10);
      pop();
    }
    numberN = 60;
  }
  
  const buildingHeight = 2000;
  const buildingWidth = 150;
  
  push();
  translate(0, buildingHeight / 2 - 1, 0);
  ambientMaterial(100, 100, 100);
  specularMaterial(50);
  box(buildingWidth, buildingHeight-1, buildingWidth);
  translate(0, -buildingHeight / 2 + 20, 0);
  box(200, 40, 200);
  pop();
  
  push();
  const buildingMove = min(max(0, fk - 48) * 8, 50);
  translate(1, -buildingHeight / 2 - 50 + buildingMove, 1);
  ambientMaterial(100, 100, 100);
  specularMaterial(50);
  box(buildingWidth, buildingHeight, buildingWidth);
  translate(0, buildingHeight / 2 - 19.9, 0);
  box(200, 40, 200);
  pop();
  
  pop();
  
  if (fkMove > 0 && fk < crushBeat + 2) {
    textSize(200);
    textLine("Testing", "red", 2 * -fk - crushBeat - 800, H * 0.8);
  }
  
  if (fk > crushBeat + 2) {
    textSize(200);
    textLine("Success", "turquoise", 2 * fk - crushBeat + 200, -H * 0.8 + 200);
  }
}

const crushNodes = [];
function turntable(beat) {
  // background(0, 0, 0, 0.1);
  push();
  noStroke();
  lights();
  const moveIn = max(0, 8 - beat) * 40.0;
  const moveOut = max(0, beat - 32) * 50.0;
  const crushIn = max(0, beat - 40);
  const acualCrushIn = max(0, beat - 48);
  const shake = sin(beat * 100.0) * (acualCrushIn > 0 ? (1.0 / (1.0 + acualCrushIn * acualCrushIn)) : 0);
  camera(sin(beat * 0.2) * 50, -30 - moveIn * 0.2, -20 - moveIn - moveOut, shake, shake * 100.0, 0.0);
  
  // concreteShader.setUniform("u_noiseStrength", 0.00);
  shader(concreteShader);
  
  const width = 40;
  
  push();
  ambientMaterial(100);
  translate(0, 5, 0);
  box(100, 10, 40);
  pop();
  
  push();
  box(width, 5, 20);
  pop();
  
  push();
  specularMaterial(128);
  // ambientMaterial(128);
  translate(width / 3.5, 0, 3);
  cylinder(6, 6, 16, 2);
  
  push();
  translate(-0, -3.1, -0);
  // rotateX(HALF_PI);
  rotateY(beat);
  translate(-3, 0, -3);
  rotateX(HALF_PI);
  tint(200, 255, 255, 150);
  image(valiologo, 0, 0, 6, 6);
  pop();
  
  pop();
  
  push();
  specularMaterial(128);
  // ambientMaterial(128);
  translate(-width / 3.5, 0, 3);
  cylinder(6, 6, 16, 2);
  
  push();
  translate(-0, -3.1, -0);
  rotateY(beat);
  translate(-3, 0, -3);
  rotateX(HALF_PI);
  tint(200, 255, 255, 150);
  image(pannulogo, 0, 0, 6, 6);
  pop();
  
  pop();
  
  for (let i = -8; i < 8; i++) {
    push();
    translate(i * 2 + 2, 0, -6);
    if (spectrum[(i + 4) * 8] > 160) {
      emissiveMaterial(255, 0, 255);
    } else {
      emissiveMaterial(0);
    }
    box(1.5, 6, 1.5);
    pop();
  }
  
  push();
  specularMaterial(10);
  ambientMaterial(40);
  translate(0, 1540, 0);
  box(500, 3000, 500);
  pop();
  
  push();
  specularMaterial(10);
  ambientMaterial(40);
  translate(0, -1640 + min(crushIn * 100.0, 100) + min(acualCrushIn * 200.0, 80), 0);
  box(500, 3000, 500);
  pop();
  
  numberN = 2;
  
  if (acualCrushIn > 0.5) {
    // PIECES
    specularMaterial("turquoise");
    for (let i = 0; i < 240; i++) {
      push();
      const dist = sqrt((5 + i) * acualCrushIn) * 70;
      translate(dist * sin(i), 40.0, dist * cos(i));
      rotateX(dist / 10);
      rotateZ(i);
      box(3 + i % 10, spectrum[i] + 6 * (sin(i) + 1), 3 + (i - 5) % 10);
      pop();
    }
    numberN = 240;
    
    for (let i = 0; i < 100; i++) {
      if (crushNodes.length < i + 1) {
        crushNodes.push({
          x:0,y:0,z:0,neighbour:crushNodes[crushNodes.length-1],
        })
      }
      let v = spectrum[(i * 23) % spectrum.length];
      const node = crushNodes[i];
      node.x = sin(i * 0.4 - beat * 0.2) * 1000.0;
      node.y = 20000 + 300 * i - beat * 300.0;
      node.z = cos(i * 0.4 - beat * 0.2) * 1000.0;

      push();
      translate(node.x, node.y, node.z);
      noStroke();
      sphere(2 + 0.5 * v, 5, 5);
      pop();
      if (node.neighbour) {
        stroke("turquoise");
        line(node.x, node.y, node.z, node.neighbour.x, node.neighbour.y, node.neighbour.z);
      }
    }
  }

  pop();
  
  textSize(90);
  if (!crushIn) {
    textLine("GO FOR LAUNTS", "red", -W * 0.8, H * 0.5);
  } else if (crushIn && !acualCrushIn) {
    textLine("HOLD", "red", -W * 0.8, H * 0.5);
  } else if (acualCrushIn) {
    textLine("CRUSH", "turquoise", W * 0.4, -H * 0.5);
    circles = true;
  }
}

function intro(beat) {
  // background("black");
  stroke("pink");
  strokeWeight(2);
  line(-W, -H, W, H);
  if (beat > 1 && beat < 16) {
    textSize(50);
    textLine("final flashy warnng!1", "red",0, H / 2 * 0.9);
    if (beat > 12 && beat < 16) {
      textLine("extreme flashynes incoming","red", 0, H / 2 * 1.1);
    }
  }
  textSize(150);
  textLine("Veikko", "pink",-W / 2 * 0.9, -H / 2 * 0.9 + 100);
  if (beat > 2) {
    img(pannulogo, -W / 2 * 0.2, -H/2 * 0.9 - 150);
  }
  if (beat > 4) {
    textLine("VALIOBEATS", "pink",-W / 2 * 0.7, -H / 2 * 0.5 + 100);
  }
  if (beat > 6) {
    img(valiologo, W * 0.2, -H / 2 * 0.5 - 60);
  }
  if (beat > 16) {
    textSize(500);
    textLine("CATRO","turquoise", -W * 0.4, H / 2 * 0.9);
  }
  
  if (beat > 15) {
    textSize(100);
    textLine("made in p5js", "red", -W * 0.9, H / 2 * 0.9);
  }
}

function warning(beat) {
  background("black");
  textSize(H * 0.9);
  textLine("WARNING","red",-W * 1.1, -200);
  if (beat > 2) {
    textSize(H/2);
    textLine("EXTRA","red",-W, H/2);
  }
  if (beat > 4) {
    textSize(H/2);
    textLine("FLASHZ","red",-W, H);
  }
  if (beat > 12) {
    textSize(H/2);
    textLine("ENJOY","red", 0, H/2);
  }
  text(`${Math.ceil(beat)}/16`, 0, H);
}

function outro(beat) {
  push();
  shader(concreteShader);
  concreteShader.setUniform("u_noiseStrength", 0.5);
  splitscreen(beat / 2);
  aberr(0.5);
  noStroke();
  plane(W, H);
  pop();
  img(pannulogo, -W * 0.2, 0.0);
  img(valiologo, W * 0.2, 0.0);
  textSize(300);
  textLine("thakn you for experiesing", "turquoise", -W, H * 0.5);
  if (beat > 16) {
    splitscreen(1);
    textSize(500);
    filterShader.setUniform("negative", true);
    textLine("CATRO","red", -W * 0.6, -H * 0.3)
    numberN = 9000
  }
  if (beat > 32) end();
}

function textLine(str, col, x, y) {
  strokeWeight(8);
  stroke(col);
  fill(col);
  line(x, y + 20, x + 600, y + 20)
  text(str, x, y);
  noStroke();
}
