/*
 * Decompiled with CFR 0.152.
 */
package bk2010.util;

import bk2010.preferences.PathStrings;
import bk2010.util.Log;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public final class ScreenshotSaver
extends Thread {
    private static final ScreenshotSaver SSThread;
    private static boolean writePending;
    private static BufferedImage shotData;
    private static int screenshots;

    static {
        writePending = false;
        screenshots = 0;
        SSThread = new ScreenshotSaver();
        SSThread.start();
    }

    private ScreenshotSaver() {
        super("ScreenshotSaver");
        this.setPriority(4);
        this.setDaemon(true);
    }

    private static void saveScreenShotData(String namePrefix) {
        if (shotData == null) {
            return;
        }
        if (namePrefix == null) {
            namePrefix = "bk2010_";
        }
        String fullName = new String();
        File shotdir = new File(PathStrings.screenshotsPath);
        if (shotdir.exists() && shotdir.isDirectory() || shotdir.mkdir()) {
            File shot;
            do {
                if (screenshots <= 9999) continue;
                Log.l("Maximum screenshot count (10000) exceeded");
                shot = new File(shotdir + namePrefix + ".png");
                break;
            } while ((shot = new File(fullName = String.valueOf(PathStrings.screenshotsPath) + File.separator + String.format("%s%04d.png", namePrefix, screenshots++))).exists());
            try {
                ImageIO.write((RenderedImage)shotData, "png", shot);
                Log.l("Screenshot " + fullName + "  saved");
            }
            catch (IOException e) {
                Log.error("Error saving screenshot");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(BufferedImage shot) {
        Log.l("Saving screenshot");
        WritableRaster clonedRaster = shot.copyData(null);
        BufferedImage cloned = new BufferedImage(shot.getColorModel(), clonedRaster, true, null);
        ScreenshotSaver screenshotSaver = SSThread;
        synchronized (screenshotSaver) {
            shotData = cloned;
            writePending = true;
        }
    }

    public static void saveToClipBoard(BufferedImage shot) {
        ClipboardOutImage cbImage = new ClipboardOutImage(shot);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(cbImage, cbImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                ScreenshotSaver.sleep(70L);
                ScreenshotSaver screenshotSaver = SSThread;
                synchronized (screenshotSaver) {
                    if (writePending) {
                        ScreenshotSaver.saveScreenShotData(null);
                    }
                    writePending = false;
                    shotData = null;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    protected static class ClipboardOutImage
    implements Transferable,
    ClipboardOwner {
        BufferedImage data;

        public ClipboardOutImage(BufferedImage image) {
            this.data = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.imageFlavor};
            return flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.data != null && flavor.equals(DataFlavor.imageFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!flavor.equals(DataFlavor.imageFlavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.data;
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }
}

