/*
 * Decompiled with CFR 0.152.
 */
package bk2010.tools;

import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.cpu.Disasm;
import bk2010.tools.BinProxy;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public class Bkdis {
    static int[] insnLength;
    static boolean[] isLabel;
    static Deque<Integer> traceHeads;

    static void say(String format, Object ... args) {
        System.out.printf(format, args);
    }

    static boolean isTraced(int addr) {
        return insnLength[(addr & 0xFFFE) / 2] >= 0;
    }

    static boolean addTraceHead(int ptr) {
        if (Bkdis.isTraced(ptr &= 0xFFFE)) {
            return false;
        }
        Bkdis.say("Adding trace head: %o\n", ptr);
        Bkdis.isLabel[ptr / 2] = true;
        return traceHeads.offer(ptr);
    }

    static void markLength(int addr, int length) {
        Bkdis.insnLength[(addr & 0xFFFE) / 2] = length;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void main(String[] args) {
        String fname = "files/klad1.bin";
        BinProxy bp = new BinProxy(fname);
        int start = bp.getBaseAddress();
        if (start < 512) {
            start = bp.directReadWord(Math.max(start, 496));
        }
        Bkdis.say("Start address is recognized to be %o\n", start);
        int insnCount = 0;
        insnLength = new int[32768];
        isLabel = new boolean[32768];
        Arrays.fill(insnLength, bp.start / 2, (bp.start + bp.length) / 2, -1);
        traceHeads = new ArrayDeque<Integer>(32768);
        Bkdis.addTraceHead(start);
        QBusReadDTO target = new QBusReadDTO();
        block9: while (!traceHeads.isEmpty()) {
            int head = traceHeads.poll();
            Bkdis.say("Following trace head: %o\n", head);
            if (Bkdis.isTraced(head)) {
                Bkdis.say("  ... this head is already traced\n", new Object[0]);
                continue;
            }
            block10: while (true) {
                if (Bkdis.isTraced(head)) {
                    Bkdis.say("  ... already was here\n", new Object[0]);
                    continue block9;
                }
                ++insnCount;
                Bkdis.say("%s\n", Disasm.disasm(bp, (short)head, true));
                switch (Disasm.classify(bp, (short)head, target)) {
                    case BRANCH: {
                        Bkdis.say("Encountered conditional branch at %o, forking trace\n", head);
                        Bkdis.addTraceHead(target.value);
                        Bkdis.markLength(head, 2);
                        head += 2;
                        continue block10;
                    }
                    case DIRECTCALL: {
                        Bkdis.say("Encountered direct call at %o, forking trace\n", head);
                        Bkdis.addTraceHead(target.value);
                        Bkdis.markLength(head, 4);
                        head += 4;
                        continue block10;
                    }
                    case DIRECTJUMP: {
                        Bkdis.say("Encountered direct jump at %o, redirecting trace\n", head);
                        Bkdis.markLength(head, Disasm.length(bp, (short)head) * 2);
                        head = target.value & 0xFFFF;
                        continue block10;
                    }
                    case INDIRECTCALL: {
                        Bkdis.say("Encountered indirect call at %o, ***RUNAWAY TRACE***\n", head);
                        break;
                    }
                    case INDIRECTJUMP: {
                        Bkdis.say("Encountered indirect jump at %o, stopping trace, ***RUNAWAY TRACE***\n", head);
                        continue block9;
                    }
                    case INVALID: {
                        Bkdis.markLength(head, 0);
                        Bkdis.say("Encountered invalid/halt instruction at %o, stopping trace\n", head);
                        continue block9;
                    }
                    case RETURN: {
                        Bkdis.markLength(head, 0);
                        Bkdis.say("Encountered return at %o, stopping trace\n", head);
                        continue block9;
                    }
                }
                int dl = Disasm.length(bp, (short)head) * 2;
                Bkdis.markLength(head, dl);
                head += dl;
            }
        }
        Bkdis.say("Tracing complete; %d instructions found\n", insnCount);
        int ofs = bp.start;
        int end = bp.start + bp.length;
        while (ofs < end) {
            int ilen = insnLength[ofs / 2];
            if (ilen <= 0) {
                Bkdis.say("\t.word %o\n", bp.raw[ofs / 2] & 0xFFFF);
                ofs += 2;
                continue;
            }
            String pfx = isLabel[ofs / 2] ? String.format("L%o:\t", ofs) : "\t";
            Bkdis.say("%s%s\n", pfx, Disasm.disasm(bp, (short)ofs, false));
            ofs += ilen;
        }
    }
}

