/*
 * Decompiled with CFR 0.152.
 */
package bk2010.tools;

import bk2010.hardware.bus.QBusProxy;
import bk2010.io.FakeTape;
import bk2010.util.Log;

public class BinProxy
extends QBusProxy {
    short[] raw = new short[32768];
    int start;
    int length;

    @Override
    public int getBaseAddress() {
        return this.start;
    }

    @Override
    public int getNumWords() {
        return (this.length + 1) / 2;
    }

    @Override
    public boolean gotInterrupt() {
        return false;
    }

    @Override
    public byte interruptVector() {
        return 0;
    }

    @Override
    public void reset() {
    }

    @Override
    public int peekWord(int addr) {
        return this.raw[addr / 2] & 0xFFFF;
    }

    @Override
    public boolean writeWord(int addr, short data) {
        this.raw[addr / 2] = data;
        return true;
    }

    @Override
    public boolean writeByteAsWord(int addr, short data) {
        int ptr = (addr &= 0xFFFF) / 2;
        this.raw[ptr] = (addr & 1) == 0 ? (short)(this.raw[ptr] & 0xFF00 | data & 0xFF) : (short)(this.raw[ptr] & 0xFF | data & 0xFF00);
        return true;
    }

    public int directReadWord(int addr) {
        return this.raw[(addr & 0xFFFE) >> 1] & 0xFFFF;
    }

    public BinProxy(String binPath) {
        FakeTape.forceLoad(this, binPath, false);
        this.start = this.raw[90];
        this.length = this.raw[91];
        Log.l("Loaded %s at %o(%o)\n", binPath, this.start, this.length);
    }
}

