/*
 * Decompiled with CFR 0.152.
 */
package bk2010.recorder;

import bk2010.recorder.FlicHeader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public class FlicEncoder
implements Closeable {
    public static final short TYPE_FLI = -20719;
    public static final short TYPE_FLC = -20718;
    public static final short CHUNK_FRAME = -3590;
    public static final short CHUNK_PAL256 = 4;
    public static final short CHUNK_PAL64 = 11;
    public static final short CHUNK_FRAME_BLACK = 13;
    public static final short CHUNK_FRAME_RAW = 16;
    public static final short CHUNK_FRAME_RLE = 15;
    public static final short CHUNK_FRAME_DELTA_FLI = 12;
    public static final short CHUNK_FRAME_DELTA_FLC = 7;
    protected RandomAccessFile flic;
    boolean disabled = false;
    final FlicHeader header;
    final int width;
    final int height;
    final int area;
    final byte[] frameBuffer;
    final byte[] encodeBuffer;
    int bufPos = 0;
    protected int frameCounter = 0;
    protected int byteCounter = 0;
    int[] chunkStack = new int[10];
    int chunkSP = -1;

    public FlicEncoder(String fileName, int width, int height, int aspectX, int aspectY, int frameTime) {
        this.width = width;
        this.height = height;
        this.area = width * height;
        try {
            this.flic = new RandomAccessFile(fileName, "rw");
        }
        catch (FileNotFoundException e) {
            this.disabled = true;
            this.header = null;
            this.frameBuffer = null;
            this.encodeBuffer = null;
            return;
        }
        this.header = new FlicHeader(width, height, aspectX, aspectY, frameTime);
        this.writeHeader(false);
        this.frameBuffer = new byte[this.area];
        this.encodeBuffer = new byte[this.area + width + 2000];
    }

    protected void disable() {
        if (this.disabled) {
            return;
        }
        this.disabled = true;
        if (this.flic != null) {
            try {
                this.flic.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public FlicEncoder flicWriteByte(int b) {
        if (this.disabled) {
            return this;
        }
        try {
            this.flic.write(b);
        }
        catch (IOException e) {
            this.disable();
        }
        return this;
    }

    public FlicEncoder flicWriteBytes(byte[] data) {
        if (this.disabled) {
            return this;
        }
        try {
            this.flic.write(data);
        }
        catch (IOException e) {
            this.disable();
        }
        return this;
    }

    public FlicEncoder flicWriteBytes(byte[] data, int offset, int length) {
        if (this.disabled) {
            return this;
        }
        try {
            this.flic.write(data, offset, length);
        }
        catch (IOException e) {
            this.disable();
        }
        return this;
    }

    void writeByte(int b) {
        this.encodeBuffer[this.bufPos++] = (byte)b;
    }

    void writeShort(int s) {
        this.encodeBuffer[this.bufPos++] = (byte)s;
        this.encodeBuffer[this.bufPos++] = (byte)(s >> 8);
    }

    void writeInt(int i) {
        this.encodeBuffer[this.bufPos++] = (byte)i;
        this.encodeBuffer[this.bufPos++] = (byte)(i >> 8);
        this.encodeBuffer[this.bufPos++] = (byte)(i >> 16);
        this.encodeBuffer[this.bufPos++] = (byte)(i >> 24);
    }

    void writeBytes(byte[] data, int offset, int count) {
        System.arraycopy(data, offset, this.encodeBuffer, this.bufPos, count);
        this.bufPos += count;
    }

    boolean startChunk(int chunkType) {
        if (this.chunkSP >= this.chunkStack.length) {
            return false;
        }
        ++this.chunkSP;
        this.chunkStack[this.chunkSP] = this.bufPos;
        this.bufPos += 4;
        this.writeShort(chunkType);
        return true;
    }

    boolean endChunk() {
        if (this.chunkSP < 0) {
            return false;
        }
        int tmp = this.bufPos;
        this.bufPos = this.chunkStack[this.chunkSP--];
        this.writeInt(tmp - this.bufPos);
        this.bufPos = tmp;
        return true;
    }

    private void writeHeader(boolean isClosed) {
        this.flicWriteBytes(this.header.asBytes(isClosed));
    }

    private void nextFrame(int subChunks) {
        if (this.disabled) {
            return;
        }
        try {
            this.byteCounter = (int)this.flic.getFilePointer();
        }
        catch (IOException e) {
            this.disable();
        }
        this.header.patchSize = this.byteCounter;
        switch (++this.frameCounter) {
            case 1: {
                this.header.patchOFrame1 = this.byteCounter;
                break;
            }
            case 2: {
                this.header.patchOFrame2 = this.byteCounter;
            }
        }
        this.header.patchFrames = this.frameCounter;
        this.bufPos = 0;
        this.startChunk(-3590);
        this.writeShort(subChunks);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(0);
    }

    private void finishChunks() {
        while (this.chunkSP >= 0) {
            this.endChunk();
        }
        this.flicWriteBytes(this.encodeBuffer, 0, this.bufPos);
        this.bufPos = 0;
    }

    protected void encodePalette(byte[] palette) {
        if (this.startChunk(4)) {
            this.writeShort(1);
            this.writeByte(0);
            this.writeByte(0);
            this.writeBytes(palette, 0, 768);
            this.endChunk();
        }
    }

    public void encodeBlackFrame(byte[] palette) {
        Arrays.fill(this.frameBuffer, (byte)0);
        if (palette != null) {
            this.nextFrame(2);
            this.encodePalette(palette);
        } else {
            this.nextFrame(1);
        }
        if (this.startChunk(13)) {
            this.endChunk();
        }
        this.finishChunks();
    }

    public void encodeCopyFrame(byte[] palette) {
        if (palette != null) {
            this.nextFrame(2);
            this.encodePalette(palette);
        } else {
            this.nextFrame(1);
        }
        if (this.startChunk(7)) {
            this.writeShort(0);
            this.endChunk();
        }
        this.finishChunks();
    }

    public void encodeRawFrame(byte[] frame, byte[] palette) {
        System.arraycopy(frame, 0, this.frameBuffer, 0, this.area);
        if (palette != null) {
            this.nextFrame(2);
            this.encodePalette(palette);
        } else {
            this.nextFrame(1);
        }
        if (this.startChunk(16)) {
            this.writeBytes(frame, 0, this.area);
            this.endChunk();
        }
        this.finishChunks();
    }

    public void encodeRLEFrame(byte[] frame, byte[] palette) {
        System.arraycopy(frame, 0, this.frameBuffer, 0, this.area);
        if (palette != null) {
            this.nextFrame(2);
            this.encodePalette(palette);
        } else {
            this.nextFrame(1);
        }
        if (this.startChunk(15)) {
            int line = 0;
            while (line < this.height) {
                int lofs = line * this.width;
                int pos = 0;
                int rawBytes = 0;
                this.writeByte(0);
                while (pos < this.width) {
                    byte b = frame[lofs + pos++];
                    if (pos + 2 < this.width && b == frame[lofs + pos] && b == frame[lofs + pos + 1]) {
                        int count;
                        while (rawBytes > 0) {
                            count = rawBytes > 127 ? 127 : rawBytes;
                            this.writeByte(-count);
                            while (count-- > 0) {
                                this.writeByte(pos - rawBytes-- - 1);
                            }
                        }
                        count = 3;
                        pos += 2;
                        while (pos < this.width && count < 127 && frame[lofs + pos] == b) {
                            ++count;
                            ++pos;
                        }
                        this.writeByte(count);
                        this.writeByte(b);
                        continue;
                    }
                    ++rawBytes;
                }
                while (rawBytes > 0) {
                    int count = rawBytes > 127 ? 127 : rawBytes;
                    this.writeByte(-count);
                    while (count-- > 0) {
                        this.writeByte(pos - rawBytes--);
                    }
                }
                ++line;
            }
            this.endChunk();
        }
        this.finishChunks();
    }

    public void encodeDeltaFrame(byte[] frame, byte[] palette) {
        if (palette != null) {
            this.nextFrame(2);
            this.encodePalette(palette);
        } else {
            this.nextFrame(1);
        }
        if (this.startChunk(15)) {
            int line = 0;
            while (line < this.height) {
                int lofs = line * this.width;
                int pos = 0;
                int rawBytes = 0;
                this.writeByte(0);
                while (pos < this.width) {
                    byte b = frame[lofs + pos++];
                    if (pos + 2 < this.width && b == frame[lofs + pos] && b == frame[lofs + pos + 1]) {
                        int count;
                        while (rawBytes > 0) {
                            count = rawBytes > 127 ? 127 : rawBytes;
                            this.writeByte(-count);
                            while (count-- > 0) {
                                this.writeByte(pos - rawBytes-- - 1);
                            }
                        }
                        count = 3;
                        pos += 2;
                        while (pos < this.width && count < 127 && frame[lofs + pos] == b) {
                            ++count;
                            ++pos;
                        }
                        this.writeByte(count);
                        this.writeByte(b);
                        continue;
                    }
                    ++rawBytes;
                }
                while (rawBytes > 0) {
                    int count = rawBytes > 127 ? 127 : rawBytes;
                    this.writeByte(-count);
                    while (count-- > 0) {
                        this.writeByte(pos - rawBytes--);
                    }
                }
                ++line;
            }
            this.endChunk();
        }
        this.finishChunks();
    }

    public int verifyIdentity(byte[] frame) {
        int black = 0;
        int copy = 0;
        int i = 0;
        while (i < this.area) {
            byte b1 = this.frameBuffer[i];
            byte b2 = frame[i];
            if ((black |= b2) != 0 && (copy |= b1 ^ b2) != 0) {
                return 1;
            }
            ++i;
        }
        if (black == 0) {
            return 0;
        }
        if (copy == 0) {
            return -1;
        }
        return 1;
    }

    @Override
    public void close() {
        if (this.disabled) {
            return;
        }
        try {
            this.header.patchSize = this.byteCounter = (int)this.flic.getFilePointer();
            this.header.patchFrames = this.frameCounter;
            this.flic.seek(0L);
            this.writeHeader(true);
        }
        catch (IOException e) {
            this.disabled = true;
            return;
        }
        try {
            this.flic.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.disabled = true;
    }
}

