/*
 * Decompiled with CFR 0.152.
 */
package bk2010.hardware.cpu;

import bk2010.hardware.bus.QBusProxy;
import bk2010.hardware.bus.QBusReadDTO;
import bk2010.hardware.cpu.K1801VM1;

public final class Disasm {
    protected static final String[] asmTpl = new String[]{"Unknown", "???", "Dummy", "HALT", "WAIT", "RTI", "BPT", "IOT", "RESET", "RTT", "START", "S(TEP)", "JMP $d", "RTS $r", "SE$c", "CL$c", "SWAB $d", "BR $b", "BNE $b", "BEQ $b", "BGE $b", "BLT $b", "BGT $b", "BLE $b", "JSR $e,$d", "CLR $d", "COM $d", "INC $d", "DEC $d", "NEG $d", "ADC $d", "SBC $d", "TST $d", "ROR $d", "ROL $d", "ASR $d", "ASL $d", "MARK $m", "SXT $d", "MOV $s,$d", "CMP $s,$d", "BIT $s,$d", "BIC $s,$d", "BIS $s,$d", "ADD $s,$d", "XOR $e,$d", "SOB $e,$o", "BPL $b", "BMI $b", "BHI $b", "BLOS $b", "BVC $b", "BVS $b", "BCC $b", "BCS $b", "EMT $t", "TRAP $t", "CLRB $d", "COMB $d", "INCB $d", "DECB $d", "NEGB $d", "ADCB $d", "SBCB $d", "TSTB $d", "RORB $d", "ROLB $d", "ASRB $d", "ASLB $d", "MTPS $d", "MFPS $d", "MOVB $s,$d", "CMPB $s,$d", "BITB $s,$d", "BICB $s,$d", "BISB $s,$d", "SUB $s,$d"};
    protected static final String[] regNames = new String[]{"R0", "R1", "R2", "R3", "R4", "R5", "SP", "PC"};
    public static final String koi8 = "\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7 !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u25a0\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u00b7\u044e\u0430\u0431\u0446\u0434\u0435\u0444\u0433\u0445\u0438\u0439\u043a\u043b\u043c\u043d\u043e\u043f\u044f\u0440\u0441\u0442\u0443\u0436\u0432\u044c\u044b\u0437\u0448\u044d\u0449\u0447\u044a\u042e\u0410\u0411\u0426\u0414\u0415\u0424\u0413\u0425\u0418\u0419\u041a\u041b\u041c\u041d\u041e\u041f\u042f\u0420\u0421\u0422\u0423\u0416\u0412\u042c\u042b\u0428\u042d\u0429\u0427\u042a?";

    public static final String getRegName(int index) {
        return regNames[index];
    }

    private static void printOctal(int val, StringBuilder sb) {
        int i = 15;
        while (i >= 0) {
            sb.append((char)(((val & 0xFFFF) >> i & 7) + 48));
            i -= 3;
        }
    }

    private static void printSignedOctal(int val, StringBuilder sb) {
        if (val < 0) {
            sb.append('-');
            val = -val;
        }
        int i = 15;
        while (i >= 0) {
            sb.append((char)(((val & 0xFFFF) >> i & 7) + 48));
            i -= 3;
        }
    }

    public static final String disasm(QBusProxy mem, short addr, boolean full) {
        int insn;
        StringBuilder sb = new StringBuilder(30);
        StringBuilder comment = new StringBuilder(30);
        int immWordsNum = 0;
        int[] immWords = new int[2];
        if (full) {
            Disasm.printOctal(addr, sb);
            sb.append(": ");
        }
        if ((insn = mem.peekWord(addr)) < 0) {
            sb.append("--- Unreadable memory location ---");
            return sb.toString();
        }
        if (full) {
            Disasm.printOctal(insn, sb);
            sb.append("  ");
        }
        int op = K1801VM1.opdec[insn & 0xFFFF];
        int i = 0;
        while (i < asmTpl[op].length()) {
            char c = asmTpl[op].charAt(i);
            if (c != '$') {
                sb.append(c);
            } else {
                c = asmTpl[op].charAt(++i);
                switch (c) {
                    case 'd': 
                    case 's': {
                        String right;
                        String left;
                        short imm;
                        int mode = (c == 's' ? insn >> 6 : insn) & 0x3F;
                        if ((mode & 8) != 0) {
                            sb.append('@');
                            mode &= 0xFFFFFFF7;
                        }
                        if (mode == 23 || mode == 55) {
                            int read;
                            if (mode == 23) {
                                sb.append('#');
                            }
                            if ((read = (immWords[immWordsNum++] = mem.peekWord(addr + immWordsNum * 2))) < 0) {
                                sb.append("(Immediate operand unreadable)");
                                break;
                            }
                            int n = read;
                            immWords[immWordsNum - 1] = n;
                            imm = (short)n;
                            if (mode == 55) {
                                imm = (short)(imm + (addr + immWordsNum * 2 + 2));
                            }
                            Disasm.printOctal(imm, sb);
                            break;
                        }
                        switch (mode & 0x38) {
                            case 16: {
                                left = "(";
                                right = ")+";
                                break;
                            }
                            case 32: {
                                left = "-(";
                                right = ")";
                                break;
                            }
                            case 48: {
                                left = "(";
                                right = ")";
                                int n = immWordsNum++;
                                int n2 = mem.peekWord(addr + immWordsNum * 2);
                                immWords[n] = n2;
                                int read = n2;
                                if (read < 0) {
                                    sb.append("(Immediate operand unreadable)");
                                    break;
                                }
                                imm = (short)read;
                                Disasm.printOctal(imm, sb);
                                break;
                            }
                            default: {
                                left = "";
                                right = "";
                            }
                        }
                        sb.append(left);
                        sb.append(regNames[mode & 7]);
                        sb.append(right);
                        break;
                    }
                    case 'r': {
                        sb.append(regNames[insn & 7]);
                        break;
                    }
                    case 'c': {
                        if ((insn & 0xF) == 0) {
                            sb.replace(sb.length() - 2, sb.length(), "NOP");
                            break;
                        }
                        if ((insn & 8) != 0) {
                            sb.append('N');
                        }
                        if ((insn & 4) != 0) {
                            sb.append('Z');
                        }
                        if ((insn & 2) != 0) {
                            sb.append('V');
                        }
                        if ((insn & 1) == 0) break;
                        sb.append('C');
                        break;
                    }
                    case 'b': {
                        Disasm.printOctal(addr + 2 + (byte)insn * 2, sb);
                        comment.append('(');
                        Disasm.printSignedOctal((byte)insn * 2, comment);
                        comment.append(')');
                        break;
                    }
                    case 'o': {
                        Disasm.printOctal(addr + 2 - (insn & 0x3F) * 2, sb);
                        comment.append('(');
                        Disasm.printSignedOctal(-(insn & 0x3F) * 2, comment);
                        comment.append(')');
                        break;
                    }
                    case 'e': {
                        sb.append(regNames[insn >> 6 & 7]);
                        break;
                    }
                    case 'm': {
                        Disasm.printOctal(insn & 0x3F, sb);
                        break;
                    }
                    case 't': {
                        Disasm.printOctal(insn & 0xFF, sb);
                        break;
                    }
                    default: {
                        sb.append("(Unknown operand class '");
                        sb.append(c);
                        sb.append("' )");
                    }
                }
            }
            ++i;
        }
        if (comment.length() > 0) {
            sb.append(" ; ").append((CharSequence)comment);
        }
        if (full) {
            sb.append('\n');
            i = 0;
            while (i < immWordsNum) {
                Disasm.printOctal(addr + i * 2 + 2, sb);
                sb.append(": ");
                Disasm.printOctal(immWords[i], sb);
                sb.append('\n');
                ++i;
            }
        }
        return sb.toString();
    }

    public static final InsnClass classify(QBusProxy mem, short addr, QBusReadDTO target) {
        int insn = mem.peekWord(addr & 0xFFFF);
        if (insn < 0) {
            return InsnClass.INVALID;
        }
        int op = K1801VM1.opdec[insn & 0xFFFF];
        if (op <= 3) {
            return InsnClass.INVALID;
        }
        switch (op) {
            case 12: {
                if (insn == 95) {
                    target.value = (short)mem.peekWord(addr + 2);
                    return InsnClass.DIRECTJUMP;
                }
                if (insn == 119) {
                    target.value = (short)(mem.peekWord(addr + 2) + addr + 4);
                    return InsnClass.DIRECTJUMP;
                }
                return InsnClass.INDIRECTJUMP;
            }
            case 24: {
                if ((insn & 0x3F) == 31) {
                    target.value = (short)mem.peekWord(addr + 2);
                    return InsnClass.DIRECTCALL;
                }
                if ((insn & 0x3F) == 55) {
                    target.value = (short)(mem.peekWord(addr + 2) + addr + 4);
                    return InsnClass.DIRECTCALL;
                }
                return InsnClass.INDIRECTCALL;
            }
            case 5: 
            case 9: 
            case 13: {
                return InsnClass.RETURN;
            }
            case 17: {
                target.value = (short)(addr + 2 + (byte)insn * 2);
                return InsnClass.DIRECTJUMP;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                target.value = (short)(addr + 2 + (byte)insn * 2);
                return InsnClass.BRANCH;
            }
            case 46: {
                target.value = (short)(addr + 2 - (insn & 0x3F) * 2);
                return InsnClass.BRANCH;
            }
        }
        return InsnClass.SIMPLE;
    }

    public static final int length(QBusProxy mem, short addr) {
        int insn = mem.peekWord(addr);
        if (insn < 0) {
            return 0;
        }
        int op = K1801VM1.opdec[insn & 0xFFFF];
        if (op < 3) {
            return 0;
        }
        int len = 1;
        int i = 0;
        while (i < asmTpl[op].length()) {
            char c = asmTpl[op].charAt(i);
            if (c == '$') {
                c = asmTpl[op].charAt(++i);
                switch (c) {
                    case 'd': 
                    case 's': {
                        int mode = (c == 's' ? insn >> 6 : insn) & 0x3F;
                        if (mode == 23 || mode == 31) {
                            ++len;
                            break;
                        }
                        if ((mode &= 0x38) != 48 && mode != 56) break;
                        ++len;
                    }
                }
            }
            ++i;
        }
        return len;
    }

    private Disasm() {
    }

    public static enum InsnClass {
        INVALID,
        SIMPLE,
        BRANCH,
        DIRECTJUMP,
        INDIRECTJUMP,
        DIRECTCALL,
        INDIRECTCALL,
        RETURN;

    }
}

