/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.dialogs;

import bk2010.gui.helpers.FileExtensionFilter;
import bk2010.gui.helpers.OnOffBox;
import bk2010.gui.helpers.SlickTextField;
import bk2010.preferences.PathStrings;
import bk2010.preferences.types.Tape;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class TapeMountPanel
extends JPanel {
    Tape tapeSettings;
    OnOffBox cbMount;
    OnOffBox cbMotor;
    SlickTextField jtfFileName;
    JFileChooser fileChooser;

    private void showSelectImageDialog() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(PathStrings.tapeImagesPath);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
            this.fileChooser.setFileFilter(new FileExtensionFilter(new File(PathStrings.tapeImagesPath), ".wav", "BK2010 Tape File"));
        }
        if (this.tapeSettings.tapeFile != null) {
            this.fileChooser.setSelectedFile(this.tapeSettings.tapeFile);
        }
        if (this.fileChooser.showOpenDialog(this) == 0) {
            this.tapeSettings.tapeFile = this.fileChooser.getSelectedFile();
            this.cbMount.setSelected(true);
        }
        if (this.tapeSettings.tapeFile != null) {
            this.jtfFileName.setText(this.tapeSettings.tapeFile.getPath());
        }
    }

    public TapeMountPanel(Tape tapeSettings) {
        this.tapeSettings = tapeSettings;
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), tapeSettings.isOutput ? "Tape output" : "Tape input"));
        this.setLayout(new BoxLayout(this, 1));
        Box box = Box.createHorizontalBox();
        this.cbMount = new OnOffBox(tapeSettings.useTape);
        box.add(this.cbMount);
        this.cbMotor = new OnOffBox(tapeSettings.motorControl);
        box.add(this.cbMotor);
        this.cbMotor.setSelected(false);
        this.cbMotor.setEnabled(false);
        box.add(Box.createHorizontalGlue());
        this.add(box);
        box = Box.createHorizontalBox();
        this.jtfFileName = new SlickTextField(tapeSettings.tapeFile == null ? "" : tapeSettings.tapeFile.getAbsolutePath(), PathStrings.tapeImagesPath.length() + 32);
        this.jtfFileName.setEditable(false);
        box.add(this.jtfFileName);
        box.add(Box.createRigidArea(new Dimension(10, 1)));
        JButton jbBrowse = new JButton("Browse");
        jbBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TapeMountPanel.this.showSelectImageDialog();
            }
        });
        box.add(jbBrowse);
        this.add(box);
    }
}

