/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui20;

import bk2010.gui.debugger.ui20.LineListModel;
import bk2010.gui.helpers.Tools;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class LineListView
extends JComponent {
    private static final long serialVersionUID = 4601997466733459172L;
    protected LineListModel model;
    protected boolean fixedWidth;
    protected int lineHeight;
    protected int preferredWidth;
    protected int borderWidth = 2;

    public LineListView(LineListModel listModel, boolean fixedWidth) {
        this.setFont(Tools.monoFont);
        this.setFocusable(false);
        this.model = listModel;
        this.fixedWidth = fixedWidth;
        this.lineHeight = Tools.fontHeight;
        this.preferredWidth = this.model.getExpectedWidth() * Tools.fontWidth;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth, this.lineHeight * this.model.size());
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(this.preferredWidth, this.lineHeight * 999);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.preferredWidth, this.lineHeight);
    }

    @Override
    protected void paintComponent(Graphics g1) {
        int yPos = Tools.fontBase;
        int yStep = Tools.fontHeight;
        Graphics2D g = (Graphics2D)g1.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(this.getFont());
        int visibleLines = this.model.size();
        visibleLines = Math.min(visibleLines, (this.getHeight() - 2 * this.borderWidth) / this.lineHeight);
        int i = 0;
        while (i < visibleLines) {
            String str = this.model.get(i);
            if (str.isEmpty()) {
                yPos += yStep;
            } else {
                g.drawString(str, this.borderWidth, this.borderWidth + yPos);
                yPos += yStep;
            }
            ++i;
        }
    }
}

