/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LabelsModel {
    ArrayList<LabelRecord> records = new ArrayList(100);
    static Pattern mapRecordPattern = Pattern.compile("^\\s*(([0-9a-zA-Z$_]+)\\s*=\\s*([0-7]+))|(([0-7]+)\\s*([0-9a-zA-Z$_]+))");

    boolean readFromFile(String fileName) {
        List<String> lines;
        try {
            lines = Files.readAllLines(FileSystems.getDefault().getPath(fileName, new String[0]));
        }
        catch (IOException e) {
            return false;
        }
        this.records.clear();
        for (String str : lines) {
            int addr;
            String addrStr;
            String label;
            Matcher matcher = mapRecordPattern.matcher(str);
            if (!matcher.matches()) continue;
            if (matcher.group(1) != null) {
                label = matcher.group(2);
                addrStr = matcher.group(3);
            } else {
                if (matcher.group(4) == null) continue;
                addrStr = matcher.group(5);
                label = matcher.group(6);
            }
            try {
                addr = Integer.parseInt(addrStr, 8);
            }
            catch (NumberFormatException ex) {
                continue;
            }
            this.records.add(new LabelRecord(label, addr));
        }
        this.records.trimToSize();
        this.records.sort(null);
        return true;
    }

    public int size() {
        return this.records.size();
    }

    public static final class LabelRecord
    implements Comparable<LabelRecord> {
        public final String name;
        public final int address;

        public LabelRecord(String name, int address) {
            this.name = name;
            this.address = address;
        }

        @Override
        public int compareTo(LabelRecord o) {
            return this.address - o.address;
        }
    }
}

