/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui.debugger.ui15;

import bk2010.DebuggerState;
import bk2010.gui.debugger.ui15.AddressCallback;
import bk2010.gui.debugger.ui15.AddressDialog;
import bk2010.gui.debugger.ui15.DisasmModel;
import bk2010.gui.debugger.ui15.DisasmView;
import bk2010.hardware.BaseBK001x;
import bk2010.hardware.DBTrapSource;
import bk2010.hardware.TimeSource;
import bk2010.io.Mouse;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class DisasmPanel
extends JPanel
implements AddressCallback {
    static final long serialVersionUID = -6722239728030900345L;
    DisasmModel disasmModel;
    DisasmView disasmView;
    Border disasmBorder;
    DebuggerState dbgState;
    AddressDialog addrDialog;
    Action actRun;
    Action actStep;
    Action actAddr;

    public DisasmPanel(DisasmModel disasmModel, DebuggerState dbgState) {
        super(new BorderLayout());
        this.dbgState = dbgState;
        this.disasmModel = disasmModel;
        this.disasmView = new DisasmView(disasmModel);
        JScrollPane disasmScroll = new JScrollPane(this.disasmView, 22, 31);
        disasmScroll.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add(disasmScroll);
        this.addKeyboardControls();
        this.setFocusable(true);
    }

    void addKeyboardControls() {
        InputMap imap = this.getInputMap(2);
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke(71, 0), "run");
        imap.put(KeyStroke.getKeyStroke(32, 0), "step");
        imap.put(KeyStroke.getKeyStroke(65, 0), "addr");
        this.actRun = new AbstractAction("Run"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DisasmPanel.this.dbgState.get() == 2) {
                    DisasmPanel.this.dbgState.set(0);
                }
            }
        };
        amap.put("run", this.actRun);
        this.actStep = new AbstractAction("Step"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DisasmPanel.this.dbgState.get() == 2) {
                    DisasmPanel.this.dbgState.set(3);
                }
            }
        };
        amap.put("step", this.actStep);
        final DisasmPanel self = this;
        this.actAddr = new AbstractAction("Addr"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DisasmPanel.this.dbgState.get() == 2) {
                    if (DisasmPanel.this.addrDialog == null) {
                        DisasmPanel.this.addrDialog = new AddressDialog(self);
                    }
                    DisasmPanel.this.addrDialog.clearInput();
                    DisasmPanel.this.addrDialog.setVisible(true);
                }
            }
        };
        amap.put("addr", this.actAddr);
    }

    @Override
    public void selectAddress(int addr) {
        this.disasmView.setMarkedAddr(addr);
        this.disasmView.ensureVisible(addr);
    }

    public void ensureVisible(int addr) {
        this.disasmView.ensureVisible(addr);
    }

    public void setTrapSource(DBTrapSource source) {
        this.disasmView.setTrapSource(source);
    }

    public void setPC(int addr) {
        this.disasmModel.setPC(addr);
        this.disasmView.setMarkedAddr(addr);
        this.disasmView.ensureVisible(addr);
    }

    public void purge() {
        this.disasmModel.purge();
    }

    public void purgeWord(short addr) {
        this.disasmModel.purgeWord(addr);
    }

    public static void main(String[] args) throws IOException {
        JFrame fr = new JFrame("Disasm15 test");
        fr.setDefaultCloseOperation(3);
        BaseBK001x machine = new BaseBK001x(new Mouse(), false);
        TimeSource stillTime = new TimeSource(){

            @Override
            public long getCycles() {
                return 0L;
            }
        };
        machine.setTimeSource(stillTime, 1000000);
        machine.timer.setTimeSource(stillTime);
        fr.add(new DisasmPanel(new DisasmModel(machine), null));
        fr.pack();
        fr.setVisible(true);
    }
}

