/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.BK2010Display;
import bk2010.io.Mouse;
import bk2010.util.BootLog;
import bk2010.util.Log;
import java.awt.AWTException;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;

public class MouseHandler
extends MouseAdapter {
    protected BK2010Display host;
    protected Robot mouseRobot;
    protected Mouse mouse;
    protected boolean grabAllowed = true;
    protected boolean grabbed;
    protected int buttonBits;
    protected int oldMouseX;
    protected int oldMouseY;

    public MouseHandler(BK2010Display host, Mouse mouse) {
        this.host = host;
        this.mouse = mouse;
        try {
            this.mouseRobot = new Robot();
            BootLog.l("Mouse enabled");
        }
        catch (AWTException e) {
            Log.warning("No OS support for mouse input grabbing in windowed mode");
            BootLog.l("Mouse disabled");
            this.grabAllowed = false;
        }
    }

    protected void centerOnHost() {
        Point hl = this.host.getLocationOnScreen();
        int mx = hl.x + this.host.getWidth() / 2;
        int my = hl.y + this.host.getHeight() / 2;
        this.mouseRobot.mouseMove(mx, my);
        this.oldMouseX = mx;
        this.oldMouseY = my;
    }

    protected void processMoveTo(int x, int y) {
        int dx = x - this.oldMouseX;
        int dy = y - this.oldMouseY;
        if ((x | y) == 0) {
            return;
        }
        this.centerOnHost();
        this.mouse.processMove(dx, dy);
    }

    protected void updateButtons(MouseEvent e) {
        int mods = e.getModifiersEx();
        int bits = 0;
        if ((mods & 0x400) != 0) {
            bits |= 1;
        }
        if ((mods & 0x800) != 0) {
            bits |= 2;
        }
        if ((mods & 0x1000) != 0) {
            bits |= 4;
        }
        if (this.buttonBits != bits) {
            this.buttonBits = bits;
            this.mouse.updateButtons(bits);
        }
    }

    public boolean grabMouse(boolean enable) {
        if (!this.grabAllowed) {
            return false;
        }
        boolean oldState = this.grabbed;
        this.grabbed = enable;
        if (enable != oldState) {
            Log.verbose(enable ? "Mouse grabbed" : "Mouse released");
            if (enable) {
                this.centerOnHost();
            }
            this.host.notifyMouseGrabToggle(enable);
        } else {
            Log.verbose("Mouse is already " + (this.grabbed ? "grabbed" : "released"));
        }
        return oldState;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.grabAllowed && !this.grabbed) {
            this.grabMouse(true);
        } else if (this.grabbed && e.isControlDown()) {
            this.grabMouse(false);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Log.verbose("Mouse dragged %d, %d\n", e.getX(), e.getY());
        e.consume();
        if (this.grabbed) {
            this.processMoveTo(e.getXOnScreen(), e.getYOnScreen());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.grabAllowed) {
            this.host.requestFocusInWindow();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.grabMouse(false);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Log.verbose("Mouse moved %d, %d\n", e.getX(), e.getY());
        e.consume();
        if (this.grabbed) {
            this.processMoveTo(e.getXOnScreen(), e.getYOnScreen());
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateButtons(e);
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateButtons(e);
        e.consume();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouse.updateWheel(e.getWheelRotation());
        e.consume();
    }
}

