/*
 * Decompiled with CFR 0.152.
 */
package bk2010.gui;

import bk2010.gui.BK2010Display;
import bk2010.gui.MouseHandler;
import bk2010.io.KeyMapper;
import bk2010.io.Mouse;
import bk2010.util.BootLog;
import bk2010.util.LogBuffer;
import bk2010.util.LogObserver;
import bk2010.util.ResourceManager;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class BK2010WindowedDisplay
extends BK2010Display {
    private MouseHandler mouseHandler;
    protected SimpleFrame frame;
    protected BK2010View view;

    public BK2010WindowedDisplay(KeyMapper keyMapper, Mouse mouse, int width, int height, String machineName) {
        this.scrWidth = this.viewWidth = width;
        this.scrHeight = this.viewHeight = height;
        this.interpolate = width % 512 != 0 || height % 256 != 0;
        this.keyMapper = keyMapper;
        this.mouse = mouse;
        this.mouseHandler = new MouseHandler(this, mouse);
        this.view = new BK2010View(keyMapper, this.mouseHandler, width, height, this);
        this.frame = new SimpleFrame(this.view);
        this.frame.setDefaultCloseOperation(3);
        Dimension winsize = this.frame.getSize();
        Dimension scrsize = this.frame.getToolkit().getScreenSize();
        this.frame.setLocation((scrsize.width - winsize.width) / 2, (scrsize.height - winsize.height) / 2);
        this.frame.setTitle(machineName);
        this.frame.setIconImage(ResourceManager.getEmulatorIcon());
        this.frame.setVisible(true);
        this.frame.toFront();
    }

    public void forceUpdate() {
        this.view.paintImmediately(0, 0, this.scrWidth, this.scrHeight);
    }

    @Override
    public Point getLocationOnScreen() {
        return this.view.getLocationOnScreen();
    }

    @Override
    public int getWidth() {
        return this.scrWidth;
    }

    @Override
    public int getHeight() {
        return this.scrHeight;
    }

    @Override
    public void notifyMouseGrabToggle(boolean enable) {
        this.view.notifyMouseGrabToggle(enable);
    }

    @Override
    public void requestFocusInWindow() {
        this.view.requestFocusInWindow();
    }

    @Override
    public void requestFocus() {
        this.view.requestFocus();
        this.frame.toFront();
    }

    @Override
    public void repaint() {
        this.view.repaint(0L);
    }

    @Override
    protected void paintMe(Graphics g1) {
        super.paintMe(g1);
        this.view.getToolkit().sync();
    }

    static class BK2010View
    extends JPanel {
        BK2010WindowedDisplay host;
        int viewWidth;
        int viewHeight;

        public BK2010View(final KeyMapper keyMapper, final MouseHandler mouseHandler, int width, int height, BK2010WindowedDisplay host) {
            this.viewWidth = width;
            this.viewHeight = height;
            this.host = host;
            Dimension sz = new Dimension(width, height);
            this.setMaximumSize(sz);
            this.setMinimumSize(sz);
            this.setPreferredSize(sz);
            this.setFocusable(true);
            this.setFocusTraversalKeysEnabled(false);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    keyMapper.keyHit(e);
                    e.consume();
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    keyMapper.keyRelease(e);
                    e.consume();
                }

                @Override
                public void keyTyped(KeyEvent e) {
                    e.consume();
                }
            });
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
            this.addMouseWheelListener(mouseHandler);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    mouseHandler.grabMouse(false);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            BootLog.getHistory().addObserver(new LogObserver(){

                @Override
                public void logUpdateNotification(LogBuffer buffer, String message) {
                    this.paintImmediately(0, 0, viewWidth, viewHeight);
                }
            });
        }

        @Override
        protected void paintComponent(Graphics g1) {
            this.host.paintMe(g1);
        }

        public void notifyMouseGrabToggle(boolean enabled) {
            if (enabled) {
                this.setCursor(emptyCursor);
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public static class SimpleFrame
    extends JFrame {
        public SimpleFrame(BK2010View panel) {
            this.rootPane.setDoubleBuffered(false);
            this.add(panel);
            this.pack();
            this.setResizable(false);
        }
    }
}

