BITMAP ENABLE (144,96,4)

start_the_game:
	CLS
	COLOR BORDER BLACK
	
	REM dice assets
	die1 = LOAD IMAGE("images/die-1.png")
	die2 = LOAD IMAGE("images/die-2.png")
	die3 = LOAD IMAGE("images/die-3.png")
	die4 = LOAD IMAGE("images/die-4.png")
	die5 = LOAD IMAGE("images/die-5.png")
	die6 = LOAD IMAGE("images/die-6.png")
	
	REM squares on board
	home = LOAD IMAGE("images/home.png")
	basic = LOAD IMAGE("images/basic.png")
	event = LOAD IMAGE("images/event.png")
	
	REM player pawns
	p1_pawn = LOAD IMAGE("images/P1_0.png")
	p2_pawn = LOAD IMAGE("images/P2_0.png")
	p3_pawn = LOAD IMAGE("images/P3_0.png")
	p4_pawn = LOAD IMAGE("images/P4_0.png")
	
	REM robot parts
	robot_sad = LOAD IMAGE("images/Robo_Sad_0.png")  BANKED
	robot_happy = LOAD IMAGE("images/Robo_Happy_0.png")  BANKED
	robot_body = LOAD IMAGE("images/Robo_Body_0.png")  BANKED
	robot_heart = LOAD IMAGE("images/Robo_Heart_1.png")  BANKED
	
	
	REM face1 = LOAD IMAGE("images/face1_1.png") BANKED
	REM face2 = LOAD IMAGE("images/face2_1.png") BANKED
		
	REM *** The first screen ***
	INK 12
	PRINT
	PRINT
	CENTRE "IS SAD"
	CENTRE " "
	CENTRE "BE THE FIRST"
	CENTRE "TO RETURN HER"
	CENTRE "MISSING HEART"
	REM put the robot on title
	PUT IMAGE robot_sad AT 40,8
	PUT IMAGE robot_body AT 40,16
	
	REM all the players are presented at the bottom
	PUT IMAGE p1_pawn AT 48,64
	PUT IMAGE p2_pawn AT 64,64
	PUT IMAGE p3_pawn AT 80,64
	PUT IMAGE p4_pawn AT 96,64
	WAIT KEY
	
	CLS
	
	REM                   1   2   3   4   5   6   7   8   9  10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25
	DIM boardx(25) = # {  0, 16, 32, 48, 64, 80, 96,112,128,128,128,128,128,128,112, 96, 80, 64, 48, 32, 16,  0,  0,  0,  0}
	DIM boardy(25) = # {  0,  0,  0,  0,  0,  0,  0,  0,  0, 16, 32, 48, 64, 80, 80, 80, 80, 80, 80, 80, 80, 80, 64, 48, 32}
	REM squares with events
	DIM events(5) = # { 4, 8, 13, 17, 21 }
	REM this does not fully work
	DIM pcolors(5) = # { BLACK, RED, GREEN, BLUE, WHITE }
	
	REM Player positions. Everyone starts at square one.
	p1c = 0
	p2c = 0
	p3c = 0
	p4c = 0
	
	player_turn = 1

draw_screen:
	REM dice position
	cy = 40
	cx = 64
	
	REM draw the board
	idx = 0
	REPEAT
		PUT IMAGE basic AT boardx(idx),boardy(idx)
		INC idx
	UNTIL idx = 24

	REM draw home cell
	PUT IMAGE home AT boardx(0),boardy(0)
	
	REM draw the robot at the finish
	PUT IMAGE robot_sad AT boardx(idx)+4,boardy(idx)
	PUT IMAGE robot_body AT boardx(idx)+4,boardy(idx)+8
	
	REM put the event squares at their places defined in event array
	idx = 0
	REPEAT
		PUT IMAGE event AT boardx(events(idx)),boardy(events(idx))
		INC idx
	UNTIL idx = 5	
	
	REM put pawns at the home square
	PUT IMAGE p1_pawn AT boardx(p1c), boardy(p1c)
	PUT IMAGE p2_pawn AT boardx(p2c) + 8, boardy(p2c)
	PUT IMAGE p3_pawn AT boardx(p3c), boardy(p3c) + 8
	PUT IMAGE p4_pawn AT boardx(p4c) + 8, boardy(p4c) + 8
	
	REM Show whose turn it is
	INK pcolors(player_turn)
	LOCATE 5, 3
	PRINT "PLAYER"
	IF player_turn == 1 THEN
		PUT IMAGE p1_pawn AT 96, 24
	ELSE IF player_turn == 2 THEN
		PUT IMAGE p2_pawn AT 96, 24
	ELSE IF player_turn == 3 THEN
		PUT IMAGE p3_pawn AT 96, 24
	ELSE 
		PUT IMAGE p4_pawn AT 96, 24
	ENDIF
					
	WAIT KEY
	RANDOMIZE TIMER

throw_dice:
	c = 0
	diceloop = 0
	REM draw animated die at the center of the screen
	DO
		c = RND(6) + 1
		IF c == 1 THEN
			PUT IMAGE die1 AT cx,cy
		ELSE IF c == 2 THEN
			PUT IMAGE die2 AT cx,cy
		ELSE IF c == 3 THEN
			PUT IMAGE die3 AT cx,cy
		ELSE IF c == 4 THEN
			PUT IMAGE die4 AT cx,cy
		ELSE IF c == 5 THEN
			PUT IMAGE die5 AT cx,cy
		ELSE
			PUT IMAGE die6 AT cx,cy
		ENDIF
		INC diceloop
		IF diceloop > 10 THEN
			EXIT 1
		ENDIF
		SHOOT
		SOUND OFF
		WAIT 25 MILLISECOND
	LOOP
	
	REM a temporary variable to implement a rolling move
	moves = 0
	
	REM a variable for an event loop check
	idx2 = 0
	
	IF player_turn == 1 THEN	
		REM move the player according to die value
		REPEAT
			INC p1c
			INC moves
			WAIT 50 MILLISECOND
			PUT IMAGE p1_pawn AT boardx(p1c), boardy(p1c)
			IF p1c > 23 THEN				
				GOTO winning_screen
			ENDIF
		UNTIL moves = c		
		REM check if the player is in the event square
		REPEAT
			IF p1c == events(idx2) THEN
				SHOOT
				GOTO throw_dice
			ENDIF
			INC idx2
		UNTIL idx2 = 5
		
			
	ELSE IF player_turn == 2 THEN		
		REPEAT
			INC p2c
			INC moves
			WAIT 50 MILLISECOND
			PUT IMAGE p2_pawn AT boardx(p2c) + 8, boardy(p2c)
			IF p2c > 23 THEN				
				GOTO winning_screen
			ENDIF
		UNTIL moves = c
		REPEAT
			IF p2c == events(idx2) THEN
				SHOOT
				GOTO throw_dice
			ENDIF
			INC idx2
		UNTIL idx2 = 5
		
	ELSE IF player_turn == 3 THEN		
		REPEAT
			INC p3c
			INC moves
			WAIT 50 MILLISECOND
			PUT IMAGE p3_pawn AT boardx(p3c), boardy(p3c) + 8
			IF p3c > 23 THEN
				GOTO winning_screen
			ENDIF
		UNTIL moves = c
		REPEAT
			IF p3c == events(idx2) THEN
				SHOOT
				GOTO throw_dice
			ENDIF
			INC idx2
		UNTIL idx2 = 5
		
	ELSE
		REPEAT
			INC p4c
			INC moves
			WAIT 50 MILLISECOND
			PUT IMAGE p4_pawn AT boardx(p4c) + 8, boardy(p4c) + 8
			IF p4c > 23 THEN
				GOTO winning_screen
			ENDIF
		UNTIL moves = c
		REPEAT
			IF p4c == events(idx2) THEN
				SHOOT
				GOTO throw_dice
			ENDIF
			INC idx2
		UNTIL idx2 = 5
		
	ENDIF
			
	INC player_turn
	IF player_turn > 4 THEN
		player_turn = 1
	ENDIF
	
	
	REM GOTO draw_screen
	GOTO credit_screen

	
winning_screen:
	CLS
	PEN 200
	
	IF player_turn == 1 THEN
		PUT IMAGE p1_pawn AT 80, 24
		PUT IMAGE p2_pawn AT 56, 24
		PUT IMAGE p3_pawn AT 48, 24
		PUT IMAGE p4_pawn AT 40, 24
	ELSE IF player_turn == 2 THEN
		PUT IMAGE p2_pawn AT 80, 24
		PUT IMAGE p3_pawn AT 56, 24
		PUT IMAGE p4_pawn AT 48, 24
		PUT IMAGE p1_pawn AT 40, 24		
	ELSE IF player_turn == 3 THEN
		PUT IMAGE p3_pawn AT 80, 24
		PUT IMAGE p4_pawn AT 56, 24
		PUT IMAGE p1_pawn AT 48, 24
		PUT IMAGE p2_pawn AT 40, 24
	ELSE 
		PUT IMAGE p4_pawn AT 80, 24
		PUT IMAGE p1_pawn AT 56, 24
		PUT IMAGE p2_pawn AT 48, 24
		PUT IMAGE p3_pawn AT 40, 24
	ENDIF
	PUT IMAGE robot_happy AT 96, 16
	PUT IMAGE robot_heart AT 96, 24
	CENTER " "
	CENTER "ROBO IS HAPPY!"
	
	WAIT KEY
	
credit_screen:
	CLS
	PEN 12
	LOCATE 1,1
	REM put the robot on title
	PRINT
	CENTRE "IS SAD"
	CENTRE " "
	PRINT
	CENTRE "A GAME BY"
	CENTRE " "
	PRINT
	PRINT
	PRINT
	CENTRE "OSVA     NOONOO"
	PUT IMAGE robot_sad AT 40,8
	PUT IMAGE robot_body AT 40,16
	REM credit face

	REM PUT IMAGE face1 AT 24,56
	REM PUT IMAGE face2 AT 24,64
HALT





