// title:   force of continuance
// author:  taehtituho
// desc:    chimpbembly 2024
// version: 1.0
// script:  js

let t1000, t2000, t3000, t4000, t5000,
	t100, t200, t300, t400, t500, 
	t10, t20, t30, t40, t50, t, deltaT = 0;

const random = {
	seed: 1337,
	next: function() {
		const x = Math.sin(this.seed++) * 10000;
		return x - Math.floor(x);
	}
};

const tune = {
	tempo: 200,
	speed: 4
};

const tools = {
	lerp: function(a, b, c) {
		return a * (1 - c) + b * c;
	},
	lerp3: function(a, b, c) {
		return {
			x: a.x * (1 - c) + b.x * c,
			y: a.y * (1 - c) + b.y * c,
			z: a.z * (1 - c) + b.z * c
		}
	},
	mapTime: function(start1, stop1, start2, stop2) {
		const start1S = start1 * 1000;
		const stop1S = stop1 * 1000;
		if (t <= start1S)
			return start2;
		if (t >= stop1S)
			return stop2;
		return start2 + (stop2 - start2) * ((t - start1S) / (stop1S - start1S));
	},
	sin01: function(v) {
		return (Math.sin(v) + 1.0) / 2.0;
	},
	cos01: function(v) {
		return (Math.cos(v) + 1.0) / 2.0;
	},
	isTimeBefore: function(t1) {
		return t <= (t1 * 1000);
	},
	isTimeAfter: function(t1) {
		return t > (t1 * 1000);
	},
	isTimeBetween: function(t1, t2)  => {
		return this.isTimeBefore(t2) && this.isTimeAfter(t1); 
	},
	rampUp01: function(w, l) {
		const w1 = w * 1000.0;
		const l1 = l * 1000.0;
		const t1 = t - w1;
		if (t1 < 0) {
			return 0.0;
		}	
		return Math.min(1.0, (1.0 / l1) * t - (w1 / l1));
	},
	rampDown10: function(w, l) {
		const w1 = w * 1000.0;
		const l1 = l * 1000.0;
		const t1 = t - w1;
		if (t1 > 0) {
			return 0.0;
		}
		return Math.max(1.0, 1.0 - (1.0 / l1) * t + (w1 / l1));
	}
};

const SCREEN = {
	WIDTH: 240,
	HEIGHT: 136
};

const background = {
	height: 5,
	width: 4, 
	init: function() {
	},
	palette: function(pI) {
		return [0, 1, 2, 3, 4, 5, 6, 7][pI & this.PALETTE_LENGTH - 1]
	},
	PALETTE_LENGTH: 8,
	update: function() {
		if (!tools.isTimeBetween(5.5, 62.5)) {
			return;
		}
		const xStart = tools.mapTime(55.0, 57.5, 0, SCREEN.WIDTH);
		const yStart = SCREEN.HEIGHT - 
			tools.mapTime(13.0, 13.5, 0, SCREEN.HEIGHT);
				
		for (let x = xStart; x < SCREEN.WIDTH; x += this.width) {
			for (let y = yStart; y < SCREEN.HEIGHT; y += this.height) {
				const xOffset = (Math.sin(x * 0.01) + t5000) * 2.2;
				const yOffset = (Math.cos(y * 0.05) + t4000) * 0.1;
				const c1 = (tools.sin01(t1000 + x * 0.06) + xOffset);
				const c2 = (tools.cos01(-t500 + y * 0.02) + yOffset);
				const pI = ((t1000 + c1 + c2) * this.PALETTE_LENGTH);
				rect(x, y, this.width, this.height, this.palette(pI));
			}
		}
	}
};

const scroller = {
	texts: ["THIS T@HTITUHO TIC-80 PROD WAS RELEASED IN OCTOBER 2024 AT CHIMPBEMBLY.",
		"WE ARE SO ADVANCED THAT WE DIDN'T EVEN BOTHER WITH ORIGINAL COLOR PALETTE, SO ENJOY DEFAULT TIC-80 COLORS.",
		"FORCE OF CONTINUANCE IS IMMINENT, RESISTANCE IS USELESS.",
		"MAJANIEMI HERE, I FOUND SOME OLD MAGAZINES AND THERE WAS ASSEMBLY '97 REPORT: \"TURVALLISUUSHENKIL#KUNNAN TIUKAN ASIALLINEN LINJAUS ON PIT@NYT KOKO ASSEMBLYJEN AJAN - YKSIK@@N REPPU TAI KASSI EI P@@SE SIS@@N PARTYPAIKALLE ILMAN SIS@LL#N TARKISTUSTA. T@M@N SAI MY#S KOKEA EXOTIC MEN -RYHM@N EDDIE, JOKA YRITTI TAPANSA MUKAAN H@KELLYTT@@ PORTSAREITA ILMESTYM@LL@ OVISTA SIS@LLE VAILLA RIHMAN KIERT@M@@K@@N. TURVAMIEHET EIV@T KUITENKAAN J@@NEET SANATTOMIKSI VAAN ILMOITTIVAT VAIN TYYNESTI 'NO NIIN JA KASSIEN TARKASTUS'. EDDIE POISTUI SILMINN@KIJ#IDEN MUKAAN PAIKALTA HARVINAISEN RIPE@STI\" . SEE YOU AT ZOO SAUNA!",	
		"SPQ SANOO 'RASVA-PENA VED@ SE DEATH METAL P@@H@S'.",
		"PARKITUS SANOO 'MAKARONILAATIKKO ON VALMIS, TULKAA SY#M@@N'.",
		"MULLA ON 37.1 ASTETTA KUUMETTA EI PYSTY TULEEN ALTAASEEN, N@HD@@N LAUTEILLA. @LK@@ POLTTAKO ITTEENNE LOPPUUN. REGARDS RASVA-PENA",
		"WE ARE HERE TO DOMINATE COMPOS, PREPARE TO BE BEATEN INTO SUBMISSION.",
		"GREETS: EXOTIC MEN, GORBAT SOFT, ISO, WIDE LOAD AND ALL SCENERS EVERYWHERE!",
		"CODE: RASVA-PENA, HELGRIMA, MUSIC: HELGRIMA, GFX: RASVA-PENA, HELGRIMA",
		"ALL HAIL THE DEMOSCENE!",
		"(MUSIC LOOPS SO PRESS SPACE TO TERMINATE!)",
	],
	textIndex: 0,
	internalTime: 0,
	charSize: {
		w: 8,
		h: 8,
		s: 1
	},
	init: function() {
	},
	update: function() {
		const text = this.texts[this.textIndex];
		const cs = this.charSize;
		this.internalTime += (deltaT / 10.0);;
		let textX = 0;
		for (const i in text) {		
			textX = SCREEN.WIDTH + 
				(cs.w * cs.s * i) - this.internalTime;
			const textY = SCREEN.HEIGHT - 13 + 
				(Math.sin((textX + t500) / 30.0)) * 6.0;
			
			font(
				text[i],
				textX,
				textY,
				0,
				cs.w,
				cs.h,
				true,
				cs.s	
			);
		}
		if (textX < 0) {
			this.textIndex++;
			this.internalTime = 0;
		}
	}
};

const threeD = {
	tunnelObject: null,
	numberOfPoints: 150,
	morph: 1.0,
	camera: {
		x: 0,
		y: 0,
		z: 0,
		fov: 75,
		farZ: 1.5,
		nearZ: 0
	},
	addZ: 0,
	palettes: [[5, 6, 7], [3, 2, 1], [12, 11, 10]],
	size: 10,
	distance: function(vec1, vec2) {
		return Math.sqrt(Math.pow(vec1.x - vec2.x, 2) + Math.pow(vec1.y - vec2.y,  2) + Math.pow(vec1.z - vec2.z, 2)); 
	},
	project: function(point) {
		const camera = this.camera;

		const x0 = point.x + this.camera.x;
		const y0 = point.y + this.camera.y;
		const z0 = point.z + this.camera.z;
		
		const x2D = (camera.fov * x0 / z0) + SCREEN.WIDTH / 2;
		const y2D = (camera.fov * y0 / z0) + SCREEN.HEIGHT / 2;
		  
		return {
			x: x2D,
			y: y2D
		};
	},
	rotate: function(point, pivot, amount) {
		const x0 = point.x - pivot.x;
		const y0 = point.y - pivot.y;
		const z0 = point.z - pivot.z;
		
		const aXSin = Math.sin(amount.x);
		const aXCos = Math.cos(amount.x);
		const aYSin = Math.sin(amount.y);
		const aYCos = Math.cos(amount.y);
		const aZSin = Math.sin(amount.z);
		const aZCos = Math.cos(amount.z);
		
		const x1 = x0 * aZCos - y0 * aZSin;
		const y1 = x0 * aZSin + y0 * aZCos;
		const z1 = z0;
		
		const x2 = z1 * aYSin + x1 * aYCos;
		const y2 = y1;
		const z2 = z1 * aYCos - x1 * aYSin;
		
		const x3 = x2;
		const y3 = y2 * aXCos - z2 * aXSin;
		const z3 = y2 * aXSin + z2 * aXCos;
		
		return {
			x: x3,
			y: y3,
			z: z3
		};
	},
	translate: function(point, amount) {
		return {
			x: point.x + amount.x,
			y: point.y + amount.y,
			z: point.z + amount.z
		}
	},
	initTunnel: function() {
		const points = new Array();
		//Make sure numberOfPoints is diviable by tunnelLength
		//numberOfPoints = 300 and tunnelLength = 60 
		const tunnelLength = 60;
		const pointsInSegment = 16;
		const fullCirle = 2.0 * Math.PI;
		const angleInc = fullCirle / pointsInSegment;
		const scale = 0.2;
		for (let i = 0; i < tunnelLength; i++) {
			for (let j = 0; j < pointsInSegment; j++) {		
				const rX = Math.cos(j * angleInc) * scale;
				const rY = Math.sin(j * angleInc) * scale;
				const rZ = (i * -0.1);
				points.push({
					x: rX,
					y: rY,
					z: rZ
				});	
			}
		}
		return points;
	},
	init: function() {
		this.tunnelObject = this.initTunnel();
	},
	update: function() {
		if (tools.isTimeBetween(60.0, 105.0)) {
			this.updateStarTunnel();
		}
		if (tools.isTimeBetween(55.0, 72.0)) {
			this.updateCube(
				{x: 0, y: -0.5, z: -2},
				{x: 0, y: 0, z: 0},
				{x: t500, y: t500, z: t500}
			);
		} 
		else if (tools.isTimeAfter(105.0)) {
			this.updateCube(
				{x: 0, y: 0, z: -2 },
				{x: 0.85 * Math.sin(t300), y: 0.75 * Math.sin(t400), z: 0.2 * Math.sin(t4000)},
				{x: 0.25 * t200, y: 0.5 * t300, z: t500}
			);
		}
	},
	updateStarTunnel: function() {
		this.addZ += deltaT;

		for (const oPoint of this.tunnelObject) {
			let point = this.rotate(
				oPoint, 
				{x: Math.sin(t2000) * 0.07, y: Math.sin(t4000) * 0.05, z: 0.0}, 
				{x: 0.0, y: 0.0, z: t3000}
			);
			
			point = this.translate(
				point,
				{
					x: Math.cos(t300 + point.z * 3.5) * 0.125,
					y: Math.sin(t500 + point.z * 6.0) * 0.100,
					z: 8.41 - this.addZ / 5500.0
				}
			);
			
			if (point.z <= this.camera.nearZ) {
				continue;
			}
			const distanceToCamera = this.distance(point, this.camera);
			const size = (this.camera.farZ / distanceToCamera) * 0.5; 
			
			const colorIndex = Math.max(Math.round((point.z)), 0);
			const paletteIndex = 1;
			
			const color = this.palettes[paletteIndex][colorIndex];
			const point2D = this.project(point);
			circ(
				point2D.x, 
				point2D.y, 
				size,
				color
			); 
		}
	},
	drawFaces: function(vs) {
			const s = 16;
			for(const v of vs) {
				const v2D1 = this.project(v[0]);
				const v2D2 = this.project(v[1]);
				const v2D3 = this.project(v[2]);
				const v2D4 = this.project(v[3]);
					
				ttri(
					v2D1.x,
					v2D1.y,
					v2D2.x,
					v2D2.y,
					v2D3.x,
					v2D3.y,
					0, 0,
					s, s,
					0, s,
					0,
					15,
					-v[0].z, -v[1].z, -v[2].z);
						
				ttri(
					v2D1.x,
					v2D1.y,
					v2D4.x,
					v2D4.y,
					v2D2.x,
					v2D2.y,
					0, 0,
					s, 0,
					s, s,
					0,
					15,
					-v[0].z, -v[3].z, -v[1].z);
					
		}	
	},
	updateCube: function(offset, rotationP, rotation) {
		const l = 0.5;
		let v3D =[
			{	x: -l, y: -l,	z: +l	},//v1
			{ x: +l,	y: +l,	z: +l	},//v2
			{	x: -l,	y: +l,	z: +l	},//v3
			{	x: +l,	y: -l,	z: +l	},//v4
			{	x: -l,	y: -l,	z: -l	},//v5
			{	x: -l,	y: +l,	z: -l	},//v6
			{	x: +l,	y: -l,	z: -l	},//v7
			{ x: +l,	y: +l,	z: -l	},//v8
		];
		
		v3D = v3D.map(v => 
		{
			let point = this.rotate(
				v, 
				rotationP, 
				rotation			
			);
			
			point = this.translate(point, offset);
			 	
			return point;
		});
	
		const faces = [
			[v3D[4], v3D[3], v3D[6], v3D[0]], //bottom
			[v3D[5], v3D[1], v3D[7], v3D[2]], //top
			[v3D[5], v3D[0], v3D[2], v3D[4]], //left
			[v3D[1], v3D[6], v3D[7], v3D[3]], //right
			[v3D[4], v3D[7], v3D[5], v3D[6]], //back
			[v3D[0], v3D[1], v3D[2], v3D[3]]  //front
		];

		this.drawFaces(faces);
	}
};

const logo = {
	spriteIndex: 352,
	scale: 2,
	width: 12,
	height: 4, 
	x: 0, 
	y: -50,
	init: function() {
		this.x = Math.round(SCREEN.WIDTH / 2.0) - this.width * 8;	
	},
	update: function() {
		if (tools.isTimeBefore(32) && this.y <= 10) {
			this.y += 3.0;
		}
		else if (tools.isTimeAfter(72) && this.y >= -100) {
			this.y -= 0.8;
		}
		
		const center = SCREEN.WIDTH / 2;
		//8 is sprite width in pixels
		this.x = center - ((this.width * 8 * this.scale) / 2);
		
		spr(
			this.spriteIndex,
			this.x,
			this.y,
			0,
			this.scale,
			0,
			0,
			this.width,
			this.height
		);
	}
};

const alien = {
	spriteIndex: 480,
	scale: 2,
	width: 2,
	height: 2,
	x: 0,
	y: -50,
	angle: 0,
	speed: 0.05,
	startMotion: false,
	init: function () {
		this.x = Math.round(SCREEN.WIDTH / 2.0) - this.width * 8;
	},
	update: function () {
		const sine = Math.sin(t400);

		if (tools.isTimeAfter(72) && this.y < 50) {
			this.y += 0.5
		}
		
		if (this.y >= 50) {
			this.startMotion = true;
		}

		if (this.startMotion) {
			this.angle += this.speed;
			this.x = Math.round(SCREEN.WIDTH / 2.0) - this.width * 8 + 40 * Math.sin(this.angle);
			this.y = 50 - 20 * Math.sin(2 * this.angle);
		}

		spr(this.spriteIndex, this.x, this.y, 0, this.scale, 0, 0, this.width, this.height);
	},
};

const ufo = {
	spriteIndexUfo: 482,
	spriteIndexRay: 484,
	scale: 2,
	width: 2,
	height: 2,
	x: 0,
	y: 186,
	blinkRate: 24,
	blinkTimer: 0,
	isVisible: false,
	init: function () {
		this.x = Math.round(SCREEN.WIDTH / 2.0) - this.width * 8;
	},
	update: function () {
		const sine = Math.sin(t400);

		if (tools.isTimeAfter(72) && this.y >= 80) {
			this.y -= 0.5;
		}

		this.blinkTimer++;

		if (this.blinkTimer >= this.blinkRate) {
			this.isVisible = !this.isVisible; 
			this.blinkTimer = 0;
		}

		const center = SCREEN.WIDTH / 2;
		this.x = center - (this.width * 8 * this.scale) / 2;
		this.x += (sine * center) / 3.0;
		spr(this.spriteIndexUfo, this.x, this.y, 0, this.scale, 0, 0, this.width, this.height);

		if (this.isVisible) {
			spr(this.spriteIndexRay, this.x + 2, this.y + 8, 0, this.scale, 0, 0, this.width, this.height);
		}
	},
};

const columns = {
	height: SCREEN.HEIGHT,
	width: 100,
	radius: 0,
	offset: 0,
	rotation: 0,
	ratioPhase: 0.1,
	palette: [],
	init: function() {
		this.radius = this.width / 2.0;
		this.offset = this.radius;
		
		let inc = 8; //start of color index
		const colors = 5; //take 5 next color indicies
		const step = inc * colors;
		for (let i = 0; i < 5 * step; i++) {
		if (i % step == 0 && i !== 0)	{
			inc++;
		}
		this.palette.push(inc);
		}
	},
	update: function() {
		if (tools.isTimeBefore(105.0)) {
			return; 
		}
		let twist = 0.0;
		let twistRatio = Math.sin(this.ratioPhase) * 1.3;
		
		for (let y = 0; y < this.height; y++) {
			const offset = -10 - (Math.sin(t400 - (y / 70.0)) * 25.0);	
			this.drawSlice(y, this.rotation + twist, offset);
			twist += twistRatio;
			}
		twist = 0;
		for (let y = this.height; y >= 0; y--) {
			const offset = 10 + SCREEN.WIDTH - this.width - (Math.sin(t300 - (y / 60.0)) * 25.0);	
			this.drawSlice(y, this.rotation - twist, offset);
			twist += twistRatio;
		}
		
		this.rotation = t;
		this.ratioPhase += 0.003;
	},
	drawSlice: function(y, angle, offset) {
		const PI = Math.PI;
		const modAngle = (((angle % 512.0) + 768.0)) * PI / 1024.0;
		
		const leftX = Math.cos(modAngle) * this.radius;
		const midX = Math.cos(modAngle + PI / 2.0) * this.radius;
		const rightX = Math.cos(modAngle + PI) * this.radius;
	
		const light1 = Math.round(
			-Math.sin(modAngle + PI / 4.0) * 190 + 9);
		const light2 = Math.round(
			-Math.sin(modAngle + 3.0 * PI / 4.0) * 190 + 9);
	
		const seg1 = this.radius + leftX;
		const seg2 = midX - leftX;
		const seg3 = rightX - midX;
		const seg4 = this.radius - rightX;
	
		let x = offset;
		x += this.drawVerticalSlice(x, y, seg1, 0);
		x += this.drawVerticalSlice(x, y, seg2, this.palette[light1]);
		x += this.drawVerticalSlice(x, y, seg3, this.palette[light2]);
		x += this.drawVerticalSlice(x, y, seg4, 0);
	},
	drawVerticalSlice: function(x, y, width, color) {
		for (let x1 = 0; x1 < width; x1++) {
			pix(
				x + x1,
				y,
				color
			);
		}
		return width;
	}
};

const nuke = {
	palette: [15, 14, 13, 12],
	init: function() {
	},
	update: function() {
		if (tools.isTimeBetween(0, 0.2)) {
			const ramp = tools.rampUp01(0, 0.1)
			const color = this.chooseColor(ramp);	
			this.flash(color);			
		}
		else if (tools.isTimeBetween(72, 72.2)) {
			const ramp = tools.rampUp01(0, 0.1)
			const color = this.chooseColor(ramp);	
			this.flash(color);			
		}
		else if (tools.isTimeBetween(105, 105.2)) {
			const ramp = tools.rampUp01(0, 0.1)
			const color = this.chooseColor(ramp);	
			this.flash(color);			
		}
	},
	chooseColor: function(v) {
		return this.palette[Math.round(v * 3)];
	},
	flash: function(color) {
		rect(
				0, 
				0,
				SCREEN.WIDTH,
				SCREEN.HEIGHT,
				color
		);
	}
};

function BOOT() {
	background.init();
	threeD.init();
	scroller.init();
	logo.init();
	alien.init();
	ufo.init();
	columns.init();
	nuke.init();
		
	music(0, 0, 0, false, true, tune.tempo, tune.speed);
};

let previousT = 0;
function TIC() {
	t = time();
	deltaT = t - previousT;
	previousT = t;

	t1000 = t / 1000.0;
	t2000 = t / 2000.0;
	t3000 = t / 3000.0;
	t4000 = t / 4000.0;
	t5000 = t / 5000.0;
	
	t100 = t / 100.0;
	t200 = t / 200.0;
	t300 = t / 300.0;
	t400 = t / 400.0;
	t500 = t / 500.0;
	
	t10 = t / 10.0;
	t20 = t / 20.0;
	t30 = t / 30.0;
	t40 = t / 40.0;
	t50 = t / 50.0;
		
	//hide mouse cursor
	poke(0x3FFB, 0);
	//set border color
	poke(0x3FF8, 0);
	
	cls();
	
	columns.update();
	threeD.update();
	background.update();
	logo.update();
	alien.update();
	ufo.update();
	nuke.update();
	scroller.update();
	
	//terminate on space
	if (key(48)) {
		trace("--::< terminated >::--");
		exit();	
	}
}
// <TILES>
// 000:000000000000cccc000ccccc00cccccc00cc00cc00cc00cc00cc00cc00cc20cc
// 001:00000000cccce000cccccce0cccccce0c00cccce0000ccce0000ccce2000ccce
// 016:00cc20cc00cccccc00cccc0c000ccccc000cc0c0000000000000cc0c0000cccc
// 017:200ccccecccccce0ccccce00ccc0ce00c0c0ce000000ce000c0cce00cccce000
// </TILES>

// <SPRITES>
// 033:0007c0000007c0000007c0000007c0000007c000000000000007c00000000000
// 034:007c7c00007c7c00000000000000000000000000000000000000000000000000
// 035:07c07c000000000007cccc007c0000c07c0000c07c0000c007cccc0000000000
// 039:0007c0000007c000000000000000000000000000000000000000000000000000
// 040:000007c000007c000007c0000007c0000007c00000007c00000007c000000000
// 041:7c00000007c00000007c0000007c0000007c000007c000007c00000000000000
// 043:00000000000000000007c0000007c00007ccccc00007c0000007c00000000000
// 044:00000000000000000000000000000000000000000007c000007cc00000000000
// 045:00000000000000000000000007ccccc000000000000000000000000000000000
// 046:0000000000000000000000000000000000000000007cc000007cc00000000000
// 047:00000000000007c000007c000007c000007c000007c000007c00000000000000
// 048:07cccc007c0000c07c0000c07c0000c07c0000c07c0000c007cccc0000000000
// 049:007cc0000007c0000007c0000007c0000007c0000007c0000007c00000000000
// 050:07cccc007c0007c0000007c0000007c007cccc007c00000007ccccc000000000
// 051:07cccc007c0007c0000007c007cccc00000007c07c0007c007cccc0000000000
// 052:0007cc00007c7c0007c07c007c007c0007ccccc000007c0000007c0000000000
// 054:07cccc007c0007c07c00000007cccc007c0007c07c0007c007cccc0000000000
// 055:07ccc0007c007c0000007c0000007c000007ccc000007c0000007c0000000000
// 056:07cccc007c0007c07c0007c007cccc007c0007c07c0007c007cccc0000000000
// 057:07cccc007c0007c07c0007c007cccc00000007c0000007c007cccc0000000000
// 058:000000000007c0000007c000000000000007c0000007c0000000000000000000
// 063:07cccc007c007c0000007c000007c000007c000000000000007c000000000000
// 064:07c07c000000000007cccc007c0007c07cccccc07c0007c07c0007c000000000
// 065:07cccc007c0007c07c0007c07c0007c07cccccc07c0007c07c0007c000000000
// 066:07ccc0007c007c007c007c007cccc0007c007c007c007c007cccc00000000000
// 067:007cc00007c07c007c0007c07c0000007c0007c007c07c00007cc00000000000
// 068:07ccc0007c007c007c0007c07c0007c07c0007c07c007c0007ccc00000000000
// 069:7ccccc007c0000007c0000007cccc0007c0000007c0000007ccccc0000000000
// 070:7ccccc007c0000007c0000007cccc0007c0000007c0000007c00000000000000
// 071:07cccc007c0007c07c0000007c07ccc07c0007c07c0007c007cccc0000000000
// 072:7c0007c07c0007c07c0007c07cccccc07c0007c07c0007c07c0007c000000000
// 073:0007c0000007c0000007c0000007c0000007c0000007c0000007c00000000000
// 074:0007c0000007c0000007c0000007c0000007c0007c07c00007ccc00000000000
// 075:7c007c007c07c0007c7c00007cc000007c7c00007c07c0007c007c0000000000
// 076:07c0000007c0000007c0000007c0000007c0000007c0000007cccc0000000000
// 077:7cc07cc07c7cc7c07c7cc7c07c0007c07c0007c07c0007c07c0007c000000000
// 078:7c0007c07cc007c07c7c07c07c07c7c07c07c7c07c007cc07c0007c000000000
// 079:07cccc007c0007c07c0007c07c0007c07c0007c07c0007c007cccc0000000000
// 080:07cccc007c0007c07c0007c07c0007c07ccccc007c0000007c00000000000000
// 081:07cccc007c0007c07c0007c07c0007c07c007cc07c07cc0007ccc7c0000007c0
// 082:07cccc007c0007c07c0007c07c0007c07ccccc007c0007c07c0007c000000000
// 083:007ccc0007c007c07c0000007ccccc00000007c07c0007c007cccc0000000000
// 084:7ccccccc0007c0000007c0000007c0000007c0000007c0000007c00000000000
// 085:7c0007c07c0007c07c0007c07c0007c07c0007c07c0007c007cccc0000000000
// 086:7c0007c07c0007c07c0007c007c07c0007c07c00007cc000007cc00000000000
// 087:7c00007c7c00007c7c00007c7c00007c7c07c07c7c7c0c7c07c007c000000000
// 088:7c0007c07c0007c007c07c00007cc00007c07c007c0007c07c0007c000000000
// 089:7c007c007c007c0007c7c000007c0000007c0000007c0000007c000000000000
// 090:07ccccc00c0007c000007c000007c000007c000007c007c07ccccc0000000000
// 096:0000000000000890000089900000899900008989000089990008998900899989
// 097:0000000000889998089999008989909999990899999008999900000090000999
// 098:0000008990000899000008990089909908999089008990890000089999000899
// 099:0000000000000089900000899000089990000899900008999000089990008999
// 100:0000890090089900900899009008990000089989000899990089899908998990
// 101:0000000000000000000000008999900099999900990000009000000800000899
// 102:0898900000899000008990080089908900899999008989999999899099999900
// 103:0000000089990000999000009990000099000000000000000809000008990000
// 104:0000000000000000000000000000000000000000000000000899900000899000
// 105:0000000000000000000000000899008908990089089900898999008989990089
// 106:0000000000000000000000009000000099000008990089999900899999089999
// 107:0000000000000000000000000000000090000000999000009999900089999900
// 112:0899999909999899899908998990089809000099000008990000089900000899
// 113:0008999990899990908999009089990090899900908990009089900000899900
// 114:9990089889990898089908990899089989990089899908998998089989990899
// 115:9000899990008990900089989000899890089998900899909008989099999890
// 116:8999990089999900990899909908990090089900000899900008999000089990
// 117:0000089900090899008990000089900000899900008999000089890000899900
// 118:9999990099899900008989000089890000899900008990000089990000899900
// 119:0899900000899900089999000899900008989900089890000899990008999000
// 120:0089900000089900000899900088999000899900008999000089990000899900
// 121:8989008989990089899900898999900889989089899990890899900808999089
// 122:9808999998089990990089909900899999008999990089999900898999008989
// 123:0008999000089990000899990008998900089999000899900008999000089990
// 128:0000089900000898000008980000089900000899000089990000899900008999
// 129:9089890090899999908999999089900990899900908990000008900090899000
// 130:8999089998990089989900899999008989990899898908989989089889990899
// 131:9999999090099990900089909008999090089999900899899008999090089990
// 132:0000899000089990000089900000899900008989000089890000899900089990
// 133:0089990000898900008989000089999000089990000899900008990000899900
// 134:0089990000899900000899000008990000089900000899000089990000899900
// 135:0899900008999000089999000898990000899000008990000089999000899999
// 136:0008999000089890008999900089999000898900008989000089989099999990
// 137:0899999908998899089999998999989989990089899900898999008989890089
// 138:9000898990008999900089999900089999000899990008999900089990000899
// 139:0008999000089990000899999000899990008989000089899000899990089999
// 144:0000899900008999000008990000089900000899000000000000089900000089
// 145:9089990090899900008999000089900800899008000890000089000000000000
// 146:8989089889990899899908999990089999900089899000000890000900000000
// 147:9008999090008990000089900000899090008990000009000000000000089000
// 148:0008999000008990000089900008999000089900000090000000000000089000
// 149:0089990000899000008998900009900000090000000000000008900000000000
// 150:0089990000899000089999000089990000899900000899000000900000000000
// 151:0088999900008999000000000000089000000090000000000000000000000000
// 152:8988999099999990099999000000000000089000000000000890000000000000
// 153:8989089989990899899908998999089989990089899000088990000000000000
// 154:9000899990008999900089999000898990008998900008990000000000000000
// 155:0008999000089990900089909008999099089990999999808999989000008990
// 224:0000555500055555005555550555555505555555055000550550c00505500005
// 225:555500005555500055555500555555505555555055000550500c055050000550
// 226:000000000000000000000000000000aa00000aab0000aabb0ddddddddddddddd
// 227:000000000000000000000000aa000000baa00000bbaa0000ddddddd0dddddddd
// 240:0555000505555555005555550005555500005500000005550000005500000000
// 241:5000555055555550555555005555500000550000555000005500000000000000
// 242:ddd4dd4d0eeeeeee00dddddd000ddddd00000000000000000000000000000000
// 243:d4dd4dddeeeeeee0dddddd00ddddd00000000000000000000000000000000000
// 244:0000044400000444000004440000044400004444000044440004444400044444
// 245:4400000044000000440000004400000044400000444000004444000044440000
// </SPRITES>

// <WAVES>
// 000:679abdefffffda987421000001134567
// 001:23345789abcddefedba9876655433211
// 002:00000ffffffff000000000ffffffffff
// 004:2468bcddeeedb853112347acddeddd72
// 005:000000ffffffffff7777777777777777
// 006:000000ffffdeff66666000000000c000
// 007:0112223344556678abcddeffffffffff
// </WAVES>

// <SFX>
// 000:02201250228022a032c052d072e092f0b2f0c2f0d2f0e220f200f200f200f200f200f200f200f200f200f200f200f200f200f200f200f200f200f200290000600000
// 001:23f023f023f033a733f8337733f8434753f8633773f88327a3f8c307d3f8f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300212000000000
// 002:4350236003e033f0b3f0d300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300f300307000000000
// 003:33f033f023f013e003e013e023d023c043c043b063a073a0739083908380937093609360a350b350b340c330d330d320e320e310f310f300f300f3002f2000000000
// 016:650005000500050005001500250045006500a500b500d500f500f500f500f500f500f500f500f500f500f500f500f500f500f500f500f500f500f500172000000000
// 032:040004000400040014001400240024003400340044004400540064006400740074008400840094009400a400a400b400c400c400d400d400e400f400402000f1d000
// 033:160026003600460046005600560066007600760086009600960096009600a600a600a600b600b600b600c600c600c600d600d600e600f600f600f600572000000000
// 034:474647563750375d174c072c271c373d374f47005700670077008700a700c700e700f700f700f700f700f700f700f700f700f700f700f700f700f700412000090000
// </SFX>

// <PATTERNS>
// 000:400004400036000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000030000000000000000000000000000010000000400004400036000000000000000010000000000010000010000010000010000010000010000010000010000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
// 001:400004400036000000000000000000000000000000000000b00016000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b00016000030000000000000000000000000000010000000400004400036000010000000000010000000000010000010b00016000000000010000010000010000010000010000010b00016000000000000000000b00016000000000000000000b00016000000000000000000b00016000000000000000000
// 002:400004000000400004000000a00016000020000000000000400004000010400004000020a00016000020000000000010400004000020400004000000a00016000010000000000000400004000000400004000010a00016000000000000000000400004000010400004000000a00016000000000000000010400004000000400004000000a00016000010000000000000400004000000400004000010a00016000000000000000000400004000010400004000000a00016000000000000000010
// 003:400004000000000010000010400004000000000010000000b00016000000000000000000000000000020000000000010400004000000000010000000400004000010000000000000b00016000000000010000010000000000000000010000000400004000010000000000000400004000000000010000010b00016000000000010000000000010000010000000000000400004000000000000000010400004000000000010000000b00016000010000000000000000000000000000000000000
// 004:400004000000000010000010400004000000000010000000b00016000000000000000000000000000020000000000010400004000000000010000000400004000010000000000000b00016000000000010000010000000000000000010000000400004000010000000000000400004000000000010000010b00016000000000010000000000010000010000000000000400004000000000000000010400004000010000010000000b00016000010b00016000000b00016000010b00016000000
// 005:400004000000500004000010400004000000500004000000b00016000000500004000000400004000020500004000010400004000000500004000000400004000010500004000000b00016000000500004000010400004000000500004000000400004000010500004000000400004000000500004000010b00016000000500004000000400004000010500004000000400004000000500004000010400004000000500004000000b00016000010500004000000400004000000500004000000
// 006:400004000000500004000010400004000000500004000000b00016000000500004000000400004000020500004000010400004000000500004000000400004000010500004000000b00016000000500004000010400004000000500004000000400004000010500004000000400004000000500004000010b00016000000500004000000400004000010500004000000400004000000500004000010400004000010500004000000400004000010b00016000000400004000010500004000000
// 009:900822000820900822000820000820000820900822000820000820000820000820000820900822000820900822000820000820000820900822000820000820000820000820000000b00822000820b00822000820000820000000b00822000000000820000820000820000820b00822000820b00822000820000820000000b00822000820000820000820000820000000d00824000000000820000820d00824000000000820000000d00824000820000820000000d00824000000000000000820
// 010:900003000820000820000820000001000820000820000820900003000820000820000820000001000820000820000820900003000820000820000820000001000820000820000000900003000820000820000820000001000000000820000000b00003000820000820000820000001000820000820000820b00003000000000820000820000001000820000820000000b00003000000000820000010000001000000000820000000b00003000820000820000000000001000000000000000820
// 011:800003000820000820000820000001000820000820000820800003000820000820000820000001000820000820000820800003000820000820000820000001000820000820000000800003000820000820000820000001000000000820000000d00003000820000820000820000001000820000820000820d00003000000000820000820000001000820000820000000d00003000000000820000820000001000000000820000000d00003000820000820000000000001000000000000000820
// 012:a00003000001000000000001a00005000001000001000001a00003000001000001000001a00005000820000001000001a00003000000000001000820a00005000001000001000000a00003000000000001000001a00005000000000001000820800003000001000001000000800005000000000001000001800003000000000001000820800005000001000001000820800003000000000820000001800005000000000001000820800003000001000000000000800005000000000820000000
// 013:d00003000001000001000001d00005000001000001000001d00003000001000001000001d00005000820000001000001d00003000000000001000820d00005000001000001000000d00003000000000001000001d00005000000000001000820b00003000001000001000000b00005000000000001000001b00003000000000001000820b00005000001000001000820b00003000000000820000001b00005000001000001000001b00003000001b00005000001b00003000001b00005000000
// 014:900003000001000001000001900005000001000001000001900003000001000001000001900005000820000001000001900003000000000001000820900005000001000001000000900003000000000001000001900005000000000001000820b00003000001000001000000b00005000000000001000001b00003000000000001000820b00005000001000001000820b00003000000000820000001b00005000001000001000001b00003000001000001000001b00005000001000001000000
// 015:800003000001000001000001800005000001000001000001800003000001000001000001800005000820000001000001800003000000000001000820800005000001000001000000800003000000000001000001800005000000000001000820d00003000001000001000000d00005000000000001000001d00003000000000001000820d00005000001000001000820d00003000000000820000001d00005000001000001000001d00003000001000001000001d00005000001000001000000
// 019:a37a08000000000000000000000000000000000000000000000800000000000000000000000800000000000000000000000000000000000000000000000000000000000000000000000800000000000000000000000000000000000000000000800806000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
// 020:a37a08000810000810000810000800000810000810000810000800000810000810000810000810000810000810000810000810000810000810000810000000000000000000000000000800000000000000000000000000000000000000000810800808000810000810000810000000000000000000000000000000000000000000000000000000000000000000000000000810000800000800000800000000000000000810000000000000000810000810000000000000000000000810000000
// 021:d37a08000820000820000820000820000820000820000820000820000820000820000820000820000820000000000820000820000000000820000820000820000820000820000000000820000820000000000820000820000000000820000000b00808000820000820000000000820000820000000000820000820000000000820000820000820000820000820000000000820000000000000000820000820000000000820000000000820000820000000000000000820000000000000000820
// 022:924a08000810000810000810000800000810000810000810000800000810000810000810000810000810000810000810000810000810000810000810000000000000000000000000000800000000000000000000000000000000000000000810b00808000810000810000810000800000000000000000000000800000000000000000000000800000000000000000000000800000800000800000800000000000000000810000000000000000810000810000000000000000000000810000000
// 023:824a08000820000820000820000820000820000820000820000820000820000820000820000820000820000000000820000820000000000820000820000820000820000820000000000820000820000000000820000820000000000820000000d00808000820000820000000000820000820000000000820000820000000000820000820000820000820000820000000000820000000000000000820000820000000000820000000000820000820000000000000000820000000000000000820
// 028:d37a08000820000820000820000820000820000820000820000820000820000820000820000820000820000000000820000820000000000820000820000820000820000820000000000820000820000000000820000820000000000820000000b00808000820000820000000000820000820000000000820000820000000000820000820000820000820000820000000000820000000000000000820000820000000000820000000000820000820000000000000000820000000000000080b20
// 030:a37a28000820000820000820000820000820000820000820a00828000820000820000820000820000810000820000810a00828000810000810000810000820000000000000000000a00828000000000000000000900828000000000000000810800828000810000810000810000820000000000000000000800828000000000000000000000820000000000000000000800828000800000800000800000820000000000810000000000820000810000810000000000820000000000810000000
// 031:d00826000820000820000820000820000820000820000820d00826000820000820000820000820000820000820000820d00826000000000820000820000820000820000820000000d00826000820000820000820c00826000000000820000000b00826000820000820000000000820000820000000000820b00826000000000820000820000820000820000820000000b00826000000000000000820000000000000000820000000000820000820000000000000000820000000000000000820
// 032:937a1800081000081000081090081a000810000810000810000800000810000810000810000810000810000810000810000810000810000810000810000000000000000000000000000800000000000000000000000000000000000000000810b00818000810000810000810b0081a000000000000000000000800000000000000000000000000000000000000000000000810000800000800000800000000000000000810000000000000000810000810000000000000000000000810000000
// 033:837a1800082000082000082080081a000820000820000820000800000820000820000820000820000820000000000820000820000000000820000820000820000820000820000000000820000820000000000820000820000000000820000000d00818000820000820000000d0081a000820000000000820000800000000000820000820000820000820000820000000000820000000000000000820000820000000000820000000000820000820000000000000000820000000000000000820
// 034:537a2a00081000081000081000080000081000081000081000080000081000081000081000081000081000081000081050082c000810000810000810000000000000000000000000000820000000000000000000000000000000000000000810f00828000810000810000810000000000000000000000000000000000000000000000000000000000000000000000000f0082a000800000800000800000000000000000810000000000000000810000810000000000000000000000810000000
// 035:837a2a00082000082000082000082000082000082000082000082000082000082000082000082000082000000000082080082c00000000082000082000082000082000082000000000082000082000000000082000082000000000082000000060082a00082000082000000000082000082000000000082000082000000000082000082000082000082000082000000060082c000000000000000820000820000000000820000000000820000820000000000000000820000000000000000820
// </PATTERNS>

// <TRACKS>
// 000:1430002830004430005830004435105836104435d75836184435d75836186c37587048986c37587048984435d7583d182300ef
// </TRACKS>

// <PALETTE>
// 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76450555029366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
// 001:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76450555029366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
// </PALETTE>

