; A submission to the 'Vintage Computing Christmas Challenge 2023'
; for the 16/48k ZX Spectrum, assembled using sjasmplus assembler.
; https://logiker.com/Vintage-Computing-Christmas-Challenge-2023
;
; Written by spaceWumpus, December 2023.
;
; 

    DEVICE ZXSPECTRUM48

    CSPECTMAP "build/main.map"

ROM_CL_ALL      = $0DAF 			; Address of ROM Routine to clear screen and set cursor to top-left

;   From https://worldofspectrum.net/pub/sinclair/games-info/z/ZXSpectrumAssembler.txt
;       "In the Spectrum, the address of the first character after the REM in a REM
;       statement in line 1 of a program is always 23760, unless microdrives are in use.""

    ;--------------------------------------------------
    org 23760 ; First char after REM in line 1 REM in a BASIC program.
	
    ; Note that SAVE### directives have 'main' listed as entry point.
main:
    ; Init
    ; 6 bytes
        ld de, $fe00 ; Col (D), Row (E)
    ld hl, colMove

outerloop:
    ; Check for next loop (every 4th time, conveniently detected as when E is 0)
    ; 4 Bytes
    xor a
    cp  e
    jr nz, loop

    ; Start next loop
    ; D = column of top cell of loop
    ; 4 bytes
    ld a, d        
    add 6          
    ld d, a        

    ; Check for end and inf loop if so
    ; 4 bytes
    cp 22          
infloop
    jr z, infloop 

    ; Set starting edge length -1 for this edge and store in C
    ; 5 bytes
    ld a, 19 
    sub d    
    ld c, a  
    ld b, a  

loop:
    ; Print * at row E, col D
    ; 10 bytes
    ld a, $16 ; AT
    rst $10
    ld a, e
    rst $10
    ld a,  d
    rst $10
    ld a, '*'
    rst $10

    ; Inc/dec col/row (self-modified)
    ; 2 bytes
colMove:
    ; $14   inc d    ; $15   dec d
    inc d
rowMove:
    ; $1c   inc e    ; $1d   dec d
    inc e

    ; Loop for one edge
    ; 2 bytes
    djnz loop

    ; Get new B count for next edge
    ; Toggle C between 15:3, 9:9, 3:15, and load B from it
    ; 5 bytes
    ld a, 18
    sub c
    ld c, a
    ld b, a

    ; Self-modification
    ; Toggle LSB of byte at HL (flips between increment and decrement), and toggle between colMove and rowMove instruction address
    ; 8 bytes
    ld a, (hl)
    xor $01 ; Flip LSB to toggle instruction between increment and decrement   
    ld (hl), a
    ld a, l
    ; CRITICAL - If address of colMove or rowMove change then this needs to change such that it toggle between their two addresses
    xor $03 ; Toggle between colMove and rowMove
    ld l,a

    ; Main loop
    ; 2 bytes
    jr outerloop

codeEnd

; In debug console:
;   -eval codeEnd - main
; reports
;   52, 34h, 110100b
; So, 52 bytes of code


; Notional top of stack - though stack isn't used in this code.
stack_top:

    ; Deployment, using 'main' as entrypoint
    SAVESNA "main.sna", main
    SAVETAP "main.tap", main

    ; Save machine code out as a code file:
    ; This file contains 2 bytes loading address, then 88 bytes of code:
    SAVETAP "code.tap", CODE, "code", main, $-main

    ; To create REM embedded BASIC version (compo submission):
    ;
    ; 1. In Spectrum emulator, create the following BASIC program (52 digits in first line):
    ;   1 REM 1234567890123456789012345678901234567890123456789012
    ;   2 RANDOMIZE USR 23760
    ;
    ; 2. 'Insert' the 'code.tap' file into the emulator
    ;
    ; 3. Load the assembled code into the REM:
    ;   LOAD "" CODE            J, Ctrl-P, Ctrl-P, Shift-Ctrl, I
    ;
    ; 4. Save the BASIC program with the embedded assembly:
    ;   SAVE "x"
    ;
    ; 5. Run it
    ;   RUN

    ;
    ; Result is standard 19 byte header, followed by 78 bytes of BASIC containing embedded assembly (including flag byte and checksum byte),
    ;  so 76 bytes of combined BASIC loader code + assembly.
