;=======================================================================
; Vintage Computing Christmas Challenge 2023 (VC3 2023) 
; Amstrad CPC / Overflow & Longshot (Logon System)
; December 2023
; 28 bytes 
;=======================================================================
_firm_dispchar	equ #bb5a		; firmware TXT OUTPUT
_firm_locatexy	equ #bb75		; firmware TXT SET CURSOR
orgcode		equ #300-1
sizecode 	equ end_c-start_c

	org orgcode
start_c
				; on run (de=#0040, hl=#abff, af=#ff80 bc=#b0ff)
	inc e 			; E = #41 = 5 + 6*n | 5 would be ok
					; 1st loop for half of the shape
next_half    		; 2nd loop for the other half
        			; then loops for ever on 2nd half
	ld a,c 			; X = #FF = 9 + 6*n for 1st "*" at X=9
	ld b,19	 		; Y dec from 19 to 1
loop
	inc a 			; pre-inc X
	ld h,a 			; X=...
	ld l,b 			; Y=...
	call _firm_locatexy 	; locate X,Y | X-- Y--	
	ld a,h
	cp 19 			; output windows X-1 <19
	ld a,"*"
	call c,_firm_dispchar	; print "*"
	ld a,h
	sub 6			; next "*" is at X-6
	jr nc,loop		; is X still > 0 ?
	sub e 			; updates "*" slide for next line
	djnz loop 		; next line
	ld e,h 			; for next loop E = H = #03 | 3 + 6*n is ok
	jp (hl) 		; jp next_half = #300 = HL
end_c
