; MEGA65 entry for VCCC2023 by GeirS, 2023-12-23
; Size: 46 bytes excl. load address and BASIC stub. Assemble using ACME.

                !cpu m65
                !to "code.prg",cbm

Cint            = $e000             ; Initialize editor and screen
Plot            = $e018             ; Reads or sets the cursor position
Pnt             = $e0               ; Pointer to current screen line
Dirs            = $96               ; Current directions for x and y (0 and 1)
Coords          = $9a               ; Current coordinates for x and y (3 and 0)

                * = $2001           ; Load address
; BASIC stub
                !word NextLine      ; Address of next line
                !word 1337          ; Line number
                !text $fe,$02,"0:"  ; Bank
                !text $9e,"8209"    ; SYS token and address
                !byte 0             ; End of line
NextLine        !word 0

; Code (46 bytes)
                jsr Cint            ; Initialize editor and screen
OuterLoop       ldx #2-1            ; Two coordinates to process (x and y)
InnerLoop       ldy Coords,x        ; Get current coordinate
                beq ToggleDir       ; Branch if minimum value reached
                cpy #18             ; Maximum value reached?
                beq ToggleDir       ; Branch if yes
                tya
                and Dirs            ; Required "randomness"
                cmp #15             ; Force direction change?
                bne AdjustCoord     ; Branch if no
ToggleDir       dec Dirs,x          ; Change direction
AdjustCoord     lda Dirs,x
                lsr                 ; Shift direction bit into carry flag
                bcc Increment
                dey
                !byte $46           ; Instruction 'lsr $c8'
Increment       iny
                sty Coords,x        ; Set new coordinate
                dex
                bpl InnerLoop       ; Loop for both coordinates
                ldx Coords+1        ; Row in x (y already contains column)
                jsr Plot            ; Set cursor position (carry is clear)
                lda #42             ; Asterisk char
                sta (Pnt),y         ; Put on screen
                bra OuterLoop       ; Infinite loop
