; ***************************************************************
; digi player to play 8 bit vector-quantized samples on a C64
; 
; 8 bit analog output method from Pex Mahoney Tufvesson
; thanks also to Tony Savona's infos in the Broken Bytes blogpost
;
; Code by Wil
; V1.1 2023 April
; ***************************************************************

.include "LAMAlib.inc"
.export start_digi_play
.export digiplay_in_progress

timer_value = 125	;for 126 cycles, exactly two rasterlines, 7800 Hz

; pass the high value of the start address of the digi file in A
; low byte of digi address must be $FE
; structure of digi file:
; start at ??FE
; first byte=number of codebook pages (compression_factor)
; second byte=number of digi data pages
; codebook pages a 256 bytes (as many as compression_factor)
; compressed data

start_digi_play:
	do
	  ldy digiplay_in_progress	;wait if there is a digiplay in progress
	loop until eq
	inc digiplay_in_progress

	;A contains highbyte of digi data, store in commands where we use it
	sta compression_addr_high
	sta compression_addr_high2
	sta compression_addr_high3
	sta codebook_reset
	sta codebook_ptr+1
	;calculate highbyte of sample data start
compression_addr_high=*+2
	lda $af00	;high byte will be overwritten with address containing compression factor
	sta recover_compression
	clc
	adc compression_addr_high
	sta codebook_end
	sta sample_ptr+1
	sta get_digilength+1
	sta codebook_backup_high
get_digilength=*+1
	adc $af00	;high byte will be overwritten with address containing compression factor
	sta sample_end
codebook_backup_high=*+2
	lda $af01	;get real codebook value
compression_addr_high2=*+2	
	sta $af00

	poke sample_ptr,2	;samples start at 0xHH02, because first two bytes contain sample length and a codebook value 
	poke codebook_ptr,0	;first sample = code 0

	sei
	lda 1
	sta mem_conf_stored	;save memory configuration value 
	lda #$35
	sta 1	;blank out ROM, keep I/O
	lda $d01a
	sta irq_set_vic_store	;save current interrupt source
	lda $fffe
	sta irq_vec_lo_stored
	lda $ffff
	sta irq_vec_hi_stored	;save interrupt vector

	; initialize SID for 8 bit sample output
	; method by Pex Mahoney Tufvesson
        lda #$00
	for X,$18,downto,0
          sta $d400,x		;clear sid registers
	next
        lda #$0f		;set up attack=0, decay=15
        sta $d405
        sta $d40c
        sta $d413
        lda #$ff		;set up sustain=15, release=15
        sta $d406
        sta $d40d
        sta $d414
        lda #$49		;waveform square, test bit set
        sta $d404
        sta $d40b
        sta $d412
        lda #$ff		;filter cutoff maximum
        sta $d415
        sta $d416
        lda #$03		;voice 1 and 2 through filter
        sta $d417

	;set up ISR play routine
	ldax #digi_play_routine
	stax $fffe

	poke $d01a,0		;disable the VIC chip as raster source
	pokew $dc04,timer_value

	;set up timer

        lda #$81
        sta $dc0d		;set icr/sr to generate irq at timer a underflow
        lda $dc0d		;read icr/sr to clear irs

	;now find a rasterline which is not a badline
	;badline condition: RASTER >= $30 && RASTER <= $f7 && lower three bits of RASTER are equal to YSCROLL

	lda $d011		;load YSCROLL register
	lsr			;lowest bit -> C
	ldx #$11		;load start value into timer and start timer
	lda #1			;mask for BIT
	if cs
		;we need to find an equal rasterline
	  do
	    bit $d012		;test current raster line
	  loop until ne
	  do
	    bit $d012		;test current raster line
	  loop until eq
	  stx $dc0e		;load start value into timer and start timer
	else
		;we need to find an unequal rasterline	
	  do
	    bit $d012		;test current raster line
	  loop until eq
	  do
	    bit $d012		;test current raster line
	  loop until ne
	  stx $dc0e		;load start value into timer and start timer
	endif
	cli		;enable irqs
	rts		;back to the main program
			;the main program can check digiplay_in_progress to determine when the digi is done

digi_play_routine:
	sta stored_A	;save A
codebook_ptr=*+1
	lda $af00       ;load volume level from codebook
	sta $d418
	bit $dc0d	;acknowledge CIA IRQ

codebook_end=*+1
	lda #$af	;comparison value for last codebook page
	sec
	.byte $ef,<(codebook_ptr+1),>(codebook_ptr+1)	;ISC (combination of INC and SBC)
	if eq
codebook_reset=*+1
	  lda #$af
	  sta codebook_ptr+1

	  inc sample_ptr
	  if eq 	
sample_end=*+1
	    lda #$af	;comparison value for end of digi data
	    sec
	    .byte $ef,<(sample_ptr+1),>(sample_ptr+1)	;ISC (combination of INC and SBC)
	    beq end_play_digi
	  endif
sample_ptr=*+1
	  lda $affe	;load next digi value
	  sta codebook_ptr	;into low value of codebook pointer
	endif
stored_A=*+1
	lda #$af
	rti
	
end_play_digi:
recover_compression=*+1
	lda #$af
compression_addr_high3=*+2
	sta $af00	;restore compression value in first byte of digi data
irq_vec_hi_stored=*+1
	lda #$af
	sta $ffff
irq_vec_lo_stored=*+1
	lda #$af
	sta $fffe	;restore interrupt vector
irq_set_vic_store=*+1
	lda #$af
	sta $d01a	;restore interrupt source
mem_conf_stored=*+1
	lda #$af
	sta 1		;restore memory configuration
	lda #0
	sta $d418
	sta digiplay_in_progress
	lda #$7f
	sta $dc0d	;disable timer interrupt
	lda $dc0d	;remove potential pending interrupt
	lda stored_A		
	rti
	
digiplay_in_progress:
.byte 00