/* This is a part of fischinger demoscene project by nikhotmsk and
 * uadmins crew (undefined crew). Nanosvg is written by Mikko Mononen memon@inside.org (mail is broken)
 * and imported from https://github.com/memononen/nanosvg */

#include <err.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#define NANOSVG_IMPLEMENTATION	// Expands implementation
#include "nanosvg-master/src/nanosvg.h"

int main (int argc, char **argv) {
	// Load SVG
	NSVGimage* image;
	if (argc < 2) errx(1, "Hey, give me the SVG file name");
	image = nsvgParseFromFile(argv[1], "mm", 96);
	if (!image) err(2, "nsvgParseFromFile");
	fprintf(stderr, "size: %f x %f\n", image->width, image->height);
	// Use...
	for (NSVGshape *shape = image->shapes; shape != NULL; shape = shape->next) {
		for (NSVGpath *path = shape->paths; path != NULL; path = path->next) {
			fprintf(stdout, "\t; path\n");
			for (int i = 0; i < path->npts-1; i += 3) {
				float* p = &path->pts[i*2];
				int ax = p[0];
				int ay = p[1];
			/*	int bezier_ax = p[2];
				int bezier_ay = p[3];
				int bezier_bx = p[4];
				int bezier_by = p[5]; */
				int bx = p[6];
				int by = p[7];
				
				if (bx == ax && by == ay) continue;
				
				fprintf(stdout, "\t.BYTE %i, %i, ", ax, ay);
				fprintf(stdout, "%i, %i\n", bx, by);
				
				/* fprintf(stderr,
				"bezier (%i %i) (%i %i) (%i %i) (%i %i)\n",
				ax,ay,bezier_ax,bezier_ay,bezier_bx,bezier_by,bx,by); */
				/* drawCubicBez(p[0],p[1], p[2],p[3], p[4],p[5], p[6],p[7]); */
			}
		}
	}
	// Delete
	nsvgDelete(image);
	return 0;
}
