;
;  module.s
;  Synth85
;
;  Created by Stefan Koch on 23.08.16.
;  Copyright (c) 2016 Moods Plateau.
;  All rights reserved.
;

	include "synth85/module.i"

; HL = module ptr
mod_parse:

	; module title
	ld	(mod_title),HL
	ld	A,(HL)
	and	A
	jr	nz,.mod_parse_title_ok

	ld	A,1 ; error
	ret

.mod_parse_title_ok:

	; song attributes
	ld	A,MOD_ATTRIBUTES_OFFSET
	ADD16	H L
	ld	A,(HL)

	ld	(mod_song_attrs),A

	; position count
	inc	HL
	ld	A,(HL)

	and	A
	jr	nz,.mod_parse_pcount_ok

	ld	A,1 ; error
	ret

.mod_parse_pcount_ok:

	ld	(mod_position_count),A

	; position table
	inc	HL
	ld	(mod_position_table),HL

	; pattern data
	ADD16	H L
	ld	(mod_pattern_data),HL

	; reset current position
	ld	A,(mod_position_count)
	dec	A	; last pattern
	ld	(mod_position),A

	; set to last division
	ld	A,MOD_PATTERN_LEN-1
	ld	(mod_division),A

	; set song start flag
	ld	A,1
	ld	(mod_song_start),A

	xor	A ; no error
	ret

; A = position
;
mod_set_position:

	and	A
	jr	nz,.no_zero_pos

	; set start position
	ld	A,(mod_position_count)
	dec	A	; last pattern
	ld	(mod_position),A

	; set song start flag
	ld	A,1
	ld	(mod_song_start),A

	jr	.set_last_division

.no_zero_pos:

	dec	A	; previous pattern
	ld	(mod_position),A

.set_last_division:

	; set to last division
	ld	A,MOD_PATTERN_LEN-1
	ld	(mod_division),A

	ret

; fetch next division data
; DE = destination
mod_fetch:

	push	DE

	; find next division
	ld	A,(mod_division)
	inc	A

	cp	MOD_PATTERN_LEN
	jr	nz,.mod_fetch_next_division

	IF SYNTH85_PATTERN_REPEAT != 0

	; check for pattern repeat
	ld	A,(mod_repeat_pattern)
	and	A
	jr	z,.mod_next_position

	LD	HL,(_mod_divptr)
	LD	DE,-MOD_PATTERN_SIZE+MOD_DIVISION_SIZE
	ADD	HL,DE
	jr	.mod_reset_pattern

.mod_next_position:

	ENDIF

	; get next position
	ld	A,(mod_position)
	ld	HL,mod_position_count
	inc	A
	cp	(HL)
	jr	nz,.skip_position_reset

	; ---------- reset position ----------

	; prevent song end signal
	; right at the beginning
	ld	A,(mod_song_start)
	and	A
	jr	NZ,.continue_fetch

	; signal song end
	ld	HL,SYNTH85_END
	ld	(HL),1

.continue_fetch:

	; reset song start flag
	xor	A
	ld	(mod_song_start),A

	; reset position
	xor	A

.skip_position_reset:

	; store new position
	ld	(mod_position),A

	; ---------- next pattern ----------

	; lookup next pattern
	ld	HL,(mod_position_table)
	ld	B,0
	ld	C,A
	add	HL,BC
	ld	A,(HL)

	; current pattern number
	ld	(SYNTH85_PATTNUM),A

	inc	A	; fix for djnz
	ld	B,A
	ld	HL,(mod_pattern_data)
	ld	DE,MOD_PATTERN_SIZE
	jr	.lookup_loop_start

.lookup_loop:
	add	HL,DE

.lookup_loop_start:
	DJNZ	.lookup_loop

	IF SYNTH85_PATTERN_REPEAT != 0

; HL = pattern pointer
.mod_reset_pattern:

	ENDIF

	; store new divptr
	ld	(_mod_divptr),HL

	; reset division
	xor	A
	ld	(mod_division),A

	jr	.mod_do_fetch

.mod_fetch_next_division:

	; store division
	ld	(mod_division),A

	; find next divptr
	ld	HL,(_mod_divptr)
	ld	BC,MOD_DIVISION_SIZE
	add	HL,BC

	; store new divptr
	ld	(_mod_divptr),HL

.mod_do_fetch:

	; do fetch data
	pop	DE
	ld	BC,MOD_DIVISION_SIZE
	ldir

	ret

SYNTH85_TITLE:
mod_title:
	defw	0

mod_song_attrs:
	defb	0

SYNTH85_POSCOUNT:
mod_position_count:
	defb	0

; ptr to position table
mod_position_table:
	defw	0

; ptr to 1st pattern
mod_pattern_data:
	defw	0

SYNTH85_PATTNUM:
	defb	0

SYNTH85_PATTPOS:
mod_division:
	defb	0

SYNTH85_SONGPOS:
mod_position:
	defb	0

; current division pointer
SYNTH85_DIV_PTR:
_mod_divptr:
	defw	0

; flag for signal song start
mod_song_start:
	defb	0

	IF SYNTH85_PATTERN_REPEAT != 0

; repeat pattern (ignore position table)
mod_repeat_pattern:
	defb	0

	ENDIF
