;
; audio.s
; Framework85
;
; Created by Stefan Koch on 01.04.17.
;
;

; ---------- Channel 0 ----------

; H	Vorteiler
; L	Period
aud_ch0_set:
	LD	A,CTCF_CONTROL|CTCF_RESET|CTCF_TCONST	; Zeitgeber
	BIT	0,H	;Vorteiler?
	JR	Z,.aud_ch0_skip
	OR	CTCF_PRESCALE	;ja
.aud_ch0_skip:
	LD	C,CTC0
	OUT	(C),A
	OUT	(C),L
	RET

aud_ch0_off:
	LD	A,CTCF_CONTROL|CTCF_RESET
	OUT	(CTC0),A
	RET

; ---------- Channel 1 ----------

; H	Vorteiler
; L	Period
aud_ch1_set:
	LD	A,CTCF_CONTROL|CTCF_RESET|CTCF_TCONST	;Zeitgeber
	BIT	0,H	;Vorteiler?
	JR	Z,.aud_ch1_skip
	OR	CTCF_PRESCALE	;ja
.aud_ch1_skip:
	LD	C,CTC1
	OUT	(C),A
	OUT	(C),L
	RET

aud_ch1_off:
	LD	A,CTCF_CONTROL|CTCF_RESET
	OUT	(CTC1),A
	RET

; ---------- Volume ----------

; Sets volume for KC 85/4
;
; A	Volume (0..31 in 16 Stufen)
aud_vol_set:
	AND	31-1	; ensure range, no symmetry reset
	XOR	1EH	; invert. da nullaktiv
	LD	C,A
	IN	A,(PIOB)
	AND	0E1H	; Bereich auf Null setzen
	OR	C	; neuen Wert setzen
	OUT	(PIOB),A;Ltst. ausgeben, ggf. sym. reset
	RET

; Sets volume for KC 85/3
;
; A	Volume (0..31 in 32 Stufen)
aud_vol_set_kc853:
	AND	31	; ensure range
	XOR	1FH	; invert. da nullaktiv
	LD	C,A
	IN	A,(PIOB)
	AND	0E0H	; Bereich auf Null setzen
	OR	C	; neuen Wert setzen
	OUT	(PIOB),A;Ltst. ausgeben, ggf. sym. reset
	RET

; Symmetrie-Flip-Flops zurücksetzen
;
; KC 85/4 only
;
aud_sym_reset:
	IN	A,(PIOB)
	AND	~1
	OUT	(PIOB),A
	OR	1
	OUT	(PIOB),A ; Rücksetzen der Symmetrie-Flip-Flops
	RET
