[BITS 16]
[ORG 0x100]


_start:
	;; Init 320x240x32
	mov ax, 0x4F02
	mov bx, 0x010F
	int 0x10
	;; Set logical line length = 512
	mov ax, 0x4F06
	mov bl, 0x00
	mov cx, 512
	int 0x10

	call _convert_font
	mov ax, 0xA000
	mov es, ax
	mov si, 0x1000
	xor dx, dx
.frame:
	cmp dx, 800 ;; Number of frames to show before quitting
	je _exit
	push dx
	mov ah, 0x06
	mov dl, 0xFF
	int 0x21
	jnz _exit
	pop dx
	inc dx
	mov cx, 200
.line:
	mov ax, cx
	call _request_line

	mov cx, 320
.pixel:
	call _do_pixel
	loopnz .pixel
	
	mov cx, ax
	loopnz .line
	
	jmp .frame

_exit:

	mov ax, 0x4F02
	mov bx, 0x0002
	int 0x10
	mov ax, 0x4C00
	int 0x21


;; AX shall contain the requested line
;; Sets BX to the offset into es that contains the requested line
_request_line:
	mov bx, ax
	pusha
	shr ax, 5
	mov dx, ax
	mov ax, 0x4f05
	xor bx, bx
	int 0x10
	popa
	and bl, 0x1F
	shl bx, 11
	ret



;; Unpacks the font built into BIOS
_convert_font:
	pusha
	mov bx, 0x00FF
	mov ax, 0xFFA6
	mov es, ax
	mov si, 0xE
	mov di, 0x1000
	mov cx, 1024
.convert_loop:
	
	mov dx, cx
	mov cx, 8
	mov al, [es:si]
	inc si
.convert_loop2:
	mov [ds:di], bh
	shl al, 1
	jnc .noone
	mov [ds:di], bl
.noone:
	inc di
	loopnz .convert_loop2
	mov cx, dx
	loopnz .convert_loop
	popa
	ret

;; Expects line in ax
;; Expects line offset in bx
;; Expects column in cx
;; Expects time in dl

_do_pixel:
	pusha

	
	push cx
	shl cx, 2
	add bx, cx
	pop cx


	mov ch, cl
	mov ah, al
	sub ch, dl
	sub ah, dl
	add al, dl
	add cl, dl
	add cl, dl

	push bx
	mov bl, cl
	shr bl, 3
	and bl, 0xF
	xor bh, bh
	add bx, font
	mov bl, [bx]
	
	;; Get font data
	push ax
	xor bh, bh
	shl bx, 6
	and ax, 0x7
	shl al, 3
	add bx, ax
	mov al, cl
	and ax, 0x7
	add bx, ax
	add bx, 0x1000
	mov bl, [bx]
	pop ax

	mov dl, bl
	

	shl edx, 16
	mov dh, ch
	mov dl, ah

	pop bx
	mov [es:bx], edx

	popa
	ret


font: db '/', '/', 'a', 'c', 'h', 't', 'u', 'n', 'g', ' ', 'f', 'u', 'l', 'k', 'o', 'd'
