"use strict";

class TitleScene extends BaseScene {
    // Load resources here
    load(loadingContext) {
        const ctx = loadingContext;
        ctx.loadShader("darkSky", "fullscreen.vert", "darkSky.frag");
        ctx.loadShader("fireEye", "sprite.vert", "fireEye.frag");
        ctx.loadSprite("title", "title.png");
        ctx.loadSprite("groups", "groups.png");
        ctx.loadSprite("present", "present.png");
        ctx.loadSprite("hood", "hood.png");
        ctx.loadSprite("hoodMask", "hoodMask.png");
        ctx.loadSprite("hood", "hood.png");
        ctx.loadSprite("hoodMask", "hoodMask.png");
        ctx.loadSprite("undeadRaven", "undeadRaven.png");
        ctx.loadSprite("bigSkull", "bigSkull.png");
    }

    // One-time initialization at start of scene
    initialize() {
    }

    // This is where the magic happens
    update(renderContext, time) {
        const ctx = renderContext;
        ctx.backgroundShader("darkSky");

        this._drawCastleRavenSkull(time, ctx);
        this._drawHoodedOne(time, ctx);
        this._drawGroups(time, ctx);
        this._drawTitle(time, ctx);
    }

    _drawCastleRavenSkull(time, ctx) {
        if (time > 10)
            return;

        const alpha = this._clamp(1 - (time - 8) / 2, 0, 1)

        // let y = 18 + this._clamp(time, 0, 5); DRAGONGOLD SAYS NO!
        const y = 5;
        let item = new SpriteItem();
        item.name = "bigSkull";
        item.position.x =  120;
        item.position.y = 100 + y;
        item.width = 50;
        item.color.a = alpha;
        ctx.sprite(item);

        item = new SpriteItem();
        item.name = "undeadRaven";
        item.position.x =  130;
        item.position.y = 58 + y;
        item.width = 54;
        item.color.a = alpha;
        ctx.sprite(item);
    }

    _drawGroups(time, ctx) {
        if (time > 10)
            return;

        let item = new SpriteItem();
        item.width = 160;
        item.name = "groups";
        item.position.x =  120;
        item.position.y = 40;
        item.color = { r: 0.37, g: 0.39, b: 0.44, a: 1};
        item.color.a = time < 3 ? this._clamp(time / 3, 0, 1) : this._clamp(1 - (time - 6), 0, 1)
        ctx.sprite(item);

        item = new SpriteItem();
        item.width = 50;
        item.name = "present";
        item.position.x =  120;
        item.position.y = 100;
        item.color = { r: 0.37, g: 0.39, b: 0.44, a: 1};
        item.color.a = time < 5 ? this._clamp((time - 2)/ 3, 0, 1) : this._clamp(1 - (time - 7), 0, 1)
        ctx.sprite(item);
     }

    _drawTitle(time, ctx) {
        if (time < 8)
            return;
        const transparency = time < 10 ? this._clamp((time - 8) / 2, 0, 1) : this._clamp(1 - (time - 16) / 3, 0, 1);

        let item = new SpriteItem();
        item.width = 155;
        item.name = "title";
        item.position.x =  120 + 2;
        item.position.y = 68 + 2;
        item.color = { r: 0, g: 0, b: 0, a: 0.5 * transparency };
        item.rotation = 3 * Math.sin(time) + Math.sin(time*5.1 + 5);
        ctx.sprite(item);

        item = new SpriteItem();
        item.width = 155;
        item.name = "title";
        item.position.x =  120;
        item.position.y = 68;
        item.color = { r: 0.37, g: 0.39, b: 0.44, a: transparency};
        item.rotation = 3 * Math.sin(time) + Math.sin(time*5.1 + 5);
        ctx.sprite(item);
    }

    _drawHoodedOne(time, ctx) {
        const startTime = 10;
        if (time < startTime)
            return;
        
        const transparency = this._clamp((time - startTime) / 1, 0, 1);

        let item = new SpriteItem();
        item.width = 128;
        item.name = "hood";
        item.position.x =  120;
        item.position.y = 80;
        item.color.a = transparency;
        ctx.sprite(item);

        if (time > 16) {
            const anger = 0.8 - 0.35 * Math.abs(Math.sin(time / 5));
            const eyeTransparency = this._clamp((time - 16) / 1, 0, 1);
            const eyeAlpha = eyeTransparency * (1.0 - 0.8 * Math.abs(Math.sin(time / 3)));
            this._drawEye(107, 58, anger, eyeAlpha, 0, ctx);
            this._drawEye(133, 58, anger, eyeAlpha, 0.5, ctx);
            ctx.sprite("hoodMask", 120, 80, 128);
        }
    }



    _drawEye(x, y, anger, alpha, offset, ctx) {
        const item = new SpriteItem();
        item.width = 25;
        item.shaderName = "fireEye";
        item.shaderParameters = {
            anger: anger,
            alpha: alpha,
            offset: offset
        }
        item.position.x = x;
        item.position.y = y;
        ctx.sprite(item);
   }

}