"use strict";

class RainbowScene extends BaseScene {


    load(loadingContext) {
        loadingContext.loadShader("sunnySky", "fullscreen.vert", "sunnySky.frag");
        loadingContext.loadShader("softVignette", "fullscreen.vert", "softVignette.frag");
    }

    initialize() {  
    }

    update(renderContext, time) {
        renderContext.postShader("softVignette");
        renderContext.backgroundShader("sunnySky", {horizonAngle: this._clamp(time/15-0.1,0,0.5)})
    }
}