"use strict";

const GREETS_WIDTH = {
    greets_1: 432,
    greets_2: 397,
    greets_3: 95,
    greets_4: 206,
    greets_5: 206,
    greets_6: 172,
    greets_7: 199,
    greets_8: 206,
    greets_9: 199,
    greets_10: 232,
    greets_11: 281,
    greets_12: 349,
    greets_13: 213
};
const GREETS_NUM = 13;

class RainbowGreetsScene extends BaseScene {


    load(loadingContext) {
        loadingContext.loadShader("sunnySky", "fullscreen.vert", "sunnySky.frag");
        for (let i=1;i <= GREETS_NUM; ++i) {
            loadingContext.loadSprite(`greets_${i}`, `greets_${i}.png`);
        }
    }

    initialize() {  
    }

    update(renderContext, time) {
        const horizonAngle=Math.max(0,Math.min(0.5,(35-time)/30));
        renderContext.backgroundShader("sunnySky", {horizonAngle})

        const greetId=1+Math.floor(time/2);
        if (greetId > GREETS_NUM) return;
        
        const pos = (time/2) % 1;
        const greet = `greets_${greetId}`;
        // we want the path of motion to be along a sine
        // and the time to start fast, end slow, then reverse
        const greetBounce = Math.sin(Math.sin(pos*Math.PI)*2);
        renderContext.sprite(greet, 120, 136-68*greetBounce,GREETS_WIDTH[greet]/2);
    }
}