"use strict";

class EndScene extends BaseScene {


    load(loadingContext) {
        const ctx = loadingContext;
        ctx.loadShader("spotlight", "fullscreen.vert", "spotlight.frag");
        ctx.loadShader("fade", "fullscreen.vert", "fade.frag");
        ctx.loadSprite("finalRaven", "finalRaven.png");
    }

    initialize() {  
    }

    update(renderContext, time) {
        const ctx = renderContext;
        ctx.backgroundShader("spotlight", {
              alpha: 0.94 + 0.05 * this._clamp(time / 4, 0, 1),
              radius: 0.1 + 0.015 * + this._clamp(time / 4, 0, 1),
         });
        ctx.sprite("finalRaven", 120, 82, 40);

        ctx.postShader("fade", {
             alpha: this._clamp(1 - (time - 3) / 2, 0, 1)
        });
        
    }
}