//------------------------------------
// "nanoplay #3: broken vows"
// for "cyan1k" 
// by wacek of arise
//------------------------------------

// init: $1000
// play: $1024

.var tempo 		= $a7
.var counter 	= $a8

			* = $1000	"music_init"
			
music_init:	lda #$03
			sta tempo
			lda #$00
			sta counter
			lda #$0f
			sta $d418
			lda #$a9
			sta $d405
			sta $d406
			sta $d405 + 14
			sta $d406 + 14
			lda #$0c
			sta $d405 + 7
			sta $d406 + 7
			rts

			* = *		"music_play"						
						
music_play: dec tempo 
			bne no_seq_loop
			
			lda #$0e
			sta tempo

play_ch1:	clc
			ldx counter
						
			lda sequence13,x
			and #$f0
			ror
			ror
			ror
			ror
			beq play_ch2

			ldy #0
			jsr load_notes
			jmp !skip+	
				
play_ch2:	lda #$10
			sta $d404

!skip:		lda counter
			and #%11111100
			ror
			ror
			tax

			lda sequence2,x
			beq play_ch3
			
			ldy #7
			jsr load_notes
			jmp !skip+ 

play_ch3:	lda #$10
			sta $d404 + 7
			
!skip:		ldx counter

			lda sequence13,x
			and #$0f
			beq inc_counter

			ldy #14
			jsr load_notes
			jmp !skip+

inc_counter:
			lda #$10
			sta $d404 + 14
			
!skip:		inc counter
			lda counter
			cmp #32
			bne no_seq_loop
						
			lda #0
			sta counter
no_seq_loop:			
			rts			

load_notes:	tax			
			lda	notes_lo,x	
			sta $d400,y	
			lda notes_hi,x	
			sta $d401,y	
			lda #$11	
			sta $d404,y	
notes_lo:	rts	

			//      0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11
			//     -- c-2 c-4 d-4 c-5 g-5 d#4 g#2 g#5 b-1 f-4 b-4

			.byte     $16,$5a,$5a,$b4,$00,$72,$7d,$e9,$db,$d4
notes_hi:	.byte $de
			.byte $04,$10,$12,$20,$31,$13,$06,$33,$03,$15,$1e

// (C-2) c-4 d-4 c-5 g-5 d-4 c-5 g-5
//     1   2   3   4   5   3   4   5
// (C-2) c-4 d#4 c-5 g-5 d#4 c-5 g-5
//     1   2   6   4   5   6   4   5
// (g#2) c-4 d#4 c-5 g#5 d#4 c-5 g#5
//     7   2   6   4   8   6   4   8
// (b-1) d-4 f-4 b-4 g#5 f-4 b-4 g#5
//     9   3   a   b   8   a   b   8

sequence2:	.byte 1,0,1,0,7,0,9	//,0

sequence13:	.byte $00,$02,$30,$04,$50,$03,$40,$05
			.byte $00,$20,$06,$40,$05,$60,$04,$50
			.byte $00,$02,$60,$04,$80,$06,$40,$08
			.byte $00,$30,$0a,$b0,$08,$a0,$0b,$80

//------------------------------------
// all ends here
//------------------------------------