;pure assembly for LoveByte 2023

;ODD FUTURE by Abaddon
;music only for Covox
; code:TomCat / music:ern0

ORG 256

 MOV AX,3508H
 INT 21H
 PUSH ES
 PUSH BX

 MOV DX,IRQ
 MOV AL,90H
 OUT 43H,AL
 ADD AL,97-90H
 CALL init

 SUB AH,AH
 INT 16H
 POP DX
 POP DS
 SALC

init:
 OUT 40H,AL
 MOV AL,0
 OUT 40H,AL
 SALC
 OUT 61H,AL
 MOV AX,2508H
 INT 21H
RETN

; --------------------------- music please ! -------------------------------
IRQ:
 PUSHA
 PUSH DS
 PUSH CS
 POP DS
 MOV SI,COUNTER
 MOV DI,COUNTER+1
 INC DWORD [SI]

 IMUL AX,[DI],-64
 CMP AH,16
 JB .1
 SUB AX,AX
.1:
 MOV BX,AX
 MUL WORD [SI]
 XCHG BX,AX
 AND BH,16

 CALL SAMPLE

 MOV AL,167
.2:
 MUL BH

;CMP [GS:8000H],AH
;JAE @F
;MOV [GS:8000H],AH
;@@:

 SHR AX,8
 JZ ENDIRQ
 OUT 42H,AL			; out the 6bit sample
ENDIRQ:

 MOV AL,20H
 OUT 20H,AL
 POP DS
 POPA
IRET

SAMPLE:
 MOV AX,[DI]
 SHLD CX,AX,16-3		; CX: RANDOM SEED

 MOV BL,63			; BH: SAMPLE
 PUSH AX
 TEST AL,8
 JNZ noBASS
 CALL NOTE
noBASS:

 MOV BL,31
 CALL NOTE0
 PUSH BX
 SUB BH,BH
 SUB WORD [DI],8
 CALL NOTE0
 ADD WORD [DI],8
 POP DX
 SHR BH,1
 ADD BH,DH

 POP AX
 AND AL,7*8
 CMP AL,4*8
 JNE noKICK
 LODSW
 MOV CL,AH
 SHR AX,CL
 AND AL,16
 ADD BH,AL
 RETN
noKICK:

 CMP AL,3*8
 JNE .1
 INC CX
 JPE SEED
 RETN
.1:
 AND AL,3*8
 CMP AL,2*8
 JNE noSNARE

SEED:
 MOV DX,1
 IMUL DX,DX,117
 MOV [SI-COUNTER+SEED+1],DX
 MOV DL,DH

ENV:
 IMUL AX,[SI],-32
 AND DL,BL
 MOV DH,0
 MUL DX
 ADD BH,DL
RETURN:
noSNARE:
noSOLO:
RETN

NOTE0:
 MOV AX,[DI]
 SHR AH,1
 JC noSOLO
 SHL AL,1
 JNC noSOLO
NOTE:
 SHR AL,4
 CMP AL,9
 JA RETURN
 CMP AL,5
 JNE .1
 INC CX
 JPO RETURN
.1:
 AND AX,7
 XCHG BP,AX
 SALC

 MOV DH,3
 AND DX,[DI]
 CMP DH,2
 JNE .2
 SUB BP,8
.2:

 MOV AH,[SI-COUNTER+NOTES+BP]
 MUL WORD [SI]
JMP ENV

COUNTER: DB 0,0,0;DD 0

NOTE2 DB 251,251,0,0,0,188,188,188
NOTES DB 224,224,0,0,0,168,168,168
