;
; (c) MX^Addict 2023 (mxadd@mxadd.org)
;
BITS 32

;
; Resolution
;
WIDTH		 equ 1280
HEIGHT		 equ  720
TOTAL_LENGHT equ (60*1000) ; 60 seconds runtime

;
; Fullscreen ?
;
%define FULLSCREEN

;
; Music ?
;
%define MIDIMUSIC

;
; Misc defines
;
%include "misc.inc"

;
; Data
;

;
; Screen mode settings (only in fullscreen)
; DEVMODE = 
; { 
; 	{0}, 0, 0, sizeof(DEVMODE), 0, DM_PELSWIDTH|DM_PELSHEIGHT, {0}, 0, 0, 0, 0, 0, {0}, 0, 0, XRES, YRES, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
; };
;
%ifdef FULLSCREEN
section _devmode data align=1
devmode:
	times 9 dd 0
	db 0x9c, 0, 0, 0
	db 0, 0, 0x1c, 0
	times 15 dd 0
	dd 020H, WIDTH, HEIGHT
	times 10 dd 0
%endif

;
; Pixel format descriptor
; PIXELFORMATDESCRIPTOR = 
; {
;     sizeof(PIXELFORMATDESCRIPTOR), 1, PFD_DRAW_TO_WINDOW|PFD_SUPPORT_OPENGL|PFD_DOUBLEBUFFER, PFD_TYPE_RGBA, 32, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 32, 0, 0, PFD_MAIN_PLANE, 0, 0, 0, 0
; };
;
section _pfd data align=1
pfd:
	dw  028H
	dw	01H
	dd	025H
	db	00H
	db	020H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	08H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	00H
	db	020H
	db	00H
	db	00H
	db	00H
	db	00H
	dd	00H
	dd	00H
	dd	00H

;
; Shader
;
section _shader data align=1
%include "fragment.inc"
section _shdrptr data align=1
src_main:
	dd _fragment_frag

;
; BSS sections
;
%ifdef MIDIMUSIC
section _midihadle bss align=1
midihandle: resb 4
%endif
	
;
; Code, Main entry
;
section _text text align=1
_start:
	%define ZERO 0
	
	;
	; Switch to fullscreen & create window
	;
%ifdef FULLSCREEN
	FNCALL ChangeDisplaySettingsA, devmode, 4
;	FNCALL ShowCursor, ZERO
	FNCALL CreateWindowExA, ZERO, 0x0000c018, ZERO, 0x91000000, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO, ZERO
%else
	FNCALL CreateWindowExA, ZERO, 0x0000c018, ZERO, 0x90000000, ZERO, ZERO, WIDTH, HEIGHT, ZERO, ZERO, ZERO, ZERO
%endif

	;
	; Initialize OpenGL
	;
	FNCALL GetDC, eax
	mov ebp, eax ; ebp = HDC
	FNCALL ChoosePixelFormat, ebp, pfd
	FNCALL SetPixelFormat, ebp, eax, pfd
	FNCALL wglCreateContext, ebp
	FNCALL wglMakeCurrent, ebp, eax

	;
	; Create main shader and use it
	;
	FNCALL wglGetProcAddress, glCreateShaderProgramv
	FNCALL eax, GL_FRAGMENT_SHADER, 1, src_main
	push eax ; push program ID
	FNCALL wglGetProcAddress, glUseProgram
	FNCALL eax ; will pop program ID

%ifdef MIDIMUSIC
	;
	; Open midi port
	;
	FNCALL midiOutOpen, midihandle, ZERO, ZERO, ZERO, ZERO

	;
	; Reset music counter to return value from midiOutOpen (should be 0 (MMSYSERR_NOERROR))
	;
	mov esi, eax
%endif

	;
	; Fetch start time
	;
	FNCALL GetTickCount
	mov edi, eax ; edi = start time

	;
	; Main loop
	;
	.mainloop:
		;
		; Query time
		;
		FNCALL GetTickCount
		sub eax, edi
		cmp eax, TOTAL_LENGHT
		jge .exit

%ifdef MIDIMUSIC
		;
		; Push for shaders
		;
		push eax
		push eax
		push eax

		;
		; Compare to trigger music every 3500ms
		;
		cmp eax, esi 
		jl .nomusic
			lea esi, [eax+3500]
			FNCALL midiOutShortMsg, dword [midihandle], 0x642A92
			; FNCALL midiOutShortMsg, dword [midihandle], 0x640F90
		.nomusic:

		;
		; Set time as color, arguments are already on stack
		;
		FNCALL glColor3i
%else
		;
		; Set time as color
		;
		FNCALL glColor3i, eax, eax, eax ; eax = # time, will be normalized as float(eax)/INT_MAX...
%endif
	
		;
		; Call shader
		;
		FNCALL glRects, byte -1, byte -1, byte 1, byte 1

		;
		; Swap, process messages & look at ESC key
		;
		FNCALL SwapBuffers, ebp ; ebp = HDC 
		FNCALL PeekMessageA, ZERO, ZERO, ZERO, ZERO, 1 ; PM_REMOVE = 1
		FNCALL GetAsyncKeyState, 27 ; VK_ESCAPE = 27
	jz .mainloop
.exit:
	call ExitProcess
