//
// (c) MX^Addict 2023 (mxadd@mxadd.org)
//

#version 130
#define n(y) vec2(sin((y)*.8),sin((y)*.4))
#define l(v) (.09*(v.x*v.x-v.y*v.y)+.7*-.15*v.z*v.z+.7-.26*-.15+.84*-.11*v.x*v.y+.4*v.x*v.z+.84*-.26*v.y*v.z+-.3*v.x+.4*v.y+-.3*v.z)

///////////////////////////////////////////////////////////////////////////////
// Uniforms

out vec4 o; // Output

///////////////////////////////////////////////////////////////////////////////

// Movement path
/*vec2 path(float z) --> n
{
	return vec2(sin(z * 0.8), sin(z * 0.4));
}*/

// Distance field
float df(vec3 p)
{
	p.xy   += n(p.z);
    p.xz    = cos(p.xz) + sin(p.y*1.9);
    vec2  c = vec2(0.2, -0.5) * cos(p.z * 8.), q = p.xy;
	float k = 1.0, h = 1.0, zz = 0.0;    

    for (; zz++ < 5;)
    {
		h   *= 4.*k;
		k    = dot(q, q);
        q.xy = vec2(q.x * q.x - q.y * q.y, 1.9 * q.x * q.y) + c;
    }

	k = sqrt(k/h)*log(k); 

    return p.y < k ? p.y : k;
}

// Calculate lighting (SH irradiance unwrap)
/*
float calcIrradiance(vec3 nor) --> l
{
    const float i_c1   =  0.42;
    const float i_c2   =  0.51;
    const float i_c3   =  0.74;
    const float i_c4   =  0.88;
    const float i_c5   =  0.24;
    const float i_l00  =  0.79;
    const float i_l1m1 =  0.39;
    const float i_l10  = -0.34;
    const float i_l11  = -0.29;
    const float i_l2m2 = -0.11;
    const float i_l2m1 = -0.26;
    const float i_l20  = -0.15;
    const float i_l21  =  0.56;
    const float i_l22  =  0.21;

    return ((i_c1 * i_l22 * (nor.x * nor.x - nor.y * nor.y) + i_c3 * i_l20 * nor.z * nor.z + i_c4 * i_l00 - i_c5 * i_l20 + 2.0 * i_c1 * i_l2m2 * nor.x * nor.y + 2.0 * i_c1 * i_l21 * nor.x * nor.z + 2.0 * i_c1 * i_l2m1 * nor.y * nor.z + 2.0 * i_c2 * i_l11 * nor.x + 2.0 * i_c2 * i_l1m1 * nor.y + 2.0 * i_c2 * i_l10 * nor.z));
}*/

// Entry
void main()
{
    // Time & UV
    vec2  Res = vec2(1280.0, 720.0), eps = vec2(0.001, 0.0);
    vec2  uv  = (2.0*gl_FragCoord.xy-Res)/Res.y;
    float t   = gl_Color.x*Res.x*Res.y; // Hack on time as color ...
    
    // Camera path
    vec3 rayOrg     = vec3(0.0, 0.4, t);
    vec3 camUp      = vec3(0.0, 1.0, 0.0);
    vec3 camOrg     = vec3(0.0, 0.4, t + 0.1);
         rayOrg.xy -= n(t);
         camOrg.xy -= n(t + 0.05);
    vec3 p          = rayOrg;
	
    // Camera transform
	vec3  axisZ  = normalize(camOrg - rayOrg);
	vec3  axisX  = /*normalize*/(cross(camUp, axisZ));
	vec3  axisY  = /*normalize*/(cross(axisZ, axisX));
	vec3  rayDir = /*normalize*/(axisZ + 0.6 * uv.x * axisX + 0.6 * uv.y * axisY);
    
    // Cast DF
    t = 0;
	for (float zz = 0; zz++ < 250 && t < 20.0;)
	{
		t+= df(p) * 0.2;
		p = rayOrg + rayDir * t;	
	}

    // Calculate normal
    vec3 n = normalize(vec3((sin(p.x * 100.0 + sin(p.z * 30.0) + sin(p.y) * 200.0) * eps.x) + df(p + eps.xyy) - df(p - eps.xyy), df(p + eps.yxy) - df(p - eps.yxy), df(p + eps.yyx) - df(p - eps.yyx)));

    // Calculate AO
	float occ = 0.0;
    for (float zz = 0, sca =-1.0, dsa = 0.1; zz++ < 16;)
    {
        occ += (df(p + n * dsa)-dsa)*sca;
        sca *= 0.95;
        dsa += 0.1;
    }

    // Final mix
    o.rgb = mix(vec3(1.0, 0.7, 0.6) * l(n) * clamp(1.5 - occ, 0.7, 1.0), vec3(1.3, 1.5, 1.6) * l(rayDir), 1.0-exp(-0.03*t*t)); 
}
