; PLOT-Love
; 128B oldschool intro for Lovebyte 2023
; by mike/zeroteam
;
; required: ZX Spectrum 16kB
; recommended: AY chip

CLS		equ	0D6Bh
PLOT		equ	22E5h


		org	24576

		xor	a
		out	(254),a
		ld	a,7
		ld	(iy+85),a
		call	CLS
		ld	a,3
		ld	(iy+87),a	;OVER 1
		ld	de,251*256+7
		call	OUT_AY

LOOP
SEED		ld	hl,0
		ld	a,l
		call	Rand8
		ld	l,a
FIX_Y		ld	a,h
		call	Rand8
		ld	h,a
		cp	175
		jr	nc,FIX_Y
		ld	(SEED+1),hl
		ld	c,l
		ld	b,h
		call	PLOT

C_CHANGE	ld	hl,30*256
		ld	a,l
		or	a
		jr	nz,SLOW_NO

VOL		ld	a,0
		or	a
		jr	z,VOL_NUL
		dec	a
		ld	(VOL+1),a
VOL_NUL		ld	d,a
		ld	e,10
		call	OUT_AY
		ld	a,r
		or	128
		ld	d,a
		ld	e,4
		call	OUT_AY

SLOW_NO
		dec	hl
		ld	(C_CHANGE+1),hl
		ld	a,l
		or	h
		jr	nz,LOOP
		ld	a,31
		ld	(C_CHANGE+2),a
		ld	a,(SEED+2)
		and	7
		or	64
		ld	(iy+85),a
		ld	a,16
		ld	(VOL+1),a
		jr	LOOP

Rand8		ld	b,a		; yes, this is from
		add	a,a		; z80bits by baze/3sc
		add	a,a
		add	a,b
		inc	a
		ret

OUT_AY		ld	bc,65533
		ld	a,e
		out	(c),a
		ld	b,49149/256
		ld	a,d
		out	(c),a
		ret

