
#version 330 core
in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;


uniform sampler2D texture0;
uniform float tim3 = 21.0;
uniform float speedX = -0.1;
uniform float speedY = 0.3;
uniform float video = 0.0;
uniform float value1 = 1.0;
uniform float value2 = 0.5;
uniform float value3 = 2.0;
uniform float value4 = 2.0;
uniform float contrast = 0.025;
uniform float alpha = 1.0;
uniform vec4 color = vec4(1);


float Cell(vec2 c) {
	vec2 uv = fract(c);c -= uv;
	return (1.-length(uv*2.-1.)) * step(fract(sin(c.x+c.y*1e2)*1e3), .027);
}

void main()
{
vec4 colors;
	float t = tim3; 

	vec2 p = texCoord.xy -.5;
	float a = fract(atan(p.x, p.y) / 6.2832);
	float d = 4.*length(p);
	
	vec2 coord = vec2(pow(d, .04), a)*256.;
	vec2 delta = vec2(1. + t*10., 0.1);
	
	float c = Cell(coord-=delta);
	c += Cell(coord-=delta);
	
	fragColor = vec4(c*d*3.);
}