var start      = 0;
var end        = 306;
var duration   = 306;
var layer      = 0;

Demo.prototype.init = function()
{
    Sync.addSync(
    [
        { "name":"shiva_a", "type":"rocket" },
        { "name":"fft_a", "type":"rocket" },
        { "name":"vignette_start", "type":"rocket" },
        { "name":"vignette_end", "type":"rocket" },
        { "name":"tunnel:a", "type":"rocket" },
        { "name":"tunnel:scale", "type":"rocket" },
        { "name":"tunnel:type", "type":"rocket" },
        { "name":"tunnel:fade", "type":"rocket" },
        { "name":"cross:0_rotation", "type":"rocket" },
        { "name":"cross:0_scale", "type":"rocket" },
        { "name":"cross:0_x", "type":"rocket" },
        { "name":"cross:0_y", "type":"rocket" },
        { "name":"cross:0_a", "type":"rocket" },
        { "name":"cross:1_rotation", "type":"rocket" },
        { "name":"cross:1_scale", "type":"rocket" },
        { "name":"cross:1_x", "type":"rocket" },
        { "name":"cross:1_y", "type":"rocket" },
        { "name":"cross:1_a", "type":"rocket" },
        { "name":"cross:2_rotation", "type":"rocket" },
        { "name":"cross:2_scale", "type":"rocket" },
        { "name":"cross:2_x", "type":"rocket" },
        { "name":"cross:2_y", "type":"rocket" },
        { "name":"cross:2_a", "type":"rocket" },
    ]);

    this.loader.addAnimation([
    { 
         "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"begin","storeDepth":false}
    }]);
    
    this.loader.addAnimation({
        "start": start, "duration":end
       ,"layer": layer, "image": ["_embedded/defaultTransparent.png","fft0"]
       ,"shader":{"name":"fft.fs"}
       ,"color":[{"a":"{return Sync.getSyncValue('fft_a');}"}] // 220
   });

   this.loader.addAnimation({
    "start": start, "duration":end
   ,"layer": layer, "image": "shiva.png"
   ,"scale":[{"uniform2d":0.6}]
   ,"position":[{"y":getScreenHeight()*0.4, "x":getScreenWidth()*0.523}]
   ,"color":[{"a":"{return Sync.getSyncValue('shiva_a');}"}] // 120
});

    this.loader.addAnimation({
         "start": start, "duration":end
        ,"layer": layer, "image": ["eye.png"]
        ,"shader":{"name":"tunnel.fs", "variable":[
            {"name":"effectType","value":"{return [Sync.getSyncValue('tunnel:type')];}"}, //0
            {"name":"fade","value":"{return [Sync.getSyncValue('tunnel:fade')];}"} //0.08
        ]}
        ,"scale": [{"uniform2d":"{return Sync.getSyncValue('tunnel:scale');}"}] // 4.0
        ,"color":[{"a":"{return Sync.getSyncValue('tunnel:a');}"}] // 255
    });
    this.loader.addAnimation({
        "start": start, "duration": end
       ,"layer": layer
       ,"image": ["clouds_01.png"]
       ,"scale": [{"uniform2d":10.0}]
       ,"color":[{"a":255}]
       ,"position":[
            {"x":getScreenWidth()*0.9, "y":getScreenHeight()*0.5},
            {"duration": end, "x":getScreenWidth()*0.3}
       ]
    }); 

    this.loader.addAnimation(
    { 
        "start": start, "duration": duration
        ,"layer": layer
        ,"fbo":{"name":"foregroundFbo","action":"unbind"}
    });

    this.loader.addAnimation({
        "start": start, "duration": duration
       ,"layer": layer
       ,"image": ["foregroundFbo.color.fbo"]
   });

   for (var i = 0; i < 3; i++) {
    this.loader.addAnimation({
        "start": start, "duration": end
        ,"layer": layer
        ,"image": ["_embedded/defaultTransparent.png","clouds_01.png","foregroundFbo.color.fbo"]
        ,"shader":{"name":"draw2d.fs", "variable":[
                {"name":"rotation","value":"{return [Sync.getSyncValue('cross:"+i+"_rotation')];}"}
                ,{"name":"scale","value":"{return [Sync.getSyncValue('cross:"+i+"_scale')];}"}
                ,{"name":"x","value":"{return [Sync.getSyncValue('cross:"+i+"_x')];}"}
                ,{"name":"y","value":"{return [Sync.getSyncValue('cross:"+i+"_y')];}"}
            ]}
        ,"color":[{"a":"{return Sync.getSyncValue('cross:"+i+"_a');}"}] // 255
        });
    }
            
    this.loader.addAnimation({
         "start": start, "duration": end
        ,"layer": layer
        ,"image": ["_embedded/defaultTransparent.png"]
        ,"shader":{"name":"vignette.fs", "variable":[
            {"name":"fadeStart","value":"{return [Sync.getSyncValue('vignette_start')];}"} //0.35
           ,{"name":"fadeEnd","value":"{return [Sync.getSyncValue('vignette_end')];}"} //0.5
      ]}
    });
}
